/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.mime;

import java.io.Serializable;
import java.util.regex.Pattern;

public class MimeType
implements Serializable {
    private static final long serialVersionUID = -1324243127744494894L;
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    protected String mediaType = "*";
    protected String subType = "*";
    private int specificity = 1;

    public MimeType(MimeType mimeType) {
        this.mediaType = mimeType.mediaType;
        this.subType = mimeType.subType;
        this.specificity = mimeType.specificity;
    }

    public MimeType(String mimeType) throws IllegalArgumentException {
        if (mimeType == null || mimeType.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid MimeType [" + mimeType + "]");
        }
        String[] parts = mimeSplitter.split(mimeType.trim());
        if (parts.length > 0) {
            this.mediaType = this.getValidMediaType(parts[0]);
        }
        if (parts.length > 1) {
            this.subType = this.getValidSubType(parts[1]);
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getSubType() {
        return this.subType;
    }

    private boolean match(String mimeType) {
        return this.toString().equals(mimeType);
    }

    public int hashCode() {
        return 31 * this.mediaType.hashCode() + this.subType.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MimeType) {
            if (this.mediaType.equals(((MimeType)o).mediaType) && this.subType.equals(((MimeType)o).subType)) {
                return true;
            }
        } else if (o instanceof String) {
            return this.match((String)o);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.mediaType) + "/" + this.subType;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    void setSpecificity(int specificity) {
        this.specificity = specificity;
    }

    private String getValidMediaType(String mediaType) {
        if (mediaType == null || mediaType.trim().length() == 0) {
            return "*";
        }
        return mediaType;
    }

    private String getValidSubType(String subType) {
        if (subType == null || subType.trim().length() == 0 || "*".equals(this.mediaType)) {
            return "*";
        }
        return subType;
    }
}

