/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.CacheTimeOut;
import org.openconcerto.utils.cache.CacheWatcher;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cache.ICacheSupport;

public final class CacheItem<K, V, D> {
    private final ICache<K, V, D> cache;
    private final K key;
    private final Set<D> data;
    @GuardedBy(value="this")
    private Value<V> value;
    @GuardedBy(value="this")
    private RemovalType removalType;
    @GuardedBy(value="this")
    private ScheduledFuture<?> timeout;
    @GuardedBy(value="this")
    private Map<D, CacheWatcher<? super D>> watchers;

    CacheItem(ICache<K, V, D> cache, K key, Set<? extends D> data) {
        this(cache, key, Value.getNone(), data);
    }

    CacheItem(ICache<K, V, D> cache, K key, V value, Set<? extends D> data) {
        this(cache, key, Value.getSome(value), data);
    }

    private CacheItem(ICache<K, V, D> cache, K key, Value<V> value, Set<? extends D> data) {
        this.cache = cache;
        this.key = key;
        this.value = value;
        this.data = Collections.unmodifiableSet(new LinkedHashSet<D>(data));
        this.removalType = null;
    }

    public final ICache<K, V, D> getCache() {
        return this.cache;
    }

    public final Set<D> getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<D, CacheWatcher<? super D>> addToWatchers() {
        ICacheSupport<D> supp = this.getCache().getSupp();
        Map<D, CacheWatcher<D>> watchers = null;
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            block7: {
                if (this.getRemovalType() == null && this.watchers == null) {
                    try {
                        watchers = supp.watch(this.getData(), this);
                        this.watchers = watchers;
                        assert (watchers != null);
                    }
                    catch (RejectedExecutionException e) {
                        this.setRemovalType(RemovalType.CACHE_DEATH);
                        if ($assertionsDisabled || watchers == null) break block7;
                        throw new AssertionError();
                    }
                }
            }
        }
        return watchers;
    }

    public synchronized Map<D, CacheWatcher<? super D>> getWatchers() {
        return this.watchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addTimeout(long delay, TimeUnit unit) {
        ScheduledExecutorService timer = this.getCache().getSupp().getTimer();
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            block8: {
                if (this.getRemovalType() != null) {
                    return;
                }
                if (this.timeout != null) {
                    throw new IllegalStateException("Already has a timeout : " + this.timeout);
                }
                try {
                    this.timeout = timer.schedule(new CacheTimeOut(this), delay, unit);
                    assert (this.timeout != null);
                }
                catch (RejectedExecutionException e) {
                    this.setRemovalType(RemovalType.CACHE_DEATH);
                    if ($assertionsDisabled || this.timeout == null) break block8;
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRemainingTimeoutDelay() {
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            block4: {
                if (this.getRemovalType() == null && this.timeout != null) break block4;
                return -1L;
            }
            return this.timeout.getDelay(TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setRemovalType(RemovalType type) {
        boolean notYetRemoved;
        if (type == null) {
            throw new NullPointerException("Null cause");
        }
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            boolean bl = notYetRemoved = this.getRemovalType() == null;
            if (notYetRemoved) {
                this.removalType = type;
                if (this.timeout != null) {
                    this.timeout.cancel(false);
                }
                if (this.watchers != null) {
                    for (CacheWatcher<D> watcher : this.watchers.values()) {
                        watcher.remove(this);
                    }
                }
            }
        }
        if (notYetRemoved) {
            this.getCache().clear(this);
        }
        return notYetRemoved;
    }

    public final synchronized RemovalType getRemovalType() {
        return this.removalType;
    }

    public final K getKey() {
        return this.key;
    }

    public final synchronized State getState() {
        if (this.getRemovalType() != null) {
            return State.INVALID;
        }
        if (this.value.hasValue()) {
            return State.VALID;
        }
        if (this.timeout != null || this.watchers != null) {
            return State.RUNNING;
        }
        return State.CREATED;
    }

    final synchronized void setValue(V value) {
        if (this.value.hasValue()) {
            throw new IllegalArgumentException("Already set");
        }
        this.value = Value.getSome(value);
    }

    public final synchronized V getValue() {
        return this.value.getValue();
    }

    public final synchronized CacheResult<V> getResult() {
        if (this.getState() == State.VALID) {
            return new CacheResult(this);
        }
        return CacheResult.getNotInCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        State state;
        String val;
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            val = this.value.toString();
            state = this.getState();
        }
        return String.valueOf(this.getClass().getSimpleName()) + " (" + (Object)((Object)state) + ") for " + this.getKey() + " : " + val;
    }

    public static enum RemovalType {
        TIMEOUT,
        DATA_CHANGE,
        SIZE_LIMIT,
        EXPLICIT,
        CACHE_DEATH;

    }

    public static enum State {
        CREATED(false),
        RUNNING(true),
        VALID(true),
        INVALID(false);

        private final boolean active;

        private State(boolean active) {
            this.active = active;
        }

        public final boolean isActive() {
            return this.active;
        }
    }
}

