/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingWorker;

public class JImageAsynchronous
extends JComponent {
    private static final long serialVersionUID = 5840219525266859860L;
    private Image image;
    private boolean centered = true;
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>(1);

    public void load(final File file) {
        new SwingWorker<Image, Object>(){

            @Override
            protected Image doInBackground() throws Exception {
                return ImageIO.read(file);
            }

            @Override
            protected void done() {
                try {
                    JImageAsynchronous.this.setImage((Image)this.get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    private void setImage(Image image) {
        this.image = image;
        this.invalidate();
        this.repaint();
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(null);
        }
    }

    public void addListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void check() {
        if (this.image == null || this.image.getHeight(null) <= 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image == null) {
            super.paintComponent(g);
            return;
        }
        g.setColor(this.getBackground());
        int imageW = this.image.getWidth(null);
        if (!this.centered) {
            g.fillRect(imageW, 0, this.getBounds().width - imageW, this.getBounds().height);
            g.drawImage(this.image, 0, 0, null);
        } else {
            int dx = (this.getBounds().width - imageW) / 2;
            g.fillRect(0, 0, dx, this.getBounds().height);
            g.fillRect(0, 0, dx + imageW, this.getBounds().height);
            g.drawImage(this.image, dx, 0, null);
        }
    }

    public void setCenterImage(boolean t) {
        this.centered = true;
    }
}

