/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class AutoLayouter {
    private GridBagConstraints constraints;
    private int x = 0;
    private int y = 0;
    private final JComponent co;

    public AutoLayouter(JComponent co) {
        this.co = co;
        this.setupConstraints();
        co.setLayout(new GridBagLayout());
    }

    public void add(String desc, JComponent comp) {
        GridBagConstraints c = this.createConstraints();
        if (comp != null) {
            JLabel lab = new JLabel(desc);
            this.co.add((Component)lab, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 3;
            this.co.add((Component)comp, c);
        } else {
            c.fill = 1;
            c.gridwidth = 4;
            JLabel lab = new JLabel(desc);
            lab.setFont(lab.getFont().deriveFont(1, 11.0f));
            this.co.add((Component)lab, c);
        }
        this.newLine();
    }

    private final void newLine() {
        ++this.y;
        this.x = 0;
    }

    public void addLeft(String desc, JComponent comp) {
        if (this.x != 0) {
            this.newLine();
        }
        GridBagConstraints c = this.createConstraints();
        this.co.add((Component)new JLabel(desc), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.gridwidth = 1;
        this.co.add((Component)comp, c);
        this.x = 2;
    }

    public void addRight(String desc, JComponent comp) {
        GridBagConstraints c = this.createConstraints();
        this.co.add((Component)new JLabel(desc), c);
        c.weightx = 1.0;
        ++c.gridx;
        c.gridwidth = 1;
        this.co.add((Component)comp, c);
        this.newLine();
    }

    public void add(JButton btn) {
        this.addRight("", btn);
    }

    private GridBagConstraints createConstraints() {
        GridBagConstraints c = (GridBagConstraints)this.constraints.clone();
        c.gridx = this.x;
        c.gridy = this.y;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        return c;
    }

    private void setupConstraints() {
        this.constraints = new GridBagConstraints();
        this.constraints.ipadx = 8;
        this.constraints.insets = new Insets(2, 5, 0, 0);
        this.constraints.fill = 2;
        this.constraints.weighty = 1.0;
        this.constraints.weightx = 0.0;
    }

    public GridBagConstraints getConstraints() {
        return this.constraints;
    }

    public final JComponent getComponent() {
        return this.co;
    }
}

