/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.ui.TableColumnResizer;
import org.openconcerto.ui.TableRowResizer;
import org.openconcerto.ui.TextAreaRenderer;
import org.openconcerto.ui.TextAreaTableCellEditor;

public class ResizableTable
extends JTable {
    protected MouseInputAdapter rowResizer;
    protected MouseInputAdapter columnResizer = null;

    public ResizableTable() {
    }

    public ResizableTable(TableModel dm) {
        super(dm);
    }

    public void setResizable(boolean row, boolean column) {
        if (row) {
            if (this.rowResizer == null) {
                this.rowResizer = new TableRowResizer(this);
            }
        } else if (this.rowResizer != null) {
            this.removeMouseListener(this.rowResizer);
            this.removeMouseMotionListener(this.rowResizer);
            this.rowResizer = null;
        }
        if (column) {
            if (this.columnResizer == null) {
                this.columnResizer = new TableColumnResizer(this);
            }
        } else if (this.columnResizer != null) {
            this.removeMouseListener(this.columnResizer);
            this.removeMouseMotionListener(this.columnResizer);
            this.columnResizer = null;
        }
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        if (this.getCursor() == TableColumnResizer.resizeCursor || this.getCursor() == TableRowResizer.resizeCursor) {
            return;
        }
        super.changeSelection(row, column, toggle, extend);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public static void main(String[] args) {
        ResizableTable t = new ResizableTable(new DefaultTableModel(10, 5));
        t.setResizable(true, true);
        TableColumnModel cmodel = t.getColumnModel();
        cmodel.getColumn(1).setCellEditor(new TextAreaTableCellEditor(t));
        cmodel.getColumn(1).setCellRenderer(new TextAreaRenderer());
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new GridLayout(1, 1));
        f.getContentPane().add(new JScrollPane(t));
        f.setSize(500, 300);
        ToolTipManager.sharedInstance().unregisterComponent(t);
        ToolTipManager.sharedInstance().unregisterComponent(t.getTableHeader());
        f.show();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.resizeAndRepaint();
    }
}

