/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.openconcerto.utils.cc.ConstantFactory;
import org.openconcerto.utils.cc.ITransformer;

public class PopupMouseListener
extends MouseAdapter {
    private final ITransformer<MouseEvent, JPopupMenu> popup;

    public PopupMouseListener() {
        this((JPopupMenu)null);
    }

    public PopupMouseListener(JPopupMenu menu) {
        this(ConstantFactory.createTransformer(menu));
    }

    public PopupMouseListener(ITransformer<MouseEvent, JPopupMenu> popup) {
        this.popup = popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        JPopupMenu menu;
        if (e.isPopupTrigger() && (menu = this.createPopup(e)) != null && menu.getSubElements().length > 0) {
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected JPopupMenu createPopup(MouseEvent e) {
        return this.popup.transformChecked(e);
    }
}

