/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.VirtualMenu;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.ui.list.selection.ListSelection;
import org.openconcerto.utils.cc.IPredicate;

public interface IListeAction {
    public ButtonsBuilder getHeaderButtons();

    public Action getDefaultAction(ListEvent var1);

    public PopupBuilder getPopupContent(PopupEvent var1);

    public static class ButtonsBuilder {
        static final String GROUPNAME_PROPNAME = "GROUPNAME";
        private static final ButtonsBuilder NO_BUTTONS = new ButtonsBuilder(Collections.emptyMap());
        private final Map<JButton, IPredicate<IListeEvent>> map;
        private String defaultGroup;

        public static final ButtonsBuilder emptyInstance() {
            return NO_BUTTONS;
        }

        public ButtonsBuilder() {
            this(new LinkedHashMap<JButton, IPredicate<IListeEvent>>());
        }

        private ButtonsBuilder(Map<JButton, IPredicate<IListeEvent>> map) {
            this.map = map;
            this.defaultGroup = null;
        }

        public final String getDefaultGroup() {
            return this.defaultGroup;
        }

        public ButtonsBuilder setDefaultGroup(String defaultGroup) {
            this.defaultGroup = defaultGroup;
            return this;
        }

        public final ButtonsBuilder add(JButton btn) {
            return this.add(btn, IPredicate.truePredicate());
        }

        public final ButtonsBuilder add(JButton btn, IPredicate<IListeEvent> pred) {
            return this.add(btn, pred, this.getDefaultGroup());
        }

        public final ButtonsBuilder add(JButton btn, IPredicate<IListeEvent> pred, String group) {
            btn.putClientProperty(GROUPNAME_PROPNAME, group);
            this.map.put(btn, pred);
            return this;
        }

        Map<JButton, IPredicate<IListeEvent>> getContent() {
            return this.map;
        }
    }

    public static class IListeEvent
    extends ListEvent {
        private final IListe list;

        IListeEvent(IListe list, List<SQLRowValues> selection, List<? extends SQLRowAccessor> selectionAccessor) {
            super(list, list.getSource().getElem(), list.getTotalRowCount(), selection, selectionAccessor);
            this.list = list;
        }

        public final ListSelection getSelection() {
            return this.list.getSelection();
        }
    }

    public static class PopupBuilder {
        private static final PopupBuilder EmptyInstance = new PopupBuilder(VirtualMenu.EMPTY);
        private final VirtualMenu rootMenu;

        public static final PopupBuilder emptyInstance() {
            return EmptyInstance;
        }

        public PopupBuilder() {
            this((String)null);
        }

        public PopupBuilder(String defaultGroup) {
            this(VirtualMenu.createRoot(defaultGroup));
        }

        private PopupBuilder(VirtualMenu rootMenu) {
            this.rootMenu = rootMenu;
        }

        public final VirtualMenu getMenu() {
            return this.rootMenu;
        }

        public final String getDefaultGroup() {
            return this.getMenu().getDefaultGroupName();
        }

        final JMenuItem getRootMenuItem(Action defaultAction) {
            String actionCommand = (String)defaultAction.getValue("ActionCommandKey");
            if (actionCommand == null) {
                actionCommand = (String)defaultAction.getValue("Name");
            }
            if (actionCommand == null) {
                return null;
            }
            for (JMenuItem mi : this.getMenu().getItemsAndPath(false).keySet()) {
                if (!actionCommand.equals(mi.getActionCommand())) continue;
                return mi;
            }
            return null;
        }

        public final PopupBuilder addAction(Action a) {
            return this.addAction(a, this.getDefaultGroup());
        }

        public final PopupBuilder addAction(Action a, String group) {
            this.getMenu().addItem(new JMenuItem(a), group);
            return this;
        }

        public final PopupBuilder addItem(JMenuItem mi) {
            return this.addItem(mi, this.getDefaultGroup());
        }

        public final PopupBuilder addItem(JMenuItem mi, String group) {
            this.getMenu().addItem(mi, group);
            return this;
        }

        public final PopupBuilder addItemInSubmenu(JMenuItem mi, String submenu) {
            return this.addItemInSubmenu(mi, this.getDefaultGroup(), submenu, this.getDefaultGroup());
        }

        public final PopupBuilder addItemInSubmenu(JMenuItem mi, String group, String submenu, String submenuGroup) {
            this.getMenu().getSubmenu(submenu, group).addItem(mi, submenuGroup);
            return this;
        }
    }

    public static class PopupEvent
    extends IListeEvent {
        private final boolean clickOnRows;

        PopupEvent(IListe list, List<SQLRowValues> selection, List<? extends SQLRowAccessor> selectionAccessor, boolean clickOnRows) {
            super(list, selection, selectionAccessor);
            this.clickOnRows = clickOnRows;
        }

        public final boolean isClickOnRows() {
            return this.clickOnRows;
        }
    }
}

