/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class QteTotalDocProvider
extends UserInitialsValueProvider {
    private final TypeQteTotalDocProvider type;
    private boolean ha = false;

    public QteTotalDocProvider(TypeQteTotalDocProvider t) {
        this(t, false);
    }

    public QteTotalDocProvider(TypeQteTotalDocProvider t, boolean ha) {
        this.type = t;
        this.ha = ha;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        SQLTable table = row.getTable();
        Collection<? extends SQLRowAccessor> cols = row.getReferentRows(table.getTable(String.valueOf(table.getName()) + "_ELEMENT"));
        BigDecimal total = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : cols) {
            BigDecimal qte;
            BigDecimal prixUnitaire;
            if (sQLRowAccessor.getTable().contains("NIVEAU") && sQLRowAccessor.getInt("NIVEAU") != 1) continue;
            String field = "PV_HT";
            if (this.ha) {
                field = "PA_HT";
            }
            if ((prixUnitaire = sQLRowAccessor.getBigDecimal(field)) == null || prixUnitaire.signum() == 0) continue;
            if (this.type == TypeQteTotalDocProvider.QTE || this.type == TypeQteTotalDocProvider.QTE_KG) {
                if (this.type != TypeQteTotalDocProvider.QTE && sQLRowAccessor.getForeignID("ID_UNITE_VENTE") != 7) continue;
                qte = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE")));
                total = total.add(qte);
                continue;
            }
            if (this.type == TypeQteTotalDocProvider.PDS_BRUT) {
                total = total.add(sQLRowAccessor.getBigDecimal("T_POIDS_BRUT"));
                continue;
            }
            if (this.type == TypeQteTotalDocProvider.QTE_MULT) {
                qte = new BigDecimal(sQLRowAccessor.getInt("QTE"));
                total = total.add(qte);
                continue;
            }
            if (sQLRowAccessor.getObject("NB_COLIS") == null) continue;
            total = total.add(new BigDecimal(sQLRowAccessor.getInt("NB_COLIS")));
        }
        return total;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.qty.multiple.total", new QteTotalDocProvider(TypeQteTotalDocProvider.QTE_MULT));
        SpreadSheetCellValueProviderManager.put("sales.qty.total", new QteTotalDocProvider(TypeQteTotalDocProvider.QTE));
        SpreadSheetCellValueProviderManager.put("purchase.qty.total", new QteTotalDocProvider(TypeQteTotalDocProvider.QTE, true));
        SpreadSheetCellValueProviderManager.put("sales.qty.total.kg", new QteTotalDocProvider(TypeQteTotalDocProvider.QTE_KG));
        SpreadSheetCellValueProviderManager.put("sales.package.total", new QteTotalDocProvider(TypeQteTotalDocProvider.COLIS));
        SpreadSheetCellValueProviderManager.put("sales.package.brut", new QteTotalDocProvider(TypeQteTotalDocProvider.PDS_BRUT));
    }

    private static enum TypeQteTotalDocProvider {
        QTE_KG,
        QTE,
        COLIS,
        PDS_BRUT,
        QTE_MULT;

    }
}

