/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.update.Updater_1_5;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.NumberCellRenderer;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.reports.history.ui.HistoriqueArticleFrame;
import org.openconcerto.erp.core.sales.product.action.InitializeStockPanel;
import org.openconcerto.erp.core.sales.product.action.InventairePanel;
import org.openconcerto.erp.core.sales.product.component.ReferenceArticleSQLComponent;
import org.openconcerto.erp.core.sales.product.element.NouvellesDeclinaisonsFrame;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesMouvementsStockAction;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.FicheArticleXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;

public class ReferenceArticleSQLElement
extends ComptaSQLConfElement {
    public static final int AU_METRE_LONGUEUR = 2;
    public static final int AU_METRE_CARRE = 3;
    public static final int AU_POID_METRECARRE = 4;
    public static final int A_LA_PIECE = 5;
    public static final int AU_METRE_LARGEUR = 6;
    private static final int PRIX_HA = 1;
    private static final int PRIX_VT = 2;
    protected RowAction.PredicateRowAction stock;
    public static final String[] CONDITIONS = new String[]{"CFR", "CIF", "CPT", "DAT", "DDP", "DDU", "EXW", "FCA", "FOB"};

    public ReferenceArticleSQLElement() {
        super("ARTICLE", "un article", "articles");
        RowAction actionConvVirtuel;
        NumerotationAutoSQLElement.addClass(this.getClass(), "ARTICLE");
        this.getRowActions().addAll(new MouseSheetXmlListeListener((SQLElement)this, FicheArticleXmlSheet.class).getRowActions());
        this.stock = new RowAction.PredicateRowAction((Action)new AbstractAction("Mettre \u00e0 jour les stocks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserRightsManager.getCurrentUserRights().canAdd(ReferenceArticleSQLElement.this.getTable().getDBRoot().getTable("STOCK"))) {
                    List<SQLRowAccessor> selectedRows = IListe.get(e).getSelectedRowAccessors();
                    ArrayList<SQLRow> l = new ArrayList<SQLRow>();
                    for (SQLRowAccessor sqlRowValues : selectedRows) {
                        l.add(sqlRowValues.asRow().getForeign("ID_STOCK"));
                    }
                    PanelFrame p = new PanelFrame(new InventairePanel(IListe.get(e), l), "Mise \u00e0 jour des stocks");
                    FrameUtil.show(p);
                } else {
                    JOptionPane.showMessageDialog(null, "Vous n'avez les droits suffisants pour modifier manuellement les stocks!");
                }
            }
        }, true, false);
        this.stock.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(this.stock);
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false) && UserRightsManager.getCurrentUserRights().canAdd(this.getTable().getDBRoot().getTable("STOCK"))) {
            actionConvVirtuel = new RowAction.PredicateRowAction((Action)new AbstractAction("Initialiser les stocks"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelFrame frame = new PanelFrame(new InitializeStockPanel(ReferenceArticleSQLElement.this, IListe.get(e).getSelectedRowAccessors()), "Initialisation du stock");
                    FrameUtil.showPacked(frame);
                }
            }, true, false).setPredicate(ListEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(actionConvVirtuel);
        }
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false)) {
            actionConvVirtuel = new RowAction(new AbstractAction("Convertir en article virtuel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRowAccessor selectedRow = IListe.get(e).getSelectedRowAccessor();
                    try {
                        selectedRow.createEmptyUpdateRow().put("VIRTUEL", Boolean.TRUE).commit();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Erreur lors de la conversion de l'article en virtuel", e1);
                    }
                }
            }, true, false){

                @Override
                public boolean enabledFor(ListEvent evt) {
                    List<? extends SQLRowAccessor> selection = evt.getSelectedRowAccessors();
                    if (selection.size() == 1) {
                        return selection.get(0).getBoolean("VIRTUEL") == false && selection.get(0).isForeignEmpty("ID_ARTICLE_VIRTUEL_PERE");
                    }
                    return false;
                }
            };
            this.getRowActions().add(actionConvVirtuel);
            RowAction actionCreateDecl = new RowAction(new AbstractAction("Cr\u00e9er une d\u00e9clinaison"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRowValues rowVals = ReferenceArticleSQLElement.this.createCopy(IListe.get(e).getSelectedId());
                    ListMap<SQLTable, SQLRow> children = ReferenceArticleSQLElement.this.getChildrenRows(IListe.get(e).getSelectedRowAccessor().asRow());
                    for (SQLRow child : children.allValues()) {
                        Configuration.getInstance().getDirectory().getElement(child.getTable()).createCopy(child, false, rowVals);
                    }
                    rowVals.put("ID_ARTICLE_VIRTUEL_PERE", IListe.get(e).getSelectedId());
                    rowVals.put("VIRTUEL", Boolean.FALSE);
                    EditFrame f = new EditFrame(ReferenceArticleSQLElement.this.createComponent(), EditPanel.EditMode.CREATION);
                    f.getSQLComponent().select(rowVals);
                    FrameUtil.show(f);
                }
            }, true, false){

                @Override
                public boolean enabledFor(ListEvent evt) {
                    List<? extends SQLRowAccessor> selection = evt.getSelectedRowAccessors();
                    if (selection.size() == 1) {
                        return selection.get(0).getBoolean("VIRTUEL");
                    }
                    return false;
                }
            };
            this.getRowActions().add(actionCreateDecl);
            RowAction actionCreateDecls = new RowAction(new AbstractAction("Cr\u00e9er des d\u00e9clinaisons"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRowValues rowVals = ReferenceArticleSQLElement.this.createCopy(IListe.get(e).getSelectedId());
                    SQLRow selectedRow = IListe.get(e).getSelectedRowAccessor().asRow();
                    ListMap<SQLTable, SQLRow> children = ReferenceArticleSQLElement.this.getChildrenRows(selectedRow);
                    for (SQLRow child : children.allValues()) {
                        Configuration.getInstance().getDirectory().getElement(child.getTable()).createCopy(child, false, rowVals);
                    }
                    rowVals.put("ID_ARTICLE_VIRTUEL_PERE", IListe.get(e).getSelectedId());
                    rowVals.put("VIRTUEL", Boolean.FALSE);
                    NouvellesDeclinaisonsFrame f = new NouvellesDeclinaisonsFrame(ReferenceArticleSQLElement.this, selectedRow);
                    f.pack();
                    f.setLocationRelativeTo(null);
                    FrameUtil.show(f);
                }
            }, false, true){

                @Override
                public boolean enabledFor(ListEvent evt) {
                    List<? extends SQLRowAccessor> selection = evt.getSelectedRowAccessors();
                    if (selection.size() == 1) {
                        return selection.get(0).getBoolean("VIRTUEL");
                    }
                    return false;
                }
            };
            this.getRowActions().add(actionCreateDecls);
        }
        RowAction.PredicateRowAction history = new RowAction.PredicateRowAction((Action)new AbstractAction("Historique"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoriqueArticleFrame frame = new HistoriqueArticleFrame(ReferenceArticleSQLElement.this);
                frame.selectId(IListe.get(e).getSelectedId());
                frame.setVisible(true);
            }
        }, false, true);
        history.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(history);
        RowAction.PredicateRowAction mvtStock = new RowAction.PredicateRowAction((Action)new AbstractAction("Consulter les mouvements de stocks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = new ListeDesMouvementsStockAction(ComptaPropsConfiguration.getInstanceCompta(), IListe.get(e).getSelectedRowAccessor()).getFrame();
                frame.setVisible(true);
            }
        }, false, true);
        mvtStock.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(mvtStock);
        RowAction.PredicateRowAction clone = new RowAction.PredicateRowAction((Action)new AbstractAction("Dupliquer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = ReferenceArticleSQLElement.this.createCopy(IListe.get(e).getSelectedId());
                ListMap<SQLTable, SQLRow> children = ReferenceArticleSQLElement.this.getChildrenRows(IListe.get(e).getSelectedRowAccessor().asRow());
                for (SQLRow child : children.allValues()) {
                    Configuration.getInstance().getDirectory().getElement(child.getTable()).createCopy(child, false, rowVals);
                }
                EditFrame f = new EditFrame(ReferenceArticleSQLElement.this.createComponent(), EditPanel.EditMode.CREATION);
                f.getSQLComponent().select(rowVals);
                FrameUtil.show(f);
            }
        }, true, false);
        clone.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(clone);
        RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
        actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionAttachment);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false)) {
            RowAction.PredicateRowAction actionADeclinaison = new RowAction.PredicateRowAction(new AbstractAction("G\u00e9rer les d\u00e9clinaisons"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArrayList<SQLElement> declElts = new ArrayList<SQLElement>();
                    for (SQLTable table : ReferenceArticleSQLElement.this.getTable().getDBRoot().getTables()) {
                        if (!table.getName().startsWith("ARTICLE_DECLINAISON_")) continue;
                        declElts.add(ReferenceArticleSQLElement.this.getDirectory().getElement(table));
                    }
                    JTabbedPane tabs = new JTabbedPane();
                    for (SQLElement elt : declElts) {
                        IListe liste = new IListe(elt.createTableSource());
                        ListeAddPanel panel = new ListeAddPanel(elt, liste);
                        tabs.add(elt.getPluralName(), panel);
                    }
                    JPanel panel = new JPanel(new GridBagLayout());
                    DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                    c.fill = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    panel.add((Component)tabs, c);
                    PanelFrame frame = new PanelFrame(panel, "Liste des d\u00e9clinaisons");
                    FrameUtil.showPacked(frame);
                }
            }, true);
            actionADeclinaison.setPredicate(IListeAction.IListeEvent.createTotalRowCountPredicate(0, Integer.MAX_VALUE));
            this.getRowActions().add(actionADeclinaison);
        }
    }

    @Override
    protected SQLTableModelSourceOnline instantiateTableSourceOnline(ListSQLRequest req) {
        return new SQLTableModelSourceOnline(req, this, ComboSQLRequest.KeepMode.ROW);
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource source) {
        SQLPreferences prefs;
        SQLTableModelColumn paHTCol;
        SQLTableModelColumn pvTTCCol;
        SQLTableModelColumn pvHTCol;
        SQLTableModelColumn pvHT1Col;
        super._initTableSource(source);
        source.getReq().addToGraphToFetch("ID_ARTICLE_VIRTUEL_PERE", "VIRTUEL", "ID_DEPOT_STOCK");
        source.init();
        SQLTableModelColumn pvHA1Col = source.getColumn(this.getTable().getField("PRIX_METRIQUE_HA_1"));
        if (pvHA1Col != null) {
            pvHA1Col.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvHT1Col = source.getColumn(this.getTable().getField("PRIX_METRIQUE_VT_1"))) != null) {
            pvHT1Col.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvHTCol = source.getColumn(this.getTable().getField("PV_HT"))) != null) {
            pvHTCol.setRenderer(CURRENCY_RENDERER);
        }
        if ((pvTTCCol = source.getColumn(this.getTable().getField("PV_TTC"))) != null) {
            pvTTCCol.setRenderer(CURRENCY_RENDERER);
        }
        if ((paHTCol = source.getColumn(this.getTable().getField("PA_HT"))) != null) {
            paHTCol.setRenderer(CURRENCY_RENDERER);
        }
        if ((prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot())).getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false)) {
            BaseSQLTableModelColumn colStockGlobal = new BaseSQLTableModelColumn("Stock Global", BigDecimal.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    BigDecimal totalQte = BigDecimal.ZERO;
                    Collection<? extends SQLRowAccessor> stockElt = r.getReferentRows(ReferenceArticleSQLElement.this.getTable().getTable("STOCK").getField("ID_ARTICLE"));
                    for (SQLRowAccessor sQLRowAccessor : stockElt) {
                        BigDecimal qteCmd = new BigDecimal(sQLRowAccessor.getFloat("QTE_REEL"));
                        totalQte = totalQte.add(qteCmd);
                    }
                    return totalQte;
                }

                @Override
                public Set<FieldPath> getPaths() {
                    Path p2 = (Path)new Path(ReferenceArticleSQLElement.this.getTable()).add(ReferenceArticleSQLElement.this.getTable().getTable("STOCK").getField("ID_ARTICLE"));
                    return CollectionUtils.createSet(new FieldPath(p2, "QTE_REEL"));
                }
            };
            colStockGlobal.setRenderer(new NumberCellRenderer());
            source.getColumns().add(colStockGlobal);
        }
        if (this.getTable().getDBRoot().contains("ARTICLE_ELEMENT") && !this.getTable().getDBRoot().contains("TARIF_AGENCE")) {
            source.getColumns().add(new BaseSQLTableModelColumn("Type", String.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    Collection<? extends SQLRowAccessor> c = r.getReferentRows(ReferenceArticleSQLElement.this.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                    if (c.size() == 0) {
                        return "Article simple";
                    }
                    return "Nomenclature";
                }

                @Override
                public Set<FieldPath> getPaths() {
                    Path p = new Path(ReferenceArticleSQLElement.this.getTable());
                    p = (Path)p.add(ReferenceArticleSQLElement.this.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                    return CollectionUtils.createSet(new FieldPath(p, "QTE"));
                }
            });
        }
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("ID_ARTICLE_VIRTUEL_PERE");
        return s;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            l.add("CODE_BARRE");
        }
        l.add("NOM");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("POIDS");
            l.add("PRIX_METRIQUE_HA_1");
            l.add("PRIX_METRIQUE_VT_1");
        }
        l.add("PA_HT");
        l.add("PV_HT");
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_LIST_TAXE, false)) {
            l.add("ID_TAXE");
        }
        l.add("PV_TTC");
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_LIST_COMPTE, false)) {
            l.add("ID_COMPTE_PCE");
            l.add("ID_COMPTE_PCE_ACHAT");
        }
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_LIST_FAMILLE, false)) {
            l.add("ID_FAMILLE_ARTICLE");
        }
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_LIST_FOURNISSEUR, false)) {
            l.add("ID_FOURNISSEUR");
        }
        l.add("POIDS");
        l.add("SKU");
        l.add("GESTION_STOCK");
        l.add("ID_STOCK");
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            l.add("SERVICE");
        }
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> res = new ListMap<String, String>();
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            res.add(null, "CODE_BARRE");
        }
        ArrayList<String> fieldDecl = new ArrayList<String>();
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false)) {
            for (String fieldName : this.getTable().getFieldsName()) {
                if (!fieldName.startsWith("ID_ARTICLE_DECLINAISON_")) continue;
                fieldDecl.add(fieldName);
            }
        }
        res.addAll(null, "CODE", "NOM", "ID_FAMILLE_ARTICLE", "ID_FOURNISSEUR");
        res.addAll((String)null, (Collection<String>)fieldDecl);
        return res;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            l.add("CODE_BARRE");
        }
        l.add("NOM");
        ArrayList<String> fieldDecl = new ArrayList<String>();
        for (String fieldName : this.getTable().getFieldsName()) {
            if (!fieldName.startsWith("ID_ARTICLE_DECLINAISON_")) continue;
            fieldDecl.add(fieldName);
        }
        l.addAll(fieldDecl);
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("DERNIER_DATE_ACHAT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ReferenceArticleSQLComponent(this);
    }

    public static BigDecimal getPrixHAFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 1);
    }

    public static BigDecimal getPrixVTFromDetails(SQLRowValues rowVals) {
        return ReferenceArticleSQLElement.getValuePiece(rowVals, 2);
    }

    public static float getPoidsFromDetails(SQLRowValues rowVals) {
        float valMetrique3;
        float valMetrique2;
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float produit = valMetrique1 * (valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2")) * (valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3"));
        if (produit > 0.0f) {
            return (float)Math.round(produit * 1000.0f) / 1000.0f;
        }
        if (rowVals.getObject("POIDS") != null) {
            float p = rowVals.getFloat("POIDS");
            return p;
        }
        return 0.0f;
    }

    private static BigDecimal getValuePiece(SQLRowValues rowVals, int value) {
        float valMetrique3;
        if (rowVals.getObject("ID_MODE_VENTE_ARTICLE") == null) {
            throw new IllegalArgumentException("La SQLRowValues ne contient pas ID_MODE_VENTE_ARTICLE");
        }
        int mode = rowVals.getInt("ID_MODE_VENTE_ARTICLE");
        if (mode == 1) {
            mode = 5;
        }
        BigDecimal metrique1HA = rowVals.getObject("PRIX_METRIQUE_HA_1") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PRIX_METRIQUE_HA_1");
        BigDecimal metrique1VT = rowVals.getObject("PRIX_METRIQUE_VT_1") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PRIX_METRIQUE_VT_1");
        float valMetrique1 = rowVals.getObject("VALEUR_METRIQUE_1") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_1");
        float valMetrique2 = rowVals.getObject("VALEUR_METRIQUE_2") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_2");
        float f = valMetrique3 = rowVals.getObject("VALEUR_METRIQUE_3") == null ? 0.0f : rowVals.getFloat("VALEUR_METRIQUE_3");
        if (mode == 3) {
            float surface = valMetrique1 * valMetrique2;
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(surface), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(surface), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 6) {
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(valMetrique2), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(valMetrique2), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 2) {
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(valMetrique1), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(valMetrique1), DecimalUtils.HIGH_PRECISION);
        }
        if (mode == 4) {
            float surface = valMetrique1 * valMetrique2;
            float p = surface * valMetrique3;
            if (value == 1) {
                return metrique1HA.multiply(BigDecimal.valueOf(p), DecimalUtils.HIGH_PRECISION);
            }
            return metrique1VT.multiply(BigDecimal.valueOf(p), DecimalUtils.HIGH_PRECISION);
        }
        if (value == 1) {
            if (rowVals.getObject("PA_HT") != null) {
                return (BigDecimal)rowVals.getObject("PA_HT");
            }
            return BigDecimal.ZERO;
        }
        if (rowVals.getObject("PV_HT") != null) {
            return (BigDecimal)rowVals.getObject("PV_HT");
        }
        return BigDecimal.ZERO;
    }

    public static int getIdForCNM(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, true, createIfNotExist);
    }

    public static int getIdForCN(SQLRowValues row, boolean createIfNotExist) {
        return ReferenceArticleSQLElement.getIdFor(row, false, createIfNotExist);
    }

    private static int getIdFor(SQLRowValues row, boolean includeMetrique, boolean createIfNotExist) {
        SQLTable tableArt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(tableArt);
        String req = ReferenceArticleSQLElement.getMatchRequest(row, includeMetrique);
        List result = (List)eltArticle.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
        if (result != null && result.size() != 0) {
            Object[] tmp = (Object[])result.get(0);
            return ((Number)tmp[0]).intValue();
        }
        if (createIfNotExist && row.getString("CODE") != null && row.getString("CODE").trim().length() > 0 && row.getString("NOM") != null && row.getString("NOM").trim().length() > 0) {
            SQLRowValues vals = new SQLRowValues(row);
            BigDecimal taux = BigDecimal.ONE.add(new BigDecimal(TaxeCache.getCache().getTauxFromId(row.getForeignID("ID_TAXE")).floatValue() / 100.0f));
            vals.put("PV_TTC", vals.getBigDecimal("PV_HT").multiply(taux));
            vals.put("ID_DEPOT_STOCK", DepotStockSQLElement.DEFAULT_ID);
            try {
                int idArticle;
                SQLSelect selMatchingCodeF = new SQLSelect();
                SQLTable table = tableArt.getTable("ARTICLE_FOURNISSEUR");
                selMatchingCodeF.addSelect(table.getKey());
                selMatchingCodeF.addSelect(table.getField("ID_FOURNISSEUR"));
                selMatchingCodeF.addSelect(table.getField("CODE_BARRE"));
                Where wMatchingCodeF = new Where((FieldRef)table.getField("CODE"), "=", (Object)vals.getString("CODE"));
                wMatchingCodeF = wMatchingCodeF.and(new Where((FieldRef)table.getField("NOM"), "=", (Object)vals.getString("NOM")));
                selMatchingCodeF.setWhere(wMatchingCodeF);
                List<SQLRow> l = SQLRowListRSH.execute(selMatchingCodeF, false, false);
                if (l.size() > 0) {
                    SQLRowValues rowVals = l.get(0).asRowValues();
                    vals.put("ID_FOURNISSEUR", rowVals.getObject("ID_FOURNISSEUR"));
                    vals.put("CODE_BARRE", rowVals.getObject("CODE_BARRE"));
                    vals.put("QTE_ACHAT", rowVals.getObject("QTE_ACHAT"));
                    SQLRow rowNew = vals.insert();
                    idArticle = rowNew.getID();
                    rowVals.put("ID_ARTICLE", idArticle);
                    rowVals.commit();
                } else {
                    SQLSelect selMatchingCodeArticle = new SQLSelect();
                    selMatchingCodeArticle.addSelect(tableArt.getKey());
                    Where wMatchingCode = new Where((FieldRef)tableArt.getField("CODE"), "=", (Object)vals.getString("CODE"));
                    wMatchingCode = wMatchingCode.and(new Where((FieldRef)tableArt.getField("NOM"), "=", (Object)vals.getString("NOM")));
                    selMatchingCodeArticle.setWhere(wMatchingCode);
                    List<SQLRow> matchingArticles = SQLRowListRSH.execute(selMatchingCodeArticle, false, false);
                    if (matchingArticles.size() > 0) {
                        idArticle = matchingArticles.get(0).getID();
                    } else {
                        Collection<SQLRowValues> refTarif = row.getReferentRows(row.getTable().getTable("ARTICLE_TARIF_FOURNISSEUR"));
                        if (!refTarif.isEmpty()) {
                            for (SQLRowValues sqlRowValues : refTarif) {
                                SQLRowValues rowValsTarif = new SQLRowValues(sqlRowValues);
                                rowValsTarif.put("ID_ARTICLE", (Object)vals);
                            }
                        }
                        SQLRow rowNew = vals.insert();
                        idArticle = rowNew.getID();
                    }
                }
                return idArticle;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static boolean isArticleForCNExist(SQLRowValues row) {
        return ReferenceArticleSQLElement.isArticleMatchExist(row, false);
    }

    public static boolean isArticleForCNMExist(SQLRowValues row) {
        return ReferenceArticleSQLElement.isArticleMatchExist(row, true);
    }

    private static boolean isArticleMatchExist(SQLRowValues row, boolean includeMetrique) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        String req = ReferenceArticleSQLElement.getMatchRequest(row, includeMetrique);
        List result = (List)eltArticle.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
        return result != null && result.size() != 0;
    }

    private static String getMatchRequest(SQLRowValues row, boolean includeMetrique) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLSelect sel = new SQLSelect(eltArticle.getTable().getBase());
        sel.addSelect(eltArticle.getTable().getField("ID"));
        Where w = new Where((FieldRef)eltArticle.getTable().getField("CODE"), "=", (Object)row.getString("CODE").trim());
        if (includeMetrique) {
            float value1 = ((Number)row.getObject("VALEUR_METRIQUE_1")).floatValue();
            float value2 = ((Number)row.getObject("VALEUR_METRIQUE_2")).floatValue();
            float value3 = ((Number)row.getObject("VALEUR_METRIQUE_3")).floatValue();
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), "<=", (Object)new Float((double)value1 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_1"), ">=", (Object)new Float((double)value1 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), "<=", (Object)new Float((double)value2 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_2"), ">=", (Object)new Float((double)value2 - 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), "<=", (Object)new Float((double)value3 + 1.0E-5)));
            w = w.and(new Where((FieldRef)eltArticle.getTable().getField("VALEUR_METRIQUE_3"), ">=", (Object)new Float((double)value3 - 1.0E-5)));
        }
        sel.setWhere(w);
        return sel.asString();
    }

    public static boolean isReferenceEquals(SQLRowValues rowVals1, SQLRowValues rowVals2) {
        return rowVals1.getObject("CODE").equals(rowVals2.getObject("CODE")) && rowVals1.getString("VALEUR_METRIQUE_1").equals(rowVals2.getString("VALEUR_METRIQUE_1")) && rowVals1.getString("VALEUR_METRIQUE_2").equals(rowVals2.getString("VALEUR_METRIQUE_2")) && rowVals1.getString("VALEUR_METRIQUE_3").equals(rowVals2.getString("VALEUR_METRIQUE_3"));
    }

    public void initStock(int id) {
        SQLRow row = this.getTable().getRow(id);
        Updater_1_5.initStock(row);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".ref";
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.addToGraphToFetch("ID_DEPOT_STOCK");
        req.setWhere(new Where((FieldRef)this.getTable().getField("VIRTUEL"), "=", (Object)Boolean.FALSE));
    }

    public static void updateDateAchat(SQLTable tableArticle, SQLRow article) {
        assert (article == null || article.getTable() == tableArticle);
        SQLTable tableTarifF = tableArticle.getTable("ARTICLE_TARIF_FOURNISSEUR");
        String up = "UPDATE " + tableArticle.getSQLName().quote() + " a SET " + tableArticle.getField("DERNIER_DATE_ACHAT").getQuotedName();
        up = String.valueOf(up) + " =(select MAX(" + tableTarifF.getField("DATE_PRIX").getQuotedName() + ")  ";
        up = String.valueOf(up) + " FROM " + tableTarifF.getSQLName().quote() + "  t" + " WHERE (t." + tableTarifF.getKey().getQuotedName() + " <> 1) ";
        up = String.valueOf(up) + " AND (t." + tableTarifF.getField("ARCHIVE").getQuotedName() + " = 0) ";
        up = String.valueOf(up) + "AND t." + tableTarifF.getField("ID_ARTICLE").getQuotedName() + " = " + (article == null ? "a." + tableArticle.getKey().getQuotedName() : Integer.valueOf(article.getID())) + ")";
        if (article != null) {
            up = String.valueOf(up) + "WHERE " + tableArticle.getKey().getQuotedName() + " = " + article.getID();
        }
        tableArticle.getDBSystemRoot().getDataSource().execute(up);
    }

    public void createDeclinaison(int idArticlePere, List<Tuple2<SQLRow, SQLRow>> tupleTailleCouleur) throws SQLException {
        SQLRow row = this.getTable().getRow(idArticlePere);
        if (!row.getBoolean("VIRTUEL").booleanValue()) {
            throw new IllegalArgumentException("L'article n'est pas un article virtuel");
        }
        ListMap<SQLTable, SQLRow> children = this.getChildrenRows(row);
        for (Tuple2<SQLRow, SQLRow> t : tupleTailleCouleur) {
            SQLRowValues rowVals = this.createCopy(idArticlePere);
            for (SQLRow child : children.allValues()) {
                Configuration.getInstance().getDirectory().getElement(child.getTable()).createCopy(child, false, rowVals);
            }
            rowVals.put("ID_ARTICLE_VIRTUEL_PERE", idArticlePere);
            rowVals.put("VIRTUEL", Boolean.FALSE);
            rowVals.put("ID_ARTICLE_DECLINAISON_TAILLE", t.get0().getID());
            rowVals.put("ID_ARTICLE_DECLINAISON_COULEUR", t.get1().getID());
            rowVals.commit();
        }
    }
}

