/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.reports.history.ui.ListeHistoriquePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.state.WindowStateManager;

public class ListeTarifClient {
    private PanelFrame panelFrame;
    private ListeHistoriquePanel listPanel;

    public ListeHistoriquePanel getHistoriquePanel() {
        return this.listPanel;
    }

    public ListeTarifClient(DBRoot root) {
        LinkedHashMap<String, List<String>> mapList = new LinkedHashMap<String, List<String>>();
        mapList.put("Tarifs", Arrays.asList("ARTICLE_TARIF"));
        ComboSQLRequest request = new ComboSQLRequest(root.getTable("TARIF"), Arrays.asList("NOM"));
        request.setFieldSeparator(" ");
        this.listPanel = new ListeHistoriquePanel("Tarifs", request, mapList, null, null, null, true, null, null);
        this.panelFrame = new PanelFrame(this.listPanel, "Tarifs");
        this.panelFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ListeTarifClient.this.listPanel.removeAllTableListener();
            }
        });
        this.panelFrame.setDefaultCloseOperation(2);
    }

    public void setSelectedId(int id) {
        this.listPanel.selectIDinJList(id);
    }

    public PanelFrame getFrame() {
        this.panelFrame.setIconImages(Gestion.getFrameIcon());
        WindowStateManager stateManager = new WindowStateManager(this.panelFrame, new File(Configuration.getInstance().getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + "TarifArticleClient.xml"), true);
        this.panelFrame.setDefaultCloseOperation(2);
        this.panelFrame.pack();
        this.panelFrame.setLocationRelativeTo(null);
        stateManager.loadState();
        return this.panelFrame;
    }
}

