/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TransfertStockPanel
extends JPanel {
    private final String mvtStockTableQuoted;
    private static String defaultLabel = "Transfert de stock";

    public TransfertStockPanel(final Configuration instance) {
        super(new GridBagLayout());
        final JButton buttonUpdate = new JButton("Mettre \u00e0 jour");
        final SQLTable mvtStockTable = instance.getRoot().findTable("MOUVEMENT_STOCK");
        this.mvtStockTableQuoted = mvtStockTable.getSQLName().quote();
        SQLElement articleElt = instance.getDirectory().getElement("ARTICLE");
        final SQLRequestComboBox comboArticle = new SQLRequestComboBox();
        comboArticle.uiInit(articleElt.createComboRequest());
        SQLElement stockElt = instance.getDirectory().getElement("DEPOT_STOCK");
        final SQLRequestComboBox comboStockDepart = new SQLRequestComboBox();
        comboStockDepart.uiInit(stockElt.createComboRequest());
        final SQLRequestComboBox comboStockArrive = new SQLRequestComboBox();
        comboStockArrive.uiInit(stockElt.createComboRequest());
        final NumericTextField fieldReel = new NumericTextField();
        fieldReel.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboArticle.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboStockArrive.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        comboStockDepart.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockPanel.this.updateButtons(buttonUpdate, comboArticle, comboStockDepart, comboStockArrive, fieldReel);
            }
        });
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        this.add((Component)new JLabel("Intitul\u00e9"), c);
        final JTextField label = new JTextField();
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)label, c);
        label.setText(defaultLabel);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Date", 4), c);
        final JDate date = new JDate(true);
        ++c.gridx;
        this.add((Component)date, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Article", 4), c);
        ++c.gridx;
        this.add((Component)comboArticle, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9part", 4), c);
        ++c.gridx;
        this.add((Component)comboStockDepart, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Arriv\u00e9e", 4), c);
        ++c.gridx;
        this.add((Component)comboStockArrive, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Quantit\u00e9", 4), c);
        ++c.gridx;
        this.add((Component)fieldReel, c);
        ++c.gridy;
        c.gridx = 0;
        JButton buttonCancel = new JButton("Annuler");
        JPanel pButton = new JPanel();
        pButton.add(buttonCancel);
        pButton.add(buttonUpdate);
        c.gridwidth = 2;
        c.anchor = 14;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)pButton, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(TransfertStockPanel.this)).dispose();
            }
        });
        buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buttonUpdate.setEnabled(false);
                final BigDecimal qteReel = fieldReel.getValue();
                final ArrayList multipleRequestsHundred = new ArrayList(100);
                final boolean usePrice = mvtStockTable.contains("PRICE");
                final ArrayList stockItems = new ArrayList();
                final Date dateValue = date.getValue();
                final SQLRow selectedRowArticle = comboArticle.getSelectedRow();
                final SQLRow selectedRowDepotDepart = comboStockDepart.getSelectedRow();
                final SQLRow selectedRowDepotArrivee = comboStockArrive.getSelectedRow();
                try {
                    SQLUtils.executeAtomic(selectedRowDepotDepart.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws SQLException {
                            SQLRowAccessor rowStockDepart = ProductComponent.findOrCreateStock(selectedRowArticle, selectedRowDepotDepart);
                            StockItem item = new StockItem(selectedRowArticle, rowStockDepart);
                            if (!item.isStockInit()) {
                                SQLRowValues rowVals = new SQLRowValues(mvtStockTable.getTable("STOCK"));
                                rowVals.put("ID_ARTICLE", selectedRowArticle.getID());
                                rowVals.put("ID_DEPOT_STOCK", selectedRowDepotDepart.getID());
                                rowVals.commit();
                                selectedRowArticle.fetchValues();
                                item = new StockItem(selectedRowArticle, rowStockDepart);
                            }
                            stockItems.add(item);
                            double diff = -qteReel.doubleValue();
                            item.updateQty(diff, StockItem.TypeStockMouvement.REEL);
                            multipleRequestsHundred.add(TransfertStockPanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, TransfertStockPanel.this.getLabel(label.getText(), selectedRowDepotDepart, selectedRowDepotArrivee), true, usePrice));
                            item.updateQty(diff, StockItem.TypeStockMouvement.THEORIQUE);
                            multipleRequestsHundred.add(TransfertStockPanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, TransfertStockPanel.this.getLabel(label.getText(), selectedRowDepotDepart, selectedRowDepotArrivee), false, usePrice));
                            multipleRequestsHundred.add(item.getUpdateRequest());
                            SQLRowAccessor rowStockArrivee = ProductComponent.findOrCreateStock(selectedRowArticle, selectedRowDepotArrivee);
                            item = new StockItem(selectedRowArticle, rowStockArrivee);
                            if (!item.isStockInit()) {
                                SQLRowValues rowVals = new SQLRowValues(mvtStockTable.getTable("STOCK"));
                                rowVals.put("ID_ARTICLE", selectedRowArticle.getID());
                                rowVals.put("ID_DEPOT_STOCK", selectedRowDepotArrivee.getID());
                                rowVals.commit();
                                selectedRowArticle.fetchValues();
                                item = new StockItem(selectedRowArticle, rowStockArrivee);
                            }
                            stockItems.add(item);
                            diff = qteReel.doubleValue();
                            item.updateQty(diff, StockItem.TypeStockMouvement.REEL);
                            multipleRequestsHundred.add(TransfertStockPanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, TransfertStockPanel.this.getLabel(label.getText(), selectedRowDepotDepart, selectedRowDepotArrivee), true, usePrice));
                            item.updateQty(diff, StockItem.TypeStockMouvement.THEORIQUE);
                            multipleRequestsHundred.add(TransfertStockPanel.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, TransfertStockPanel.this.getLabel(label.getText(), selectedRowDepotDepart, selectedRowDepotArrivee), false, usePrice));
                            multipleRequestsHundred.add(item.getUpdateRequest());
                            int size = multipleRequestsHundred.size();
                            ArrayList<Object> handlers = new ArrayList<Object>(size);
                            int i = 0;
                            while (i < size) {
                                handlers.add(null);
                                ++i;
                            }
                            SQLUtils.executeMultiple(instance.getRoot().getDBSystemRoot(), multipleRequestsHundred, handlers);
                            DBRoot root = mvtStockTable.getDBRoot();
                            if (root.contains("ARTICLE_ELEMENT")) {
                                ComposedItemStockUpdater comp = new ComposedItemStockUpdater(root, stockItems);
                                comp.update();
                            }
                            return null;
                        }
                    });
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Stock update error", e1);
                }
                ((JFrame)SwingUtilities.getRoot(TransfertStockPanel.this)).dispose();
            }
        });
    }

    private String getLabel(String label, SQLRowAccessor fromDepot, SQLRowAccessor toDepot) {
        return String.valueOf(label) + " de " + fromDepot.getString("NOM") + " vers " + toDepot.getString("NOM");
    }

    private String getMvtRequest(Date time, BigDecimal prc, double qteFinal, StockItem item, String label, boolean reel, boolean usePrice) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String mvtStockQuery = "INSERT INTO " + this.mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"ID_STOCK\",\"NOM\",\"REEL\",\"ORDRE\"";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + ",\"PRICE\"";
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ") VALUES(" + qteFinal + ",'" + dateFormat.format(time) + "'," + item.getArticle().getID() + "," + item.stock.getID() + ",'" + label + "'," + reel + ", (SELECT (MAX(\"ORDRE\")+1) FROM " + this.mvtStockTableQuoted + ")";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + "," + prc.setScale(6, RoundingMode.HALF_UP).toString();
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ")";
        return mvtStockQuery;
    }

    private void updateButtons(JButton buttonUpdate, SQLRequestComboBox comboArticle, SQLRequestComboBox comboStockDepart, SQLRequestComboBox comboStockArrive, NumericTextField fieldReel) {
        buttonUpdate.setEnabled(fieldReel.getText().trim().length() > 0 && comboArticle.getSelectedRow() != null && comboStockArrive.getSelectedRow() != null && comboStockDepart.getSelectedRow() != null && comboStockArrive.getSelectedRow().getID() != comboStockDepart.getSelectedRow().getID());
    }
}

