/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom2.JDOMException;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.TicketSheetXML;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.RegisterSummary;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPrinter;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.ExceptionHandler;

public class ListeDesTicketsPanel
extends JPanel
implements ListSelectionListener {
    private static final String ARIAL_FONT = "Arial";
    private JList l;
    private CaisseFrame frame;
    private TextAreaTicketPrinter ticketP;
    private ScrollableList ticketList;
    private DefaultListModel ticketLlistModel;

    ListeDesTicketsPanel(CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        StatusBar p = new StatusBar();
        p.setTitle("Liste des tickets");
        p.setLayout(new FlowLayout(2));
        POSButton bBack = new POSButton("Fermer");
        p.add(bBack);
        this.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 2;
        try {
            RegisterLog lastLog = this.frame.getFiles().getLastLog();
            List<Ticket> receipts = lastLog.parseReceipts();
            this.ticketLlistModel = new DefaultListModel();
            this.ticketLlistModel.addElement(new X(lastLog, receipts));
            this.ticketLlistModel.addElement(new XLite(lastLog, receipts));
            Date previousDate = lastLog.getFirstRegisterEvent().getPreviousDate();
            if (previousDate != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(previousDate);
                this.ticketLlistModel.addElement(new Z(this.frame.getFiles(), cal));
            }
            this.ticketLlistModel.addAll(receipts);
        }
        catch (Exception exn) {
            ExceptionHandler.handle(this.frame, "Impossible de charger les tickets", exn);
        }
        final Font f = new Font(ARIAL_FONT, 0, 24);
        this.ticketList = new ScrollableList(this.ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (object instanceof Ticket) {
                    Ticket article = (Ticket)object;
                    String label = "Ticket " + article.getCode();
                    String euro = String.valueOf(TicketCellRenderer.centsToString(article.getTotalInCents())) + "\u20ac";
                    int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                    g.drawString(label, 10, posY + 39);
                    g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 39);
                } else {
                    g.drawString(((RegisterSummary)object).getLabel(), 10, posY + 39);
                }
            }
        };
        this.add((Component)this.ticketList, c);
        c.fill = 3;
        c.weightx = 0.0;
        ++c.gridx;
        c.gridheight = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.ticketP = new TextAreaTicketPrinter();
        JScrollPane scrollPane = new JScrollPane(this.ticketP);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.setMinimumSize(new Dimension(400, 200));
        this.add((Component)scrollPane, c);
        this.ticketList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue = ListeDesTicketsPanel.this.ticketList.getSelectedValue();
                ListeDesTicketsPanel.this.setSelectedTicket(selectedValue);
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        final Font font = new Font(ARIAL_FONT, 0, 32);
        this.l = new JList<String>(new String[]{"Imprimer la facture", "Imprimer le ticket", "Annuler le ticket"});
        this.l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = new JLabel(value.toString()){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(0, 0, this.getWidth(), 0);
                    }
                };
                l.setFont(font);
                return l;
            }
        });
        this.l.setSelectionMode(0);
        this.l.getSelectionModel().addListSelectionListener(this);
        this.l.setFixedCellHeight(100);
        this.add((Component)this.l, c);
        this.setFont(new Font(ARIAL_FONT, 1, 24));
        bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesTicketsPanel.this.frame.showCaisse();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object selectedValue = this.ticketList.getSelectedValue();
        int selectedIndex = this.l.getSelectedIndex();
        if (selectedIndex == 0 && selectedValue != null) {
            if (selectedValue instanceof Ticket) {
                Ticket ticket = (Ticket)selectedValue;
                TicketSheetXML bSheet = new TicketSheetXML(ticket, ComptaPropsConfiguration.getInstanceCompta());
                try {
                    bSheet.createDocument();
                    bSheet.showPrintAndExport(true, false, false, Collections.emptyList());
                }
                catch (Exception originalExn) {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de la facture", originalExn);
                }
            }
        } else if (selectedIndex == 1 && selectedValue != null) {
            this.frame.getPOSConf().printOnceOnFirstPrinter((Printable)selectedValue);
        } else if (selectedIndex == 2 && selectedValue != null && selectedValue instanceof Ticket) {
            Ticket t = (Ticket)selectedValue;
            this.frame.getControler().cancel(t);
        }
        this.l.clearSelection();
    }

    public void setSelectedTicket(Object selectedValue) {
        this.ticketP.clear();
        if (selectedValue != null) {
            this.frame.getPOSConf().print((Printable)selectedValue, new TicketPrinterConfiguration(){

                @Override
                public TicketPrinter createTicketPrinter() {
                    return ListeDesTicketsPanel.this.ticketP;
                }

                @Override
                public int getCopyCount() {
                    return 1;
                }

                @Override
                public boolean isValid() {
                    return true;
                }
            });
            try {
                this.ticketP.printBuffer();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.ticketList.setSelectedValue(selectedValue, true);
    }

    private static final class X
    extends RegisterSummary {
        private final List<Ticket> receipts;

        protected X(RegisterLog log, List<Ticket> receipts) {
            super("X", log);
            this.receipts = receipts;
        }

        @Override
        protected final List<Ticket> getReceipts() {
            return this.receipts;
        }

        @Override
        public String getLabel() {
            return "Synth\u00e8se actuelle (X)";
        }
    }

    private static final class XLite
    extends RegisterSummary {
        private final List<Ticket> receipts;

        protected XLite(RegisterLog log, List<Ticket> receipts) {
            super("X", log);
            this.receipts = receipts;
        }

        @Override
        public boolean isPrintingTicketsList() {
            return false;
        }

        @Override
        protected final List<Ticket> getReceipts() {
            return this.receipts;
        }

        @Override
        public String getLabel() {
            return "Synth\u00e8se actuelle simplifi\u00e9e (r\u00e9sum\u00e9 du X)";
        }
    }

    private static final class Z
    extends RegisterSummary {
        protected Z(RegisterFiles files, Calendar day) throws IOException, JDOMException {
            super("Z", new RegisterLog(files.getLogFile(day)).parse());
        }

        @Override
        protected final List<Ticket> getReceipts() throws ParseException, IOException {
            return this.getLog().parseReceipts();
        }

        @Override
        public String getLabel() {
            return "Synth\u00e8se pr\u00e9c\u00e9dente (Z)";
        }
    }
}

