/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import com.ibm.icu.text.DateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.Transaction;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.erp.core.sales.pos.ui.SoldePaiementPanel;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.core.sales.pos.ui.TransparentPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.ExceptionHandler;

public class DetailClientPanel
extends JPanel {
    private CaisseFrame caisseFrame;

    DetailClientPanel(CaisseFrame f) {
        this.caisseFrame = f;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        this.add((Component)filler, c);
    }

    public void setSelectedClient(final Client client) {
        this.removeAll();
        this.invalidate();
        Font f = new Font("Arial", 0, 24);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JLabel label = new JLabel(client.getFullName());
        label.setFont(f);
        this.add((Component)label, c);
        ++c.gridy;
        JLabel labelTransaction = new JLabel("Transactions");
        labelTransaction.setFont(f);
        this.add((Component)labelTransaction, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add(this.createTransactionList(client), c);
        c.fill = 0;
        c.weighty = 0.0;
        ++c.gridy;
        POSButton bCredit = new POSButton("Cr\u00e9diter le compte");
        this.add((Component)bCredit, c);
        ++c.gridy;
        c.anchor = 13;
        c.insets = new Insets(20, 20, 5, 2);
        POSButton bSelect = new POSButton("S\u00e9lectionner ce client");
        this.add((Component)bSelect, c);
        this.validate();
        this.repaint();
        bCredit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransparentPanel tP = new TransparentPanel(DetailClientPanel.this.caisseFrame);
                JPanel p = new JPanel();
                p.setBackground(Color.WHITE);
                p.setLayout(new GridBagLayout());
                DefaultGridBagConstraints constraints = new DefaultGridBagConstraints();
                constraints.fill = 1;
                constraints.insets = new Insets(20, 20, 20, 20);
                constraints.gridwidth = 2;
                constraints.weightx = 1.0;
                POSLabel label = new POSLabel(client.getFullName());
                p.add((Component)label, constraints);
                ++constraints.gridy;
                final SoldePaiementPanel soldePanel = new SoldePaiementPanel();
                p.add((Component)soldePanel, constraints);
                constraints.gridwidth = 1;
                ++constraints.gridy;
                constraints.gridx = 0;
                constraints.fill = 0;
                constraints.anchor = 13;
                POSButton bC = new POSButton("Cr\u00e9diter");
                p.add((Component)bC, constraints);
                bC.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            final BigDecimal amount = soldePanel.getAmount();
                            final int paymentType = soldePanel.getPaymentType();
                            client.credit(amount, paymentType);
                            final BigDecimal nouveauSolde = client.getSolde();
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    TicketPrinterConfiguration conf1 = DetailClientPanel.this.caisseFrame.getPOSConf().getTicketPrinterConfiguration1();
                                    if (conf1.isValid()) {
                                        TicketPrinter prt = conf1.createTicketPrinter();
                                        int ticketWidth = conf1.getTicketWidth();
                                        client.printCredit(prt, DetailClientPanel.this.caisseFrame.getPOSConf().getHeaderLines(), ticketWidth, amount, paymentType, nouveauSolde);
                                    }
                                }
                            });
                            t.setDaemon(true);
                            t.start();
                            DetailClientPanel.this.caisseFrame.showClients();
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle("Erreur lors du cr\u00e9dit", e1);
                        }
                    }
                });
                ++constraints.gridx;
                constraints.weightx = 0.0;
                POSButton bClose = new POSButton("Fermer");
                p.add((Component)bClose, constraints);
                bClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DetailClientPanel.this.caisseFrame.showClients();
                    }
                });
                tP.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridwidth = 1;
                c.gridheight = 1;
                c.fill = 0;
                c.anchor = 10;
                tP.add((Component)p, c);
                DetailClientPanel.this.caisseFrame.invalidate();
                DetailClientPanel.this.caisseFrame.setContentPane(tP);
                DetailClientPanel.this.caisseFrame.validate();
                DetailClientPanel.this.caisseFrame.repaint();
            }
        });
        bSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailClientPanel.this.caisseFrame.setClient(client);
                DetailClientPanel.this.caisseFrame.showCaisse();
            }
        });
    }

    private Component createTransactionList(Client client) {
        DefaultListModel ticketLlistModel = new DefaultListModel();
        List<Transaction> transactions = client.getTransactions();
        final Font f = new Font("Arial", 0, 24);
        if (transactions.isEmpty()) {
            JPanel p = new JPanel();
            p.setBackground(Color.WHITE);
            p.setLayout(new BorderLayout());
            JLabel label = new JLabel("Aucune transaction pour le moment");
            label.setFont(f);
            label.setForeground(Color.GRAY);
            p.add((Component)label, "North");
            return p;
        }
        ticketLlistModel.addAll(transactions);
        ScrollableList clientList = new ScrollableList(ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                g.setColor(Color.WHITE);
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Transaction client = (Transaction)object;
                String label = DateFormat.getDateTimeInstance().format(client.getDate());
                int soldeInCents = client.getAmount().movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue();
                String euro = String.valueOf(TicketCellRenderer.centsToString(soldeInCents)) + "\u20ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                g.drawString(label, 10, posY + 24);
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 24);
            }
        };
        return clientList;
    }
}

