/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class ListeDebiteursXmlSheet
extends AbstractListeSheetXml {
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    SQLElement eltEch = Configuration.getInstance().getDirectory().getElement("ECHEANCE_CLIENT");
    SQLElement eltVf = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
    SQLElement eltMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT");
    SQLElement eltEnc = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
    SQLElement eltEncElt = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT_ELEMENT");

    public ListeDebiteursXmlSheet() {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
    }

    @Override
    protected String getStoragePathP() {
        return "Autres";
    }

    @Override
    public String getDefaultTemplateId() {
        return "ListeDebiteur";
    }

    @Override
    public String getName() {
        return "ListeDebiteurs";
    }

    @Override
    protected void createListeValues() {
        SQLSelect sel = new SQLSelect();
        SQLTable echTable = this.eltEch.getTable();
        SQLTable clientTable = echTable.getForeignTable("ID_CLIENT");
        sel.addSelectStar(echTable);
        Where w = new Where((FieldRef)echTable.getField("REGLE"), "=", (Object)Boolean.FALSE);
        w = w.and(new Where((FieldRef)echTable.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        w = w.and(new Where((FieldRef)clientTable.getKey(), "=", echTable.getField("ID_CLIENT")));
        SQLTable vfTable = echTable.getForeignTable("ID_SAISIE_VENTE_FACTURE");
        w = w.and(new Where((FieldRef)vfTable.getKey(), "=", echTable.getField("ID_SAISIE_VENTE_FACTURE")));
        sel.setWhere(w);
        sel.addFieldOrder(vfTable.getField("NUMERO"));
        List l = (List)this.eltEch.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        ArrayList listValues = new ArrayList();
        HashMap<Integer, String> styleValues = new HashMap<Integer, String>();
        for (SQLRow sqlRow : l) {
            HashMap<String, String> mValues = new HashMap<String, String>();
            int idMouvement = MouvementSQLElement.getSourceId(sqlRow.getInt("ID_MOUVEMENT"));
            SQLRow rowMvt = this.eltMvt.getTable().getRow(idMouvement);
            mValues.put("DATE_ECHEANCE", this.dateFormat.format(sqlRow.getDate("DATE").getTime()));
            if (rowMvt.getString("SOURCE").equalsIgnoreCase(this.eltVf.getTable().getName())) {
                SQLRow rowVf = this.eltVf.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                mValues.put("NUMERO_FACTURE", rowVf.getString("NUMERO"));
                mValues.put("REFERENCE", rowVf.getString("NOM"));
                mValues.put("DATE", this.dateFormat.format(rowVf.getDate("DATE").getTime()));
                mValues.put("MODE_REGLEMENT", "");
                mValues.put("MONTANT", GestionDevise.currencyToString(rowVf.getLong("T_TTC")));
            } else {
                mValues.put("NUMERO_FACTURE", "");
                mValues.put("REFERENCE", "");
                mValues.put("DATE", "");
                mValues.put("MODE_REGLEMENT", "");
                mValues.put("MONTANT", "");
            }
            SQLRow rowClient = sqlRow.getForeignRow("ID_CLIENT");
            mValues.put("NOM_CLIENT", rowClient.getString("NOM"));
            mValues.put("CODE_CLIENT", rowClient.getString("CODE"));
            mValues.put("TELEPHONE", rowClient.getString("TEL"));
            styleValues.put(listValues.size(), "Normal");
            listValues.add(mValues);
            Collection enc = sqlRow.getReferentRows(this.eltEncElt.getTable());
            for (SQLRow sqlRow2 : enc) {
                HashMap<String, String> mValuesEnc = new HashMap<String, String>();
                SQLRow rowEnc = sqlRow2.getForeignRow("ID_ENCAISSER_MONTANT");
                SQLRow rowMdr = rowEnc.getForeignRow("ID_MODE_REGLEMENT");
                mValuesEnc.put("NUMERO_FACTURE", "");
                mValuesEnc.put("REFERENCE", rowMdr.getString("NOM"));
                mValuesEnc.put("DATE", this.dateFormat.format(rowEnc.getDate("DATE").getTime()));
                mValuesEnc.put("NOM_CLIENT", "");
                mValuesEnc.put("CODE_CLIENT", "");
                mValuesEnc.put("TELEPHONE", "");
                mValuesEnc.put("MODE_REGLEMENT", rowMdr.getForeignRow("ID_TYPE_REGLEMENT").getString("NOM"));
                mValuesEnc.put("MONTANT", GestionDevise.currencyToString(sqlRow2.getLong("MONTANT_REGLE")));
                styleValues.put(listValues.size(), "Titre 1");
                listValues.add(mValuesEnc);
            }
            if (enc == null || enc.size() <= 0) continue;
            HashMap<String, String> mValuesEnc = new HashMap<String, String>();
            mValuesEnc.put("DATE", this.dateFormat.format(sqlRow.getDate("DATE").getTime()));
            mValuesEnc.put("MODE_REGLEMENT", "Restant \u00e0 r\u00e9gler");
            mValuesEnc.put("MONTANT", GestionDevise.currencyToString(sqlRow.getLong("MONTANT")));
            styleValues.put(listValues.size(), "Titre 1");
            listValues.add(mValuesEnc);
        }
        this.listAllSheetValues.put(0, listValues);
        this.styleAllSheetValues.put(0, styleValues);
    }
}

