/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.ui.CompteCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class PlanComptableCellRenderer
extends CompteCellRenderer {
    private final transient int colNumeroCompte;

    public PlanComptableCellRenderer(int colNumeroCompte) {
        this.colNumeroCompte = colNumeroCompte;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setBackgroundColor(this, table, isSelected);
        if (!isSelected) {
            String numeroCompte = table.getValueAt(row, this.colNumeroCompte).toString().trim();
            int compteLength = numeroCompte.length();
            if (compteLength == 1) {
                this.setBackground(couleurCompteClasse);
            } else if (row < table.getRowCount() - 1) {
                String numeroCompteSuiv = table.getValueAt(row + 1, this.colNumeroCompte).toString().trim();
                if (compteLength < numeroCompteSuiv.length() && numeroCompte.equalsIgnoreCase(numeroCompteSuiv.substring(0, compteLength))) {
                    if (compteLength == 2) {
                        this.setBackground(couleurCompte2);
                    } else if (compteLength == 3) {
                        this.setBackground(couleurCompte3);
                    } else {
                        this.setBackground(couleurCompteRacine);
                    }
                }
            } else {
                this.setBackground(Color.WHITE);
            }
            this.setForeground(Color.BLACK);
        }
        return this;
    }
}

