/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.xml.JDOM2Utils;
import org.openconcerto.xml.XMLDecoderJDOM;
import org.openconcerto.xml.XMLDecoderStAX;

public class XMLCodecUtils {
    private static final String END_DECL = "?>";
    private static final Charset CS = Charset.forName("UTF-8");
    private static final Encoder bogus = new Encoder();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static final Map<Class, PersistenceDelegate> persDelegates = new HashMap<Class, PersistenceDelegate>();
    public static final ExceptionListener EXCEPTION_LISTENER = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception e) {
            throw new IllegalStateException(e);
        }
    };
    public static final XMLDecoderJDOM XML_DECODER_JDOM = new XMLDecoderJDOM();
    public static final XMLDecoderStAX XML_DECODER_STAX = new XMLDecoderStAX();

    public static synchronized void register(Class c, PersistenceDelegate del) {
        persDelegates.put(c, del);
        bogus.setPersistenceDelegate(c, del);
    }

    public static synchronized void unregister(Class c) {
        persDelegates.remove(c);
        bogus.setPersistenceDelegate(c, defaultPersistenceDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] encode2Bytes(Object o) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEncoder enc = new XMLEncoder(out);
        Class<XMLCodecUtils> clazz = XMLCodecUtils.class;
        synchronized (XMLCodecUtils.class) {
            for (Map.Entry<Class, PersistenceDelegate> e : persDelegates.entrySet()) {
                enc.setPersistenceDelegate(e.getKey(), e.getValue());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            enc.setExceptionListener(EXCEPTION_LISTENER);
            enc.writeObject(o);
            enc.close();
            byte[] res = out.toByteArray();
            try {
                out.close();
            }
            catch (IOException exn) {
                throw new IllegalStateException(exn);
            }
            return res;
        }
    }

    public static final String encodeAsArray(Map<?, ?> m) {
        return XMLCodecUtils.encodeAsArray(m, new StringBuilder(1024)).toString();
    }

    public static final StringBuilder encodeAsArray(Map<?, ?> m, StringBuilder sb) {
        Object[] array = new Object[m.size() * 2];
        int i = 0;
        for (Map.Entry<?, ?> e : m.entrySet()) {
            array[i++] = e.getKey();
            array[i++] = e.getValue();
        }
        assert (i == array.length);
        return XMLCodecUtils.encodeSimple(array, sb);
    }

    public static final <K, V> Map<K, V> decodeFromArray(Object[] array, Class<K> keyClass, Class<V> valueClass) {
        return XMLCodecUtils.decodeFromArray(array, keyClass, valueClass, null);
    }

    public static final <K, V> Map<K, V> decodeFromArray(Object[] array, Class<K> keyClass, Class<V> valueClass, Map<K, V> m) {
        int l = array.length;
        if (m == null) {
            m = new HashMap((int)((float)(l / 2) / 0.8f) + 1, 0.8f);
        }
        int i = 0;
        while (i < l) {
            K key = keyClass.cast(array[i]);
            V value = valueClass.cast(array[i + 1]);
            m.put(key, value);
            i += 2;
        }
        return m;
    }

    public static final String encode(Object o) {
        String res = new String(XMLCodecUtils.encode2Bytes(o), CS);
        int decl = res.indexOf(END_DECL);
        return res.substring(decl + END_DECL.length());
    }

    public static final String encodeSimple(Object o) {
        StringBuilder sb = new StringBuilder(256);
        return XMLCodecUtils.encodeSimple(o, sb).toString();
    }

    public static final StringBuilder encodeSimple(Object o, StringBuilder sb) {
        sb.append("<java version=\"1.6.0\" class=\"java.beans.XMLDecoder\">");
        XMLCodecUtils.encodeSimpleRec(o, sb);
        sb.append("</java>");
        return sb;
    }

    private static final void createElemEscaped(String elemName, Object o, StringBuilder sb) {
        XMLCodecUtils.createElem(elemName, JDOM2Utils.OUTPUTTER.escapeElementEntities(o.toString()), sb);
    }

    private static final void createElem(String elemName, Object o, StringBuilder sb) {
        assert (o != null);
        sb.append('<');
        sb.append(elemName);
        sb.append('>');
        sb.append(o.toString());
        sb.append("</");
        sb.append(elemName);
        sb.append('>');
    }

    private static final void encodeSimpleRec(Object o, StringBuilder sb) {
        if (o == null) {
            sb.append("<null/>");
            return;
        }
        Class<?> c = o.getClass();
        if (c == Boolean.class) {
            XMLCodecUtils.createElem("boolean", o, sb);
        } else if (c == String.class) {
            XMLCodecUtils.createElemEscaped("string", o, sb);
        } else if (c == Character.class) {
            XMLCodecUtils.createElemEscaped("char", o, sb);
        } else if (c == Integer.class) {
            XMLCodecUtils.createElem("int", o, sb);
        } else if (c == Long.class) {
            XMLCodecUtils.createElem("long", o, sb);
        } else if (c == Float.class) {
            XMLCodecUtils.createElem("float", o, sb);
        } else if (c == Double.class) {
            XMLCodecUtils.createElem("double", o, sb);
        } else if (c == Class.class) {
            XMLCodecUtils.createElem("class", ((Class)o).getName(), sb);
        } else if (c == Short.class) {
            XMLCodecUtils.createElem("short", o, sb);
        } else if (c == Byte.class) {
            XMLCodecUtils.createElem("byte", o, sb);
        } else if (o instanceof Enum) {
            sb.append("<object class=\"");
            sb.append(c.getName());
            sb.append("\" method=\"valueOf\"><string>");
            sb.append(((Enum)o).name());
            sb.append("</string></object>");
        } else if (c.isArray()) {
            sb.append("<array class=\"");
            sb.append(c.getComponentType().getName());
            sb.append("\">");
            int stop = Array.getLength(o);
            int j = 0;
            while (j < stop) {
                XMLCodecUtils.encodeSimpleRec(Array.get(o, j), sb);
                ++j;
            }
            sb.append("</array>");
        } else if (o instanceof Map) {
            sb.append("<object class=\"");
            if (c.getName().startsWith("java.util.Collections$")) {
                sb.append("java.util.HashMap");
            } else {
                sb.append(c.getName());
            }
            sb.append("\">");
            Map m = (Map)o;
            for (Map.Entry e : m.entrySet()) {
                sb.append("<void method=\"put\" >");
                XMLCodecUtils.encodeSimpleRec(e.getKey(), sb);
                XMLCodecUtils.encodeSimpleRec(e.getValue(), sb);
                sb.append("</void>");
            }
            sb.append("</object>");
        } else if (o instanceof Collection) {
            sb.append("<object class=\"");
            if (c.getName().startsWith("java.util.Arrays$")) {
                sb.append("java.util.ArrayList");
            } else if (c.getName().startsWith("java.util.Collections$")) {
                if (o instanceof Set) {
                    sb.append("java.util.HashSet");
                } else {
                    sb.append("java.util.ArrayList");
                }
            } else {
                sb.append(c.getName());
            }
            sb.append("\">");
            if (o instanceof RandomAccess && o instanceof List) {
                List list = (List)o;
                int stop = list.size();
                int i = 0;
                while (i < stop) {
                    sb.append("<void method=\"add\" >");
                    XMLCodecUtils.encodeSimpleRec(list.get(i), sb);
                    sb.append("</void>");
                    ++i;
                }
            } else {
                for (Object item : (Collection)o) {
                    sb.append("<void method=\"add\" >");
                    XMLCodecUtils.encodeSimpleRec(item, sb);
                    sb.append("</void>");
                }
            }
            sb.append("</object>");
        } else if (o instanceof Point) {
            Point p = (Point)o;
            sb.append("<object class=\"java.awt.Point\">");
            XMLCodecUtils.encodeSimpleRec(p.x, sb);
            XMLCodecUtils.encodeSimpleRec(p.y, sb);
            sb.append("</object>");
        } else if (o instanceof Dimension) {
            Dimension p = (Dimension)o;
            sb.append("<object class=\"java.awt.Dimension\">");
            XMLCodecUtils.encodeSimpleRec(p.width, sb);
            XMLCodecUtils.encodeSimpleRec(p.height, sb);
            sb.append("</object>");
        } else if (o instanceof Rectangle) {
            Rectangle p = (Rectangle)o;
            sb.append("<object class=\"java.awt.Rectangle\">");
            XMLCodecUtils.encodeSimpleRec(p.x, sb);
            XMLCodecUtils.encodeSimpleRec(p.y, sb);
            XMLCodecUtils.encodeSimpleRec(p.width, sb);
            XMLCodecUtils.encodeSimpleRec(p.height, sb);
            sb.append("</object>");
        } else {
            BeanInfo info;
            try {
                info = Introspector.getBeanInfo(c);
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Couldn't inspect " + o, e);
            }
            sb.append("<object class=\"");
            sb.append(c.getName());
            sb.append("\">");
            PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter != null && setter != null && pd.getValue("transient") != Boolean.TRUE) {
                    try {
                        sb.append("<void method=\"" + setter.getName() + "\">");
                        XMLCodecUtils.encodeSimpleRec(getter.invoke(o, new Object[0]), sb);
                        sb.append("</void>");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't get the value of the '" + pd.getDisplayName() + "' property for " + o, e);
                    }
                }
                ++n2;
            }
            sb.append("</object>");
        }
    }

    public static final Element encodeToJDOM(Object o) {
        SAXBuilder builder = new SAXBuilder();
        try {
            return builder.build(new ByteArrayInputStream(XMLCodecUtils.encode2Bytes(o))).getRootElement().detach();
        }
        catch (JDOMException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final Object decode1(String s) {
        ByteArrayInputStream ins = new ByteArrayInputStream(s.getBytes(CS));
        XMLDecoder dec = new XMLDecoder(ins);
        dec.setExceptionListener(EXCEPTION_LISTENER);
        Object res = dec.readObject();
        dec.close();
        return res;
    }

    public static final Object decode1(Element javaElem) {
        return XML_DECODER_JDOM.decode1(javaElem);
    }

    private XMLCodecUtils() {
    }
}

