/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class OrderedSet<E>
extends Vector<E>
implements Set<E> {
    private final Set<E> set = new HashSet();

    public OrderedSet(List<E> nodes) {
        this.addAll(nodes);
    }

    public OrderedSet() {
    }

    @Override
    public synchronized void insertElementAt(E obj, int index) {
        if (!this.contains(obj)) {
            this.set.add(obj);
            super.insertElementAt(obj, index);
        }
    }

    @Override
    public synchronized boolean add(E o) {
        if (!this.contains(o)) {
            super.add(o);
            this.set.add(o);
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        int s = this.size();
        int i = 0;
        while (i < s) {
            if (c.contains(this.get(i))) {
                return false;
            }
            ++i;
        }
        this.set.addAll(c);
        return super.addAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        int s = this.size();
        int i = 0;
        while (i < s) {
            if (c.contains(this.get(i))) {
                return false;
            }
            ++i;
        }
        this.set.addAll(c);
        return super.addAll(index, c);
    }

    @Override
    public synchronized void addElement(E obj) {
        this.add(obj);
    }

    @Override
    public boolean contains(Object elem) {
        return this.set.contains(elem);
    }

    @Override
    public synchronized E remove(int index) {
        return super.remove(index);
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        return super.removeAll(c);
    }

    @Override
    public synchronized void removeAllElements() {
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object obj) {
        this.set.remove(obj);
        return super.removeElement(obj);
    }

    @Override
    public synchronized void removeElementAt(int index) {
        super.removeElementAt(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }
}

