/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list;

import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.openconcerto.ui.list.ListCellEditor;
import org.openconcerto.ui.list.MutableListModel;

public class JListMutable
extends JList
implements CellEditorListener {
    protected Component editorComp = null;
    protected int editingIndex = -1;
    protected ListCellEditor editor = null;
    private PropertyChangeListener editorRemover = null;

    public JListMutable(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    private void init() {
        this.getActionMap().put("startEditing", new StartEditingAction());
        this.getActionMap().put("cancel", new CancelEditingAction());
        this.addMouseListener(new MouseListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void setListCellEditor(ListCellEditor editor) {
        this.editor = editor;
    }

    public ListCellEditor getListCellEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editorComp != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingIndex() {
        return this.editingIndex;
    }

    public Component prepareEditor(int index) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getModel().getElementAt(index);
        Component comp = this.editor.getListCellEditorComponent(this, value, isSelected = this.isSelectedIndex(index), index);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this);
        }
        return comp;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        if (this.editor != null) {
            this.editor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle cellRect = this.getCellBounds(this.editingIndex, this.editingIndex);
            this.editingIndex = -1;
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    public boolean editCellAt(int index, EventObject e) {
        System.out.println("JListMutalbe: editCell" + index);
        if (this.editor != null && !this.editor.stopCellEditing()) {
            return false;
        }
        if (index < 0 || index >= this.getModel().getSize()) {
            return false;
        }
        if (!this.isCellEditable(index)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if (this.editor != null && this.editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(index);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellBounds(index, index));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editingIndex = index;
            this.editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        super.removeNotify();
    }

    public boolean isCellEditable(int index) {
        if (this.getModel() instanceof MutableListModel) {
            return ((MutableListModel)this.getModel()).isCellEditable(index);
        }
        return false;
    }

    public void setValueAt(Object value, int index) {
        ((MutableListModel)this.getModel()).setValueAt(value, index);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.editor != null) {
            Object value = this.editor.getCellEditorValue();
            this.setValueAt(value, this.editingIndex);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }

    public void reselect() {
        int old = this.getSelectedIndex();
        this.clearSelection();
        this.setSelectedIndex(old);
    }

    private class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JListMutable list = (JListMutable)e.getSource();
            list.removeEditor();
        }

        @Override
        public boolean isEnabled() {
            return JListMutable.this.isEditing();
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!JListMutable.this.isEditing() || JListMutable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            Component c = this.focusManager.getPermanentFocusOwner();
            while (c != null) {
                if (c == JListMutable.this) {
                    return;
                }
                if (c instanceof Window || c instanceof Applet && c.getParent() == null) {
                    if (c != SwingUtilities.getRoot(JListMutable.this) || JListMutable.this.getListCellEditor().stopCellEditing()) break;
                    JListMutable.this.getListCellEditor().cancelCellEditing();
                    break;
                }
                c = c.getParent();
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private Component dispatchComponent;

        private MouseListener() {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = JListMutable.this.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(JListMutable.this, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !JListMutable.this.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(JListMutable.this, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !JListMutable.this.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int index = JListMutable.this.locationToIndex(p);
            if (index == -1) {
                return;
            }
            if (JListMutable.this.editCellAt(index, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (JListMutable.this.isRequestFocusEnabled()) {
                JListMutable.this.requestFocus();
            }
            JComponent c = (JComponent)e.getSource();
            TransferHandler th = c.getTransferHandler();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JListMutable list = (JListMutable)e.getSource();
            if (!list.hasFocus()) {
                ListCellEditor cellEditor = list.getListCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                list.requestFocus();
                return;
            }
            ListSelectionModel rsm = list.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            list.editCellAt(anchorRow, null);
            Component editorComp = list.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
            }
        }
    }
}

