/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openconcerto.ui.list.HighLightableJLabel;
import org.openconcerto.ui.list.ListItem;
import org.openconcerto.ui.table.IconTableCellRenderer;

public class ItemListCellRenderer
extends JPanel
implements ListCellRenderer {
    private final HighLightableJLabel label1 = new HighLightableJLabel();
    private final HighLightableJLabel label2 = new HighLightableJLabel();
    private Icon icon;
    private int vGap;
    private int hGap;

    public ItemListCellRenderer() {
        this(2, 4);
    }

    public ItemListCellRenderer(int hGap, int vGap) {
        this.hGap = hGap;
        this.vGap = vGap;
        this.setLayout(null);
        this.add(this.label1);
        this.add(this.label2);
    }

    public void setHighLightedText(String str) {
        this.label1.setHightlight(str);
        this.label2.setHightlight(str);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.icon != null) {
            int x = this.getWidth() - this.icon.getIconWidth() - this.hGap;
            int y = (this.getHeight() - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, g, x, y);
        }
    }

    @Override
    public void doLayout() {
        this.label1.setBounds(this.hGap, this.vGap, this.getWidth() - this.getHeight(), this.getHeight() / 2);
        this.label2.setBounds(2 * this.hGap, this.getHeight() / 2, this.getWidth() - this.getHeight(), this.getHeight() / 2);
    }

    @Override
    public void setFont(Font font) {
        if (this.label1 != null) {
            this.label1.setFont(font);
            this.label2.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public Dimension getPreferredSize() {
        int h = 4 * this.vGap + this.label1.getPreferredSize().height + this.label2.getPreferredSize().height;
        int w = 2 * this.hGap + Math.max(this.label1.getPreferredSize().width, this.label2.getPreferredSize().width) + h;
        return new Dimension(w, h);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.label1 != null) {
            this.label1.setForeground(fg);
            if (fg.equals(Color.BLACK)) {
                this.label2.setForeground(Color.GRAY);
            } else {
                this.label2.setForeground(fg.brighter().brighter());
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ListItem item = (ListItem)value;
        Color bg = null;
        Color fg = null;
        if (isSelected) {
            this.setBackground(bg == null ? list.getSelectionBackground() : bg);
            this.setForeground(fg == null ? list.getSelectionForeground() : fg);
            Color brighterColor = this.getBackground().brighter();
            this.label1.setHighLightColor(brighterColor);
            this.label2.setHighLightColor(brighterColor);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.label1.setHighLightColor(HighLightableJLabel.DEFAULT_COLOR);
            this.label2.setHighLightColor(HighLightableJLabel.DEFAULT_COLOR);
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.label1.setText(item.getTitle());
        this.label2.setText(item.getComment());
        this.icon = item.getIcon();
        return this;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame();
        ListItem[] data = new ListItem[]{new ListItem("Hello", "World comment", null), new ListItem("Hello World", "How are you today?", new ImageIcon(IconTableCellRenderer.class.getResource("okay.png")))};
        JList<ListItem> contentPane = new JList<ListItem>(data);
        ItemListCellRenderer cellRenderer = new ItemListCellRenderer();
        cellRenderer.setHighLightedText("orl");
        contentPane.setCellRenderer(cellRenderer);
        contentPane.setFont(contentPane.getFont().deriveFont(24.0f));
        f.setContentPane(contentPane);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

