/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.QuickAssignRowValuesTablePanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class QuickAssignPanel
extends JPanel {
    private JButton addButton;
    private JButton removeButton;
    private RowValuesTablePanel itemTablePanel;
    private ElementComboBox combo;

    public QuickAssignPanel(SQLElement element, final String uniqueIdFieldName, RowValuesTableModel model) {
        if (element == null) {
            throw new IllegalArgumentException("null SQLElement");
        }
        if (uniqueIdFieldName == null) {
            throw new IllegalArgumentException("null uniqueIdFieldName");
        }
        if (model == null) {
            throw new IllegalArgumentException("null RowValuesTableModel");
        }
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        JPanel toolbar = new JPanel(new FlowLayout(0));
        toolbar.setOpaque(false);
        this.combo = new ElementComboBox(false);
        this.combo.init(element);
        this.combo.setButtonsVisible(false);
        toolbar.add(this.combo);
        this.addButton = new JButton("Ajouter");
        this.addButton.setOpaque(false);
        toolbar.add(this.addButton);
        this.removeButton = new JButton("Supprimer");
        this.removeButton.setOpaque(false);
        toolbar.add((Component)this.removeButton, c);
        this.add((Component)toolbar, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.itemTablePanel = new QuickAssignRowValuesTablePanel(model);
        this.itemTablePanel.setOpaque(false);
        this.add((Component)this.itemTablePanel, c);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow row = QuickAssignPanel.this.combo.getSelectedRow();
                if (row == null || row.isUndefined()) {
                    return;
                }
                int nbRows = QuickAssignPanel.this.itemTablePanel.getModel().getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = QuickAssignPanel.this.itemTablePanel.getModel().getRowValuesAt(i);
                    int id = Integer.parseInt(rowVals.getObject(uniqueIdFieldName).toString());
                    if (id == row.getID()) {
                        return;
                    }
                    ++i;
                }
                QuickAssignPanel.this.itemTablePanel.getModel().addRow(QuickAssignPanel.this.combo.getSelectedRow().asRowValues());
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickAssignPanel.this.itemTablePanel.removeSelectedRow();
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        this.combo.setEnabled(b);
        this.addButton.setEnabled(b);
        this.removeButton.setEnabled(b);
        this.itemTablePanel.setEnabled(b);
    }

    public RowValuesTableModel getModel() {
        return this.itemTablePanel.getModel();
    }
}

