/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrder;

final class ReOrderPostgreSQL
extends ReOrder {
    public ReOrderPostgreSQL(SQLTable t, ReOrder.Spec spec) {
        super(t, spec);
    }

    @Override
    public List<String> getSQL(Connection conn, BigDecimal inc) throws SQLException {
        SQLField oF = this.t.getOrderField();
        ArrayList<String> res = new ArrayList<String>();
        String alias = "T";
        AliasedField tID = new AliasedField(this.t.getKey(), "T");
        AliasedField tOrder = new AliasedField(oF, "T");
        SQLSelect idsToReorder = new SQLSelect(true);
        idsToReorder.addFrom(this.t, "T");
        idsToReorder.addSelect(tID, null, "ID");
        idsToReorder.setWhere(this.getWhere(tOrder));
        idsToReorder.addFieldOrder(tOrder, Order.asc(), conn.getMetaData().nullsAreSortedHigh() ? null : Order.nullsLast());
        idsToReorder.addFieldOrder(tID, Order.asc());
        res.add("CREATE TEMP SEQUENCE \"reorderSeq\" MINVALUE 0;");
        res.add("CREATE LOCAL TEMPORARY TABLE REORDER as select M.\"ID\", nextval('\"reorderSeq\"') as index from (\n" + idsToReorder.asString() + ") M;");
        res.add("DROP SEQUENCE \"reorderSeq\";");
        res.add("create local temp table inc(val) as select " + inc.toPlainString() + ";");
        res.add(String.valueOf(this.t.getBase().quote("UPDATE %f SET %n =  -%n " + this.getWhere(), this.t, oF, oF)) + ";");
        UpdateBuilder update = new UpdateBuilder(this.t);
        update.addRawTable("REORDER", "M");
        update.addRawTable("inc", null);
        update.set(oF.getName(), "M.index * inc.val + " + this.getFirstOrderValue());
        res.add(String.valueOf(update.asString()) + " where M.\"ID\" = " + this.t.getKey().getFieldRef() + ";");
        res.add("DROP TABLE REORDER, inc ;");
        return res;
    }
}

