/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.PartialUniqueTrigger;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.UniqueConstraintCreatorHelper;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class ChangeTable<T extends ChangeTable<T>> {
    private static final String TRIGGER_SUFFIX = "_trigger";
    protected static final String[] TRIGGER_EVENTS = new String[]{"INSERT", "UPDATE"};
    public static final Pattern H2_UNIQUE_TRIGGER_PATTERN = Pattern.compile("\\snew " + PartialUniqueTrigger.class.getName() + "\\(\\s*java.util.Arrays.asList\\((.+)\\)\\s*,(.+)\\)");
    public static final String H2_UNIQUE_TRIGGER_CLASS_SUFFIX = "_" + PartialUniqueTrigger.class.getSimpleName();
    public static final Pattern H2_UNIQUE_TRIGGER_CLASS_PATTERN = Pattern.compile("CALL\\s+\"(.*" + Pattern.quote(H2_UNIQUE_TRIGGER_CLASS_SUFFIX) + ")\"");
    public static final Pattern H2_LIST_PATTERN = Pattern.compile("\\s*,\\s*");
    public static final String MYSQL_TRIGGER_SUFFIX_1 = ChangeTable.getTriggerSuffix(TRIGGER_EVENTS[0]);
    public static final String MYSQL_TRIGGER_SUFFIX_2 = ChangeTable.getTriggerSuffix(TRIGGER_EVENTS[1]);
    public static final String MYSQL_FAKE_PROCEDURE = "Unique constraint violation";
    public static final String MYSQL_TRIGGER_EXCEPTION = "call " + SQLBase.quoteIdentifier("Unique constraint violation");
    public static final Pattern MYSQL_UNIQUE_TRIGGER_PATTERN = Pattern.compile("IF\\s*\\(\\s*" + Pattern.quote("SELECT COUNT(*)") + "\\s+FROM\\s+(.+)\\s+where\\s+(.+)\\)\\s*>\\s*1\\s+then\\s+" + Pattern.quote(MYSQL_TRIGGER_EXCEPTION), 2);
    public static final Pattern MYSQL_WHERE_PATTERN = Pattern.compile("\\s+and\\s+", 2);
    public static final Pattern MYSQL_WHERE_EQ_PATTERN = Pattern.compile("(NEW.)?(.+)\\s*=\\s*(NEW.)?\\2");
    public static final Set<ClauseType> ORDERED_TYPES;
    private String rootName;
    private String name;
    private final SQLSyntax syntax;
    private final List<FCSpec> fks;
    private final InAndOutClauses clauses;

    static {
        LinkedHashSet<ClauseType> tmp = new LinkedHashSet<ClauseType>(ClauseType.values().length);
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            tmp.addAll(step.getTypes());
            ++n2;
        }
        assert (tmp.equals(EnumSet.allOf(ClauseType.class))) : "ConcatStep is missing some types : " + tmp;
        ORDERED_TYPES = Collections.unmodifiableSet(tmp);
    }

    public static final String getIndexName(String triggerName, SQLSystem system) {
        if (system == SQLSystem.MYSQL && triggerName.endsWith(MYSQL_TRIGGER_SUFFIX_1)) {
            return triggerName.substring(0, triggerName.length() - MYSQL_TRIGGER_SUFFIX_1.length());
        }
        if (system == SQLSystem.H2 && triggerName.endsWith(TRIGGER_SUFFIX)) {
            return triggerName.substring(0, triggerName.length() - TRIGGER_SUFFIX.length());
        }
        return null;
    }

    private static String getTriggerSuffix(String event) {
        return String.valueOf(event == null ? "" : String.valueOf('_') + event.toLowerCase()) + TRIGGER_SUFFIX;
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts, String r) {
        return ChangeTable.cat(cts, new ChangeRootNameTransformer(r));
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts) {
        return ChangeTable.cat(cts, NameTransformer.NOP);
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts, NameTransformer transf) {
        return ChangeTable.cat(cts, transf, false);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, String r, EnumSet<ConcatStep> boundaries) {
        if (r == null) {
            throw new NullPointerException("r is null");
        }
        return ChangeTable.cat(cts, (NameTransformer)new ChangeRootNameTransformer(r), boundaries);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, NameTransformer transf, EnumSet<ConcatStep> boundaries) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            if (current == null || boundaries.contains((Object)step)) {
                current = new ArrayList<String>();
                res.add(current);
            }
            for (ChangeTable<?> ct : cts) {
                String asString = ct.asString(transf, step);
                if (asString == null || asString.length() <= 0) continue;
                current.add(asString);
            }
            ++n2;
        }
        assert (res.size() == boundaries.size() + 1);
        return res;
    }

    private static List<String> cat(List<? extends ChangeTable<?>> cts, NameTransformer transf, boolean forceCat) {
        List<String> res = ChangeTable.cat(cts, transf, EnumSet.noneOf(ConcatStep.class)).get(0);
        if (!(forceCat || cts.size() != 0 && cts.get(0).getSyntax().getSystem() != SQLSystem.MYSQL)) {
            return res;
        }
        return Collections.singletonList(CollectionUtils.join(res, "\n"));
    }

    public static String catToString(List<? extends ChangeTable<?>> cts, String r) {
        return ChangeTable.cat(cts, (NameTransformer)new ChangeRootNameTransformer(r), true).get(0);
    }

    public ChangeTable(SQLSyntax syntax, String rootName, String name) {
        this.syntax = syntax;
        this.rootName = rootName;
        this.name = name;
        this.fks = new ArrayList<FCSpec>();
        this.clauses = new InAndOutClauses();
        if (this.getClass() != ReflectUtils.getTypeArguments(this, ChangeTable.class).get(0)) {
            throw new IllegalStateException("illegal subclass: " + this.getClass());
        }
    }

    protected final T thisAsT() {
        return (T)this;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public void reset() {
        this.fks.clear();
        this.clauses.reset();
    }

    public boolean isEmpty() {
        return this.fks.isEmpty() && this.clauses.isEmpty();
    }

    public final T addVarCharColumn(String name, int count) {
        return this.addVarCharColumn(name, count, false);
    }

    public final T addVarCharColumn(String name, int count, boolean lenient) throws IllegalArgumentException {
        return this.addVarCharColumn(name, count, lenient, "''", false);
    }

    public final T addVarCharColumn(String name, int count, boolean lenient, String defaultValue, boolean nullable) throws IllegalArgumentException {
        int max = this.getSyntax().getMaximumVarCharLength();
        if (count > max) {
            if (lenient) {
                Log.get().fine("Truncated " + name + " from " + count + " to " + max);
                count = max;
            } else {
                throw new IllegalArgumentException("Count too high : " + count + " > " + max);
            }
        }
        return this.addColumn(name, "varchar(" + count + ")", defaultValue, nullable);
    }

    public final T addDateAndTimeColumn(String name) {
        return this.addColumn(name, this.getSyntax().getDateAndTimeType());
    }

    public final T addIntegerColumn(String name, int defaultVal) {
        return this.addIntegerColumn(name, defaultVal, false);
    }

    public final T addIntegerColumn(String name, Integer defaultVal, boolean nullable) {
        return this.addNumberColumn(name, Integer.class, defaultVal, nullable);
    }

    public final T addLongColumn(String name, Long defaultVal, boolean nullable) {
        return this.addNumberColumn(name, Long.class, defaultVal, nullable);
    }

    public final T addShortColumn(String name, Short defaultVal, boolean nullable) {
        return this.addNumberColumn(name, Short.class, defaultVal, nullable);
    }

    public final <N extends Number> T addNumberColumn(String name, Class<N> javaType, N defaultVal, boolean nullable) {
        Collection<String> typeNames = this.getSyntax().getTypeNames(javaType);
        if (typeNames.size() == 0) {
            throw new IllegalArgumentException(javaType + " isn't supported by " + this.getSyntax());
        }
        return this.addColumn(name, typeNames.iterator().next(), this.getNumberDefault(defaultVal), nullable);
    }

    final String getNumberDefault(Number defaultVal) {
        return defaultVal == null ? null : defaultVal.toString();
    }

    public final T addDecimalColumn(String name, int precision, int scale, BigDecimal defaultVal, boolean nullable) {
        return this.addColumn(name, this.getSyntax().getDecimal(precision, scale), this.getNumberDefault(defaultVal), nullable);
    }

    public final T addBooleanColumn(String name, Boolean defaultVal, boolean nullable) {
        SQLType boolType = SQLType.getBoolean(this.getSyntax());
        return this.addColumn(name, boolType.getTypeName(), boolType.toString(defaultVal), nullable);
    }

    public final T addColumn(String name, String sqlType, String defaultVal, boolean nullable) {
        return this.addColumn(name, this.getSyntax().getFieldDecl(sqlType, defaultVal, nullable));
    }

    public abstract T addColumn(String var1, String var2);

    public final T addColumn(SQLField f) {
        return this.addColumn(f.getName(), f);
    }

    public final T addColumn(String name, SQLField f) {
        return this.addColumn(name, this.getSyntax().getFieldDecl(f));
    }

    public final boolean addIndex(SQLTable.Index index) {
        boolean add;
        boolean bl = add = !this.hasAutomaticIndex(index);
        if (add) {
            this.addOutsideClause(this.getSyntax().getCreateIndex(index));
        }
        return add;
    }

    public final T addForeignConstraint(Link l, boolean createIndex) {
        return this.addForeignConstraint(FCSpec.createFromLink(l), createIndex);
    }

    public final T addForeignConstraint(String fieldName, SQLName refTable, String refCols) {
        return this.addForeignConstraint(Collections.singletonList(fieldName), refTable, true, Collections.singletonList(refCols));
    }

    public final T addForeignConstraint(List<String> fieldName, SQLName refTable, boolean createIndex, List<String> refCols) {
        return this.addForeignConstraint(new FCSpec(fieldName, refTable, refCols, null, null), createIndex);
    }

    public final T addForeignConstraint(final FCSpec fkSpec, boolean createIndex) {
        this.fks.add(fkSpec);
        if (createIndex && !this.getSyntax().getSystem().autoCreatesFKIndex()) {
            this.addOutsideClause(new DeferredClause(){

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_INDEX;
                }

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName) {
                    return ct.getSyntax().getCreateIndex("_fki", tableName, fkSpec.getCols());
                }
            });
        }
        return this.thisAsT();
    }

    public final T removeForeignConstraint(FCSpec fkSpec) {
        this.fks.remove(fkSpec);
        return this.thisAsT();
    }

    public final List<FCSpec> getForeignConstraints() {
        return Collections.unmodifiableList(this.fks);
    }

    private final boolean hasAutomaticIndex(SQLTable.Index i) {
        if (i.isUnique() || !StringUtils.isEmpty(i.getFilter()) || !this.getSyntax().getSystem().autoCreatesFKIndex()) {
            return false;
        }
        for (FCSpec fc : this.fks) {
            if (!fc.getCols().equals(i.getCols())) continue;
            return true;
        }
        return false;
    }

    public T addForeignColumn(SQLCreateTableBase<?> createTable) {
        return this.addForeignColumn(ForeignColSpec.fromCreateTable(createTable));
    }

    public T addForeignColumnWithSuffix(String suffix, SQLCreateTableBase<?> createTable) {
        return this.addForeignColumn(ForeignColSpec.fromCreateTable(createTable).setColumnNameWithSuffix(suffix));
    }

    public T addForeignColumn(String fk, SQLCreateTableBase<?> createTable) {
        return this.addForeignColumn(ForeignColSpec.fromCreateTable(createTable).setColumnName(fk));
    }

    public T addForeignColumn(String fk, SQLName table, String pk, String defaultVal) {
        return this.addForeignColumn(new ForeignColSpec(fk, table, pk, defaultVal));
    }

    public T addForeignColumn(ForeignColSpec spec) {
        return this.addForeignColumn(spec, null, null);
    }

    public T addForeignColumn(ForeignColSpec spec, Link.Rule updateRule, Link.Rule deleteRule) {
        this.addColumn(spec.getColumnName(), String.valueOf(this.getSyntax().getIDType()) + " DEFAULT " + spec.getDefaultVal());
        return this.addForeignConstraint(spec.createFCSpec(updateRule, deleteRule), true);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable) {
        return this.addForeignColumn(fk, foreignTable, true);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable, boolean absolute) {
        return this.addForeignColumn(ForeignColSpec.fromTable(foreignTable, absolute).setColumnName(fk));
    }

    public T addUniqueConstraint(String name, List<String> cols) {
        return this.addUniqueConstraint(name, cols, null);
    }

    public T addUniqueConstraint(String name, List<String> cols, String where) {
        return this.addUniqueConstraint(name, cols, where, null);
    }

    public T addUniqueConstraint(String name, UniqueConstraintCreatorHelper c) {
        return this.addUniqueConstraint(name, c.getColumns(), c.getWhere(), c);
    }

    private T addUniqueConstraint(String name, final List<String> cols, final String where, UniqueConstraintCreatorHelper c) {
        assert (c == null || c.getWhere() == where);
        assert (c == null || c.getColumns() == cols);
        String comment = c == null ? null : c.getComment();
        int size = cols.size();
        if (size == 0) {
            throw new IllegalArgumentException("No cols");
        }
        SQLSystem system = this.getSyntax().getSystem();
        if (system == SQLSystem.MSSQL) {
            return this.addOutsideClause(this.createUniquePartialIndex(name, cols, where));
        }
        if (where == null) {
            return this.addClause(this.createUniqueConstraint(name, cols));
        }
        if (system == SQLSystem.POSTGRESQL) {
            return this.addOutsideClause(this.createUniquePartialIndex(name, cols, where));
        }
        if (system == SQLSystem.H2) {
            String body;
            Class h2TriggerClass;
            Class clazz = h2TriggerClass = c == null ? null : (Class)c.getObject(this.getSyntax());
            if (h2TriggerClass == null) {
                String javaWhere = StringUtils.doubleQuote(where);
                String javaCols = "java.util.Arrays.asList(" + CollectionUtils.join(cols, ", ", new ITransformer<String, String>(){

                    @Override
                    public String transformChecked(String col) {
                        return StringUtils.doubleQuote(col);
                    }
                }) + ")";
                body = "AS $$ org.h2.api.Trigger create(){ return new " + PartialUniqueTrigger.class.getName() + "(" + javaCols + ", " + javaWhere + "); } $$";
                assert (H2_UNIQUE_TRIGGER_PATTERN.matcher(body).find());
            } else {
                PartialUniqueTrigger h2Trigger;
                try {
                    h2Trigger = (PartialUniqueTrigger)h2TriggerClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Couldn't instantiate " + h2TriggerClass, e);
                }
                if (!h2Trigger.getColumns().equals(cols) || !Objects.equals(SQLTable.workAroundForH2WhereTrigger(h2Trigger.getWhere()), SQLTable.workAroundForH2WhereTrigger(where))) {
                    throw new IllegalArgumentException("Wrong parameters returned by " + h2TriggerClass);
                }
                if (!h2TriggerClass.getSimpleName().endsWith(H2_UNIQUE_TRIGGER_CLASS_SUFFIX)) {
                    throw new IllegalArgumentException("Class name invalid, must end by '" + H2_UNIQUE_TRIGGER_CLASS_SUFFIX + "' : " + h2TriggerClass);
                }
                body = "CALL " + SQLBase.quoteIdentifier(h2TriggerClass.getName());
                assert (H2_UNIQUE_TRIGGER_CLASS_PATTERN.matcher(body).find());
            }
            UniqueTrigger trigger = new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS), comment){

                @Override
                protected String getBody(SQLName tableName) {
                    return body;
                }

                @Override
                protected String getInitialCheckBody(SQLName tableName) {
                    String select = this.getInitialCheckSelect(cols, where, tableName);
                    return "SELECT CASE WHEN (" + select + ") > 0 then CSVREAD('Unique constraint violation') else 'OK' end case;";
                }
            };
            if (this.checkExistingUniqueness()) {
                this.addOutsideClause(trigger.createInitialCheckClause());
            }
            return this.addOutsideClause(trigger);
        }
        if (system == SQLSystem.MYSQL) {
            final UniqueTrigger trigger = new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS[0]), comment){

                @Override
                protected String getBody(SQLName tableName) {
                    String body = "BEGIN IF " + ChangeTable.getNotNullWhere(cols, "NEW.") + " THEN\n" + "IF ( SELECT COUNT(*) from " + tableName + " where " + where + " and " + CollectionUtils.join(cols, " and ", new ITransformer<String, String>(){

                        @Override
                        public String transformChecked(String col) {
                            return String.valueOf(SQLBase.quoteIdentifier(col)) + " = NEW." + SQLBase.quoteIdentifier(col);
                        }
                    }) + ") > 1 then\n" + MYSQL_TRIGGER_EXCEPTION + "; END IF; \n" + "END IF; \n" + "END";
                    return body;
                }

                @Override
                protected String getInitialCheckBody(SQLName tableName) {
                    String procName = SQLBase.quoteIdentifier("checkUniqueness_" + tableName.getName());
                    String res = "DROP PROCEDURE IF EXISTS " + procName + ";\n";
                    res = String.valueOf(res) + "CREATE PROCEDURE " + procName + "() BEGIN\n";
                    String select = this.getInitialCheckSelect(cols, where, tableName);
                    res = String.valueOf(res) + "IF (" + select + ") > 0 THEN " + MYSQL_TRIGGER_EXCEPTION + "; END IF; \n";
                    res = String.valueOf(res) + "END;\n";
                    res = String.valueOf(res) + "CALL " + procName + ";";
                    return res;
                }
            };
            if (this.checkExistingUniqueness()) {
                this.addOutsideClause(trigger.createInitialCheckClause());
            }
            this.addOutsideClause(trigger);
            int i = 1;
            while (i < TRIGGER_EVENTS.length) {
                this.addOutsideClause(new UniqueTrigger(name, Arrays.asList(TRIGGER_EVENTS[i]), comment){

                    @Override
                    protected String getBody(SQLName tableName) {
                        return trigger.getBody(tableName);
                    }

                    @Override
                    protected String getInitialCheckBody(SQLName tableName) {
                        return trigger.getInitialCheckBody(tableName);
                    }
                });
                ++i;
            }
            return this.thisAsT();
        }
        throw new UnsupportedOperationException("System isn't supported : " + (Object)((Object)system));
    }

    protected final DeferredClause createUniqueConstraint(final String name, final List<String> cols) {
        return new DeferredClause(){

            @Override
            public String asString(ChangeTable<?> ct, SQLName tableName) {
                return String.valueOf(ct.getConstraintPrefix()) + "CONSTRAINT " + ChangeTable.getQuotedConstraintName(tableName, name) + " UNIQUE (" + SQLSyntax.quoteIdentifiers(cols) + ")";
            }

            @Override
            public ClauseType getType() {
                return ClauseType.ADD_CONSTRAINT;
            }
        };
    }

    private boolean checkExistingUniqueness() {
        return this instanceof AlterTable;
    }

    protected final DeferredClause createUniquePartialIndex(String name, List<String> cols, String userWhere) {
        Where notNullWhere = this.getSyntax().getSystem() == SQLSystem.MSSQL ? Where.createRaw(ChangeTable.getNotNullWhere(cols), new FieldRef[0]) : null;
        Where w = Where.and(notNullWhere, Where.createRaw(userWhere, new FieldRef[0]));
        return this.getSyntax().getCreateIndex(new SQLTable.SQLIndex(name, cols, true, true, w.toString()));
    }

    private static String getNotNullWhere(List<String> cols) {
        return ChangeTable.getNotNullWhere(cols, "");
    }

    private static String getNotNullWhere(List<String> cols, final String prefix) {
        return CollectionUtils.join(cols, " and ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String col) {
                return String.valueOf(prefix) + SQLBase.quoteIdentifier(col) + " IS NOT NULL";
            }
        });
    }

    protected static final String getQuotedConstraintName(SQLName tableName, String name) {
        return SQLBase.quoteIdentifier(ChangeTable.getIndexName(tableName, name));
    }

    protected static final String getIndexName(SQLName tableName, String name) {
        return SQLSyntax.getSchemaUniqueName(tableName.getName(), name);
    }

    private static SQLName getTriggerName(SQLName tableName, String indexName, String event) {
        return new SQLName(tableName.getItem(-2), SQLSyntax.getSchemaUniqueName(tableName.getName(), String.valueOf(indexName) + ChangeTable.getTriggerSuffix(event)));
    }

    protected abstract String getConstraintPrefix();

    public final T addClause(String s, ClauseType type) {
        this.clauses.getInClauses().addClause(s, type);
        return this.thisAsT();
    }

    protected final InAndOutClauses getClauses() {
        InAndOutClauses res = new InAndOutClauses(this.clauses);
        this.modifyClauses(res);
        return res;
    }

    protected void modifyClauses(InAndOutClauses res) {
        res.getInClauses().addAllClauses(this.getForeignConstraintsClauses());
    }

    public final T addClause(DeferredClause s) {
        this.clauses.getInClauses().addClause(s);
        return this.thisAsT();
    }

    public final T addOutsideClause(DeferredClause s) {
        this.clauses.getOutClauses().addClause(s);
        return this.thisAsT();
    }

    public final String asString() {
        return this.asString(NameTransformer.NOP);
    }

    public final String asString(String rootName) {
        return this.asString(new ChangeRootNameTransformer(rootName));
    }

    public abstract String asString(NameTransformer var1);

    protected abstract String asString(NameTransformer var1, ConcatStep var2);

    protected final List<DeferredGeneralClause> getForeignConstraintsClauses() {
        ArrayList<DeferredGeneralClause> res = new ArrayList<DeferredGeneralClause>(this.fks.size());
        for (final FCSpec fk : this.fks) {
            res.add(new DeferredGeneralClause(){

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_CONSTRAINT;
                }

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName, NameTransformer transf) {
                    SQLName relRefTable = fk.getRefTable();
                    SQLName refTable = transf.transformLinkDestTableName(ChangeTable.this.getRootName(), ChangeTable.this.getName(), relRefTable);
                    return String.valueOf(ct.getConstraintPrefix()) + ct.getSyntax().getFK(tableName.getName(), fk.getCols(), refTable, fk.getRefCols(), fk.getUpdateRule(), fk.getDeleteRule());
                }
            });
        }
        return res;
    }

    public String toString() {
        return this.asString();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getRootName() {
        return this.rootName;
    }

    public static class ChangeRootNameTransformer
    extends NameTransformer {
        private final String r;

        public ChangeRootNameTransformer(String r) {
            this.r = r;
        }

        @Override
        public SQLName transformTableName(SQLName tableName) {
            return new SQLName(this.r, tableName.getName());
        }

        @Override
        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return linkDest.getItemCount() == 1 ? this.transformTableName(new SQLName(rootName, linkDest.getName())) : linkDest;
        }
    }

    public static enum ClauseType {
        ADD_COL,
        ADD_CONSTRAINT,
        ADD_INDEX,
        DROP_COL,
        DROP_CONSTRAINT,
        DROP_INDEX,
        ALTER_COL,
        OTHER,
        OTHER_DROP,
        OTHER_ADD;

    }

    protected static final class Clauses {
        private final ListMap<ClauseType, DeferredGeneralClause> clauses;

        Clauses() {
            this.clauses = new ListMap();
        }

        Clauses(Clauses clauses) {
            this.clauses = new ListMap(clauses.clauses);
        }

        public void reset() {
            this.clauses.clear();
        }

        public final void addClause(String s, ClauseType type) {
            this.addClause(-1, s, type);
        }

        public final void addClause(int index, final String s, final ClauseType type) {
            this.addClause(index, new DeferredGeneralClause(){

                @Override
                public ClauseType getType() {
                    return type;
                }

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName, NameTransformer transf) {
                    return s;
                }
            });
        }

        public final void addClause(DeferredGeneralClause s) {
            this.addClause(-1, s);
        }

        public final void addClause(int index, DeferredGeneralClause s) {
            if (s != null) {
                if (index < 0) {
                    this.clauses.add(s.getType(), s);
                } else {
                    this.clauses.addAll(s.getType(), Collections.emptyList());
                    ((List)this.clauses.get((Object)s.getType())).add(index, s);
                }
            }
        }

        public final void addAllClauses(List<DeferredGeneralClause> clauses) {
            for (DeferredGeneralClause c : clauses) {
                this.addClause(c);
            }
        }

        private final List<String> getClauses(final ChangeTable<?> ct, final SQLName tableName, final NameTransformer transf, Set<ClauseType> types, String intraTypeSep) {
            ITransformer<DeferredGeneralClause, String> tf = new ITransformer<DeferredGeneralClause, String>(){

                @Override
                public String transformChecked(DeferredGeneralClause input) {
                    return input.asString(ct, tableName, transf);
                }
            };
            ArrayList<String> res = new ArrayList<String>();
            for (ClauseType type : ORDERED_TYPES) {
                List clauses;
                if (!types.contains((Object)type) || (clauses = (List)this.clauses.getNonNull(type)).size() <= 0) continue;
                if (intraTypeSep == null) {
                    for (DeferredGeneralClause c : clauses) {
                        res.add((String)tf.transformChecked(c));
                    }
                    continue;
                }
                res.add(CollectionUtils.join(clauses, intraTypeSep, tf));
            }
            return res;
        }

        protected final List<String> getClauses(ChangeTable<?> ct, SQLName tableName, NameTransformer transf, Set<ClauseType> types) {
            return this.getClauses(ct, tableName, transf, types, null);
        }

        protected final void appendTo(StringBuffer res, ChangeTable<?> ct, SQLName tableName, NameTransformer transf, Set<ClauseType> types) {
            List<String> outClauses = this.getClauses(ct, tableName, transf, types);
            if (outClauses.size() > 0) {
                res.append("\n\n");
                res.append(CollectionUtils.join(outClauses, "\n"));
            }
        }
    }

    public static enum ConcatStep {
        DROP_CONSTRAINT(ClauseType.DROP_CONSTRAINT),
        DROP_INDEX(ClauseType.DROP_INDEX),
        ALTER_TABLE(ClauseType.OTHER_DROP, ClauseType.DROP_COL, ClauseType.ADD_COL, ClauseType.OTHER_ADD, ClauseType.ALTER_COL, ClauseType.OTHER),
        ADD_INDEX(ClauseType.ADD_INDEX),
        ADD_CONSTRAINT(ClauseType.ADD_CONSTRAINT);

        private final Set<ClauseType> types = new LinkedHashSet<ClauseType>();

        private ConcatStep(ClauseType ... types) {
            ClauseType[] clauseTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                ClauseType t = clauseTypeArray[n3];
                this.types.add(t);
                ++n3;
            }
        }

        public final Set<ClauseType> getTypes() {
            return this.types;
        }
    }

    public static abstract class DeferredClause
    implements DeferredGeneralClause {
        protected abstract String asString(ChangeTable<?> var1, SQLName var2);

        @Override
        public final String asString(ChangeTable<?> ct, SQLName tableName, NameTransformer transf) {
            return this.asString(ct, tableName);
        }
    }

    protected static interface DeferredGeneralClause {
        public String asString(ChangeTable<?> var1, SQLName var2, NameTransformer var3);

        public ClauseType getType();
    }

    protected static final class DropUniqueTrigger
    extends DeferredClause {
        private final String indexName;
        private final String event;

        protected DropUniqueTrigger(String indexName) {
            this(indexName, null);
        }

        protected DropUniqueTrigger(String indexName, String event) {
            this.indexName = indexName;
            this.event = event;
        }

        @Override
        public final ClauseType getType() {
            return ClauseType.OTHER_DROP;
        }

        @Override
        public final String asString(ChangeTable<?> ct, SQLName tableName) {
            return "DROP TRIGGER IF EXISTS " + ChangeTable.getTriggerName(tableName, this.indexName, this.event) + ";";
        }
    }

    public static final class FCSpec {
        private final List<String> cols;
        private final SQLName refTable;
        private final List<String> refCols;
        private final Link.Rule updateRule;
        private final Link.Rule deleteRule;

        public static FCSpec createFromLink(Link l) {
            return FCSpec.createFromLink(l, (SQLTable)l.getTarget());
        }

        public static FCSpec createFromLink(Link l, SQLTable newDest) {
            if (newDest != l.getTarget()) {
                List<SQLField> ffs = l.getFields();
                Set<SQLField> pks = newDest.getPrimaryKeys();
                if (ffs.size() != pks.size()) {
                    throw new IllegalArgumentException("Size mismatch : " + ffs + " " + pks);
                }
                int i = 0;
                for (SQLField pk : pks) {
                    if (!ffs.get(i).getType().equals(pk.getType())) {
                        throw new IllegalArgumentException("Type mismatch " + ffs.get(i) + " " + pk);
                    }
                    ++i;
                }
            }
            return new FCSpec(l.getCols(), newDest.getContextualSQLName((SQLIdentifier)l.getSource()), newDest.getPKsNames(), l.getUpdateRule(), l.getDeleteRule());
        }

        public FCSpec(List<String> cols, SQLName refTable, List<String> refCols, Link.Rule updateRule, Link.Rule deleteRule) {
            if (refTable.getItemCount() == 0) {
                throw new IllegalArgumentException(refTable + " is empty.");
            }
            this.cols = Collections.unmodifiableList(new ArrayList<String>(cols));
            this.refTable = refTable;
            this.refCols = Collections.unmodifiableList(new ArrayList<String>(refCols));
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final SQLName getRefTable() {
            return this.refTable;
        }

        public final List<String> getRefCols() {
            return this.refCols;
        }

        public final Link.Rule getUpdateRule() {
            return this.updateRule;
        }

        public final Link.Rule getDeleteRule() {
            return this.deleteRule;
        }
    }

    public static final class ForeignColSpec {
        private String fk;
        private final SQLName table;
        private final String pk;
        private final String defaultVal;

        public static ForeignColSpec fromCreateTable(SQLCreateTableBase<?> createTable) {
            List<String> primaryKey = createTable.getPrimaryKey();
            if (primaryKey.size() != 1) {
                throw new IllegalArgumentException("Not exactly one field in the foreign primary key : " + primaryKey);
            }
            return new ForeignColSpec(null, new SQLName(createTable.getRootName(), createTable.getName()), primaryKey.get(0), null);
        }

        public static ForeignColSpec fromTable(SQLTable foreignTable) {
            return ForeignColSpec.fromTable(foreignTable, true);
        }

        public static ForeignColSpec fromTable(SQLTable foreignTable, boolean absolute) {
            if (foreignTable == null) {
                throw new NullPointerException("null table");
            }
            String defaultVal = foreignTable.getKey().getType().toString(foreignTable.getUndefinedIDNumber());
            SQLName n = absolute ? foreignTable.getSQLName() : new SQLName(foreignTable.getName());
            return new ForeignColSpec(null, n, foreignTable.getKey().getName(), defaultVal);
        }

        public ForeignColSpec(String fk, SQLName table, String pk, String defaultVal) {
            this.table = table;
            this.setColumnName(fk);
            this.pk = pk;
            this.defaultVal = defaultVal;
        }

        public final ForeignColSpec setColumnNameFromTable() {
            return this.setColumnNameWithSuffix("");
        }

        public final ForeignColSpec setColumnNameWithSuffix(String suffix) {
            return this.setColumnName("ID_" + this.getTable().getName() + (suffix.length() == 0 ? "" : "_" + suffix));
        }

        public final ForeignColSpec setColumnName(String fk) {
            if (fk == null) {
                this.setColumnNameFromTable();
            } else {
                this.fk = fk;
            }
            return this;
        }

        public final String getColumnName() {
            return this.fk;
        }

        public final SQLName getTable() {
            return this.table;
        }

        public final String getPrimaryKeyName() {
            return this.pk;
        }

        public final String getDefaultVal() {
            return this.defaultVal;
        }

        public final FCSpec createFCSpec(Link.Rule updateRule, Link.Rule deleteRule) {
            return new FCSpec(Collections.singletonList(this.getColumnName()), this.getTable(), Collections.singletonList(this.getPrimaryKeyName()), updateRule, deleteRule);
        }
    }

    protected static final class InAndOutClauses {
        private final Clauses inClauses;
        private final Clauses outClauses;

        protected InAndOutClauses() {
            this.inClauses = new Clauses();
            this.outClauses = new Clauses();
        }

        protected InAndOutClauses(InAndOutClauses c) {
            this.inClauses = new Clauses(c.inClauses);
            this.outClauses = new Clauses(c.outClauses);
        }

        public void reset() {
            this.inClauses.reset();
            this.outClauses.reset();
        }

        public boolean isEmpty() {
            return this.inClauses.clauses.isEmpty() && this.outClauses.clauses.isEmpty();
        }

        public Clauses getInClauses() {
            return this.inClauses;
        }

        public Clauses getOutClauses() {
            return this.outClauses;
        }
    }

    public static class NameTransformer {
        public static final NameTransformer NOP = new NameTransformer();

        public SQLName transformTableName(SQLName tableName) {
            return tableName;
        }

        public SQLName transformLinkDestTableName(String rootName, String tableName, SQLName linkDest) {
            return this.transformTableName(linkDest.getItemCount() == 1 ? new SQLName(rootName, linkDest.getName()) : linkDest);
        }
    }

    private static abstract class UniqueTrigger
    extends DeferredClause {
        private final String indexName;
        private final List<String> events;
        private final String comment;

        public UniqueTrigger(String indexName, List<String> events, String comment) {
            this.indexName = indexName;
            this.events = events;
            this.comment = comment;
        }

        @Override
        public final ClauseType getType() {
            return ClauseType.OTHER_ADD;
        }

        @Override
        public final String asString(ChangeTable<?> ct, SQLName tableName) {
            SQLName triggerName = ChangeTable.getTriggerName(tableName, this.indexName, CollectionUtils.getSole(this.events));
            String createTriggerSQL = "CREATE TRIGGER " + triggerName + " AFTER " + CollectionUtils.join(this.events, ", ") + " on " + tableName + " FOR EACH ROW " + this.getBody(tableName) + ';';
            return this.comment == null ? createTriggerSQL : "-- " + this.comment + "\n" + createTriggerSQL;
        }

        protected abstract String getBody(SQLName var1);

        protected abstract String getInitialCheckBody(SQLName var1);

        protected final String getInitialCheckSelect(List<String> cols, String where, SQLName tableName) {
            Where notNullWhere = Where.createRaw(ChangeTable.getNotNullWhere(cols), new FieldRef[0]);
            Where w = Where.and(notNullWhere, Where.createRaw(where, new FieldRef[0]));
            return "SELECT count(*) FROM " + tableName + " where " + w + " group by " + SQLSyntax.quoteIdentifiers(cols) + " having count(*)>1";
        }

        protected final DeferredClause createInitialCheckClause() {
            return new DeferredClause(){

                @Override
                public ClauseType getType() {
                    return this.getType();
                }

                @Override
                public String asString(ChangeTable<?> ct, SQLName tableName) {
                    return this.getInitialCheckBody(tableName);
                }
            };
        }
    }
}

