/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.ui.textmenu.TextFieldMenuItem;
import org.openconcerto.sql.ui.textmenu.TextFieldMenuTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.Tuple2;

public class TextFieldCustomTablePanel
extends JPanel {
    private final JTextComponent textComp;
    private final TextFieldMenuTableModel textFieldMenuTableModel;
    private final List<AbstractAction> actions = new ArrayList<AbstractAction>();

    public TextFieldCustomTablePanel(JTextComponent textComp, List<TextFieldMenuItem> items, String colName) {
        super(new GridBagLayout());
        this.textComp = textComp;
        this.textFieldMenuTableModel = new TextFieldMenuTableModel(items, colName);
        this.UIInit();
    }

    public void addAction(AbstractAction action) {
        this.actions.add(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    private void UIInit() {
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        JTable jTable = new JTable(this.textFieldMenuTableModel);
        this.add((Component)new JScrollPane(jTable), c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 0;
        c.anchor = 13;
        JButton b = new JButton("Valider");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFieldCustomTablePanel.this.fillTextComp();
                ((JDialog)SwingUtilities.getRoot(TextFieldCustomTablePanel.this)).dispose();
            }
        });
        jTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.add((Component)b, c);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && TextFieldCustomTablePanel.this.actions.size() > 0) {
                    JPopupMenu menu = new JPopupMenu();
                    for (final AbstractAction action : TextFieldCustomTablePanel.this.actions) {
                        menu.add(new AbstractAction(action.getValue("Name").toString()){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                ((JDialog)SwingUtilities.getRoot(TextFieldCustomTablePanel.this)).dispose();
                                action.actionPerformed(arg0);
                            }
                        });
                    }
                    menu.show(TextFieldCustomTablePanel.this, e.getX(), e.getY());
                }
            }
        });
    }

    private void fillTextComp() {
        StringBuffer buf = new StringBuffer();
        List<Tuple2<TextFieldMenuItem, Boolean>> items = this.textFieldMenuTableModel.getItems();
        ArrayList<TextFieldMenuItem> validItems = new ArrayList<TextFieldMenuItem>(items.size());
        for (Tuple2<TextFieldMenuItem, Boolean> item : items) {
            if (!item.get1().booleanValue() || !item.get0().isEnabled()) continue;
            validItems.add(item.get0());
        }
        int itemCount = validItems.size();
        int i = 0;
        while (i < itemCount) {
            TextFieldMenuItem item = (TextFieldMenuItem)validItems.get(i);
            buf.append(String.valueOf(item.getName()) + (i < itemCount - 1 ? ", " : ""));
            ++i;
        }
        this.textComp.setText(buf.toString());
    }
}

