/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.navigator.ElementsSQLBrowserColumn;
import org.openconcerto.sql.navigator.ListStateModel;
import org.openconcerto.sql.navigator.RowsSQLListModel;
import org.openconcerto.sql.navigator.SQLBrowser;
import org.openconcerto.sql.navigator.SQLBrowserColumn;
import org.openconcerto.ui.list.selection.ListSelectionState;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class RowsSQLBrowserColumn
extends SQLBrowserColumn<SQLRow, RowsSQLListModel> {
    protected final List<Integer> ids = new ArrayList<Integer>();
    private final List<SQLField> children = new ArrayList<SQLField>();
    private final ListSelectionState state;
    static Color yellow = new Color(252, 253, 148);

    public RowsSQLBrowserColumn(SQLElement element) {
        this(element, true);
    }

    public RowsSQLBrowserColumn(SQLElement element, boolean searchable) {
        super(new RowsSQLListModel(element), searchable);
        this.uiInit();
        this.state = ListSelectionState.manage(this.list.getSelectionModel(), new ListStateModel((RowsSQLListModel)this.getModel()));
    }

    @Override
    protected int getSelectionMode() {
        return 1;
    }

    @Override
    protected ListSelectionState getSelectionState() {
        return this.state;
    }

    @Override
    public void addSelectionListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("selection", listener);
    }

    @Override
    public void removeSelectionListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener("selection", listener);
    }

    @Override
    protected void selectionCleared() {
        this.ids.clear();
        this.highlight(Collections.emptySet());
    }

    @Override
    protected SQLBrowserColumn selectionChanged(ListSelectionModel m) {
        List<SQLRow> values = this.getSelectedRows();
        ArrayList<Integer> selectedIds = new ArrayList<Integer>();
        for (SQLRow obj : values) {
            selectedIds.add(obj.getID());
        }
        this.ids.clear();
        this.ids.addAll(selectedIds);
        this.highlight(Collections.emptySet());
        SQLBrowserColumn<?, ?> res = this.next() != null ? this.next() : this.createNextCol();
        if (res != null) {
            res.setParentIDs(this.ids);
        }
        return res;
    }

    @Override
    public void setSelectedRow(SQLRow o) {
        this.list.setSelectedValue(o, true);
    }

    private SQLBrowserColumn<?, ?> createNextCol() {
        SQLBrowserColumn res;
        List<SQLField> refFields = this.getChildrenReferentFields();
        if (refFields.size() == 0 || this.getSelectedIDs().isEmpty()) {
            res = null;
        } else if (refFields.size() == 1) {
            SQLField refField = refFields.get(0);
            res = new RowsSQLBrowserColumn(this.getElement(refField), this.isSearchable());
        } else {
            ArrayList<SQLElement> elements = new ArrayList<SQLElement>(refFields.size());
            for (SQLField refField : refFields) {
                elements.add(this.getElement(refField));
            }
            res = new ElementsSQLBrowserColumn(this.getElement(), elements);
        }
        return res;
    }

    private SQLElement getElement(SQLField refField) {
        return Configuration.getInstance().getDirectory().getElement(refField.getTable());
    }

    @Override
    public List<Integer> getSelectedIDs() {
        return this.ids;
    }

    @Override
    public List<SQLRow> getSelectedRows() {
        if (this.isAllSelected()) {
            return ((RowsSQLListModel)this.getModel()).getRealItems();
        }
        return CollectionUtils.castToList(this.list.getSelectedValues(), SQLRow.class);
    }

    public final ListStateModel getStateModel() {
        return (ListStateModel)this.getSelectionState().getModel();
    }

    public List<SQLField> getChildrenReferentFields() {
        return this.children;
    }

    public final SQLElement getElement() {
        return ((RowsSQLListModel)this.getModel()).getElement();
    }

    @Override
    public final SQLTable getTable() {
        return this.getElement().getTable();
    }

    @Override
    protected String getHeaderName() {
        String headerName = this.getElement().getPluralName();
        return String.valueOf(headerName.substring(0, 1).toUpperCase()) + headerName.substring(1);
    }

    public SQLRow getFirstSelectedRow() {
        int firstId = this.getFirstId();
        if (firstId > 0) {
            return this.getTable().getRow(firstId);
        }
        return null;
    }

    private int getFirstId() {
        if (this.ids.size() > 0) {
            return this.ids.get(0);
        }
        return -1;
    }

    @Override
    protected void die() {
        this.deselect();
        ((RowsSQLListModel)this.getModel()).die();
    }

    @Override
    protected void live() {
        ITransformer<SQLElement, Collection<SQLField>> transf = this.getParentBrowser().getChildrenTransformer();
        Collection<SQLField> res = transf == null ? null : transf.transformChecked(this.getElement());
        this.children.clear();
        if (res == null) {
            this.children.addAll(this.getElement().getChildrenReferentFields());
        } else {
            this.children.addAll(res);
        }
    }

    void highlight(Set<SQLRow> rows) {
        int firstH;
        ((RowsSQLListModel)this.getModel()).setHighlighted(rows);
        RowsSQLBrowserColumn p = this.previousRowsColumn();
        if (p != null) {
            if (((RowsSQLListModel)this.getModel()).getHighlighted().isEmpty()) {
                p.highlight(this.getSelectedParents());
            } else {
                p.highlight(this.getHighlightedParents());
            }
        }
        if ((firstH = ((RowsSQLListModel)this.getModel()).getFirstHighlighted()) >= 0) {
            this.list.ensureIndexIsVisible(firstH);
        }
    }

    @Override
    protected void render(JLabel comp, SQLRow value) {
        super.render(comp, value);
        if (((RowsSQLListModel)this.getModel()).getHighlighted().contains(value)) {
            comp.setBackground(yellow);
            comp.setForeground(Color.BLACK);
        }
    }

    private Set<SQLRow> getSelectedParents() {
        return RowsSQLBrowserColumn.getParents(this.getSelectedRows());
    }

    private Set<SQLRow> getHighlightedParents() {
        return RowsSQLBrowserColumn.getParents(((RowsSQLListModel)this.getModel()).getHighlighted());
    }

    private static Set<SQLRow> getParents(Collection<SQLRow> rows) {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        for (SQLRow r : rows) {
            SQLRow parent = SQLBrowser.getElement(r.getTable()).getForeignParent(r);
            if (parent == null) continue;
            res.add(parent);
        }
        return res;
    }
}

