/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.Clob;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.RowRef;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.HashingStrategy;
import org.openconcerto.utils.convertor.StringClobConvertor;

public abstract class SQLRowAccessor
implements SQLData {
    @Deprecated
    public static final String ACCESS_DB_IF_NEEDED_PROP = "SQLRowAccessor.accessDBIfNeeded";
    private static final boolean ACCESS_DB_IF_NEEDED = Boolean.parseBoolean(System.getProperty("SQLRowAccessor.accessDBIfNeeded", "false"));
    private static final HashingStrategy<SQLRowAccessor> ROW_STRATEGY = new HashingStrategy<SQLRowAccessor>(){

        @Override
        public int computeHashCode(SQLRowAccessor object) {
            return object.hashCodeAsRow();
        }

        @Override
        public boolean equals(SQLRowAccessor object1, SQLRowAccessor object2) {
            return object1.equalsAsRow(object2);
        }
    };
    private final SQLTable table;

    public static boolean getAccessDBIfNeeded() {
        return ACCESS_DB_IF_NEEDED;
    }

    public static final HashingStrategy<SQLRowAccessor> getRowStrategy() {
        return ROW_STRATEGY;
    }

    public static final Set<Number> getIDs(Collection<? extends SQLRowAccessor> rows) {
        return SQLRowAccessor.getIDs(rows, new HashSet());
    }

    public static final <C extends Collection<? super Number>> C getIDs(Collection<? extends SQLRowAccessor> rows, C res) {
        for (SQLRowAccessor sQLRowAccessor : rows) {
            res.add((Number)sQLRowAccessor.getIDNumber());
        }
        return res;
    }

    protected SQLRowAccessor(SQLTable table) {
        if (table == null) {
            throw new NullPointerException("null SQLTable");
        }
        this.table = table;
    }

    @Override
    public final SQLTable getTable() {
        return this.table;
    }

    public final boolean hasID() throws ClassCastException {
        return this.getIDNumber() != null;
    }

    public abstract int getID();

    public abstract Number getIDNumber();

    public final RowRef getRowRef() {
        List<String> pkFields = this.getTable().getPKsNames();
        ArrayList<Object> pk = new ArrayList<Object>(pkFields.size());
        for (String f : pkFields) {
            Object o = this.getObject(f);
            if (o == null) {
                return null;
            }
            pk.add(o);
        }
        return new RowRef(this.getTable(), Collections.unmodifiableList(pk), true);
    }

    public final boolean isUndefined() {
        Number id = this.getIDNumber();
        return id != null && id.intValue() == this.getTable().getUndefinedID();
    }

    public final boolean isArchived() {
        return this.isArchived(true);
    }

    protected final boolean isArchived(boolean allowDBAccess) {
        SQLField archiveField = this.getTable().getArchiveField();
        if (archiveField == null) {
            return false;
        }
        Object archiveVal = this.getRequiredObject(archiveField.getName(), allowDBAccess);
        if (archiveField.getType().getJavaType().equals(Boolean.class)) {
            return (Boolean)archiveVal;
        }
        return ((Number)archiveVal).intValue() > 0;
    }

    public abstract SQLRowAccessor toImmutable();

    public abstract boolean isFrozen();

    public final SQLRow asRow() {
        return this.asRow(null);
    }

    public abstract SQLRow asRow(Boolean var1);

    public final SQLRow trimmedRow(SQLTable.VirtualFields fields) {
        Set<String> fieldsNames = this.getTable().getFieldsNames(fields);
        if (this instanceof SQLRow && this.isFrozen() && fieldsNames.containsAll(this.getFields())) {
            return (SQLRow)this;
        }
        return SQLRow.trim(this, SQLRowAccessor::getValues, fieldsNames);
    }

    public final SQLRow fetchNewRow() {
        return this.fetchNewRow(true);
    }

    public final SQLRow fetchNewRow(boolean useCache) {
        return new SQLRow(this.getTable(), this.getID()).fetchValues(useCache);
    }

    public final SQLRowValues asRowValues() {
        return this.asRowValues(null);
    }

    public abstract SQLRowValues asRowValues(Boolean var1);

    public final SQLRowValues createEmptyUpdateRow() {
        return new SQLRowValues(this.getTable()).setID(this.getIDNumber());
    }

    public abstract Set<String> getFields();

    public boolean contains(String fieldName) {
        return this.getFields().contains(fieldName);
    }

    public abstract Object getObject(String var1);

    public final Object getContainedObject(String fieldName) throws IllegalArgumentException {
        return this.getObject(fieldName, true);
    }

    protected final Object getRequiredObject(String fieldName, boolean allowDBAccess) throws IllegalArgumentException {
        return this.getObject(fieldName, this instanceof SQLRowValues || !allowDBAccess);
    }

    public final Object getObject(String fieldName, boolean mustBePresent) throws IllegalArgumentException {
        if (mustBePresent && !this.contains(fieldName)) {
            String msg = this.getTable().contains(fieldName) ? "Field " + fieldName + " not present in this : " + this.getFields() + " but exists in " + this.getTable() : "Field " + fieldName + " neither present in this : " + this.getFields() + " nor " + this.getTable();
            throw new IllegalArgumentException(msg);
        }
        return this.getObject(fieldName);
    }

    public abstract Map<String, Object> getAbsolutelyAll();

    public final Map<String, Object> getValues(SQLTable.VirtualFields vFields) {
        return this.getValues(this.getTable().getFieldsNames(vFields));
    }

    public final Map<String, Object> getValues(Collection<String> fields) {
        return this.getValues(fields, false);
    }

    public final Map<String, Object> getValues(Collection<String> fields, boolean includeMissingKeys) {
        this.initValues();
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        Set<String> thisFields = this.getFields();
        for (String f : fields) {
            if (!includeMissingKeys && !thisFields.contains(f)) continue;
            res.put(f, this.getObject(f));
        }
        return res;
    }

    protected void initValues() {
    }

    public final String getString(String field) {
        String result = null;
        Object obj = this.getObject(field);
        if (obj == null) {
            result = null;
        } else if (obj instanceof Date) {
            DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
            result = df.format((Date)obj);
        } else if (obj instanceof Clob) {
            try {
                result = (String)StringClobConvertor.INSTANCE.unconvert((Clob)obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = obj.toString();
            }
        } else {
            result = obj.toString();
        }
        return result;
    }

    public final int getInt(String field) {
        return this.getObjectAs(field, Number.class).intValue();
    }

    public final long getLong(String field) {
        return this.getObjectAs(field, Number.class).longValue();
    }

    public final float getFloat(String field) {
        return this.getObjectAs(field, Number.class).floatValue();
    }

    public final Boolean getBoolean(String field) {
        return this.getObjectAs(field, Boolean.class);
    }

    public final BigDecimal getBigDecimal(String field) {
        return this.getObjectAs(field, BigDecimal.class);
    }

    public final Calendar getDate(String field) {
        Date d = this.getObjectAs(field, Date.class);
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public final <T> T getObjectAs(String field, Class<T> clazz) {
        return this.getObjectAs(field, false, clazz);
    }

    public final <T> T getObjectAs(String field, boolean mustBePresent, Class<T> clazz) {
        T res = null;
        try {
            res = clazz.cast(this.getObject(field, mustBePresent));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Impossible d'acc\u00e9der au champ " + field + " de la ligne " + this + " en tant que " + clazz.getSimpleName(), e);
        }
        return res;
    }

    protected final SQLTable getForeignTable(String fieldName) throws IllegalArgumentException {
        return (SQLTable)this.getForeignLink(Collections.singletonList(fieldName)).getTarget();
    }

    protected final Link getForeignLink(List<String> fieldsNames) throws IllegalArgumentException {
        DatabaseGraph graph = this.getTable().getDBSystemRoot().getGraph();
        Link foreignLink = graph.getForeignLink(this.getTable(), fieldsNames);
        if (foreignLink == null) {
            throw new IllegalArgumentException(fieldsNames + " are not a foreign key of " + this.getTable());
        }
        return foreignLink;
    }

    public abstract SQLRowAccessor getForeign(String var1);

    public final SQLRowAccessor getNonEmptyForeign(String fieldName) {
        if (this.isForeignEmpty(fieldName)) {
            return null;
        }
        SQLRowAccessor res = this.getForeign(fieldName);
        assert (res != null);
        return res;
    }

    public final int getForeignID(String fieldName) throws IllegalArgumentException {
        Number res = this.getForeignIDNumber(fieldName);
        return res == null ? -1 : res.intValue();
    }

    public final Number getForeignIDNumber(String fieldName) throws IllegalArgumentException {
        Value<Number> res = this.getForeignIDNumberValue(fieldName);
        return res.hasValue() ? (Number)res.getValue() : (Number)null;
    }

    public final Number getNonEmptyForeignIDNumber(String fieldName) {
        if (this.isForeignEmpty(fieldName)) {
            return null;
        }
        Value<Number> res = this.getForeignIDNumberValue(fieldName);
        if (!res.hasValue()) {
            throw new IllegalStateException("Foreign row has no ID");
        }
        assert (res.getValue() != null);
        return res.getValue();
    }

    public final Value<Number> getForeignIDNumberValue(String fieldName) throws IllegalArgumentException {
        this.fetchIfNeeded(fieldName);
        Object val = this.getContainedObject(fieldName);
        if (val instanceof SQLRowValues) {
            SQLRowValues vals = (SQLRowValues)val;
            return vals.hasID() ? Value.getSome(vals.getIDNumber()) : Value.getNone();
        }
        if (!this.getTable().getField(fieldName).isForeignKey()) {
            throw new IllegalArgumentException(String.valueOf(fieldName) + "is not a foreign key of " + this.getTable());
        }
        return Value.getSome((Number)val);
    }

    private void fetchIfNeeded(String fieldName) {
        if (SQLRowAccessor.getAccessDBIfNeeded() && this instanceof SQLRow && !this.contains(fieldName)) {
            assert (false) : "Missing " + fieldName + " in " + this;
            Log.get().log(Level.WARNING, "Missing " + fieldName + " in " + this, new IllegalStateException());
            ((SQLRow)this).fetchValues();
        }
    }

    public final boolean isForeignEmpty(String fieldName) {
        Value<Number> fID = this.getForeignIDNumberValue(fieldName);
        if (!fID.hasValue()) {
            return false;
        }
        SQLTable foreignTable = this.getForeignTable(fieldName);
        Number undefID = foreignTable.getUndefinedIDNumber();
        if (undefID != null && fID.getValue() == null) {
            assert (this.getObject(fieldName) == null);
            throw new IllegalStateException("Null isn't a valid foreign key value when pointing to a table with undefined ID : " + undefID);
        }
        return NumberUtils.areNumericallyEqual(fID.getValue(), undefID);
    }

    public abstract Collection<? extends SQLRowAccessor> getReferentRows();

    public abstract Collection<? extends SQLRowAccessor> getReferentRows(SQLField var1);

    public abstract Collection<? extends SQLRowAccessor> getReferentRows(SQLTable var1);

    public final Collection<? extends SQLRowAccessor> followLink(Link l) {
        return this.followLink(l, Link.Direction.ANY);
    }

    public abstract Collection<? extends SQLRowAccessor> followLink(Link var1, Link.Direction var2);

    public final BigDecimal getOrder() {
        return (BigDecimal)this.getObject(this.getTable().getOrderField().getName());
    }

    public final Calendar getCreationDate() {
        SQLField f = this.getTable().getCreationDateField();
        return f == null ? null : this.getDate(f.getName());
    }

    public final Calendar getModificationDate() {
        SQLField f = this.getTable().getModifDateField();
        return f == null ? null : this.getDate(f.getName());
    }

    public final boolean equalsAsRow(SQLRowAccessor o) {
        return this.getTable() == o.getTable() && this.getID() == o.getID();
    }

    public final int hashCodeAsRow() {
        return this.getTable().hashCode() + this.getID();
    }

    public abstract String mapToString();
}

