/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.EnumSet;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class SetDefaultCharset
extends Changer<DBRoot> {
    public SetDefaultCharset(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL);
    }

    @Override
    protected void changeImpl(DBRoot root) throws SQLException {
        this.getStream().println(root + "... ");
        this.getDS().execute("ALTER DATABASE CHARACTER SET default");
        for (SQLTable t : root.getTables()) {
            this.getStream().print("Converting " + t + "... ");
            String req = "ALTER table " + t.getSQLName().quote() + " convert to character set default";
            this.getDS().execute(req);
            this.getStream().println("done");
        }
    }
}

