/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;

public class GenerationMvtVirement
extends GenerationEcritures {
    private int id_compte_depart;
    private int id_compte_arrive;
    private int id_journal;
    private long debit;
    private long credit;
    private String labelPiece;
    private boolean clearMvt = true;
    private boolean fermeture = false;
    private boolean ouverture = false;

    public GenerationMvtVirement(int id_compte_depart, int id_compte_arrive, long debit, long credit, String label) {
        this(id_compte_depart, id_compte_arrive, debit, credit, label, new Date());
    }

    public GenerationMvtVirement(int id_compte_depart, int id_compte_arrive, long debit, long credit, String label, Date d) {
        this(id_compte_depart, id_compte_arrive, debit, credit, label, d, 4, label);
    }

    public GenerationMvtVirement(int id_compte_depart, int id_compte_arrive, long debit, long credit, String label, Date d, int idJournal, String labelPiece) {
        this.id_compte_depart = id_compte_depart;
        this.id_compte_arrive = id_compte_arrive;
        this.id_journal = idJournal;
        this.debit = debit;
        this.credit = credit;
        this.nom = label;
        this.date = d;
        this.idPiece = -1;
        this.labelPiece = labelPiece;
    }

    public void setOuverture(boolean ouverture) {
        this.ouverture = ouverture;
    }

    public void setFermeture(boolean fermeture) {
        this.fermeture = fermeture;
    }

    public void setValues(int id_compte_depart, int id_compte_arrive, long debit, long credit, String label, Date d, int idJournal, boolean clearMvt) {
        this.id_compte_depart = id_compte_depart;
        this.id_compte_arrive = id_compte_arrive;
        this.id_journal = idJournal;
        this.debit = debit;
        this.credit = credit;
        this.nom = label;
        this.date = d;
        this.clearMvt = clearMvt;
    }

    public int genereMouvement() throws SQLException {
        this.putValue("DATE", this.date);
        this.putValue("CLOTURE", this.fermeture);
        this.putValue("RAN", this.ouverture);
        this.putValue("NOM", this.nom);
        this.putValue("ID_JOURNAL", this.id_journal);
        this.putValue("ID_MOUVEMENT", 1);
        if (this.idPiece <= 1) {
            this.getNewMouvement("", 1, 1, this.labelPiece);
        } else if (this.clearMvt || this.idMvt <= 1) {
            this.getNewMouvement("", 1, 1, this.idPiece);
        }
        this.putValue("ID_MOUVEMENT", this.idMvt);
        this.putValue("ID_COMPTE_PCE", this.id_compte_depart);
        this.putValue("DEBIT", this.debit);
        this.putValue("CREDIT", this.credit);
        this.ajoutEcriture();
        this.putValue("ID_COMPTE_PCE", this.id_compte_arrive);
        this.putValue("DEBIT", this.credit);
        this.putValue("CREDIT", this.debit);
        this.ajoutEcriture();
        return this.idMvt;
    }
}

