/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLField;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class OOXMLElement {
    protected Element elt;
    protected SQLElement sqlElt;
    protected int id;
    protected SQLRowAccessor row;
    protected SQLRow rowLanguage;
    protected OOXMLCache cache;
    public DateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRow rowLanguage, OOXMLCache cache) {
        this(elt, sqlElt, id, null, rowLanguage, cache);
    }

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRowAccessor row, SQLRow rowLanguage, OOXMLCache cache) {
        this.elt = elt;
        this.sqlElt = sqlElt;
        this.id = id;
        this.row = row;
        this.rowLanguage = rowLanguage;
        this.cache = cache;
    }

    public Object getValue() {
        String brk;
        String k;
        boolean rmBreakLines;
        Object res = "";
        String type = this.elt.getAttributeValue("type");
        SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(type);
        if (provider != null) {
            SpreadSheetCellValueContext context = new SpreadSheetCellValueContext(this.row);
            List<Attribute> attrs = this.elt.getAttributes();
            for (Attribute attr : attrs) {
                context.put(attr.getName(), attr.getValue());
            }
            res = provider.getValue(context);
        } else if (type.equalsIgnoreCase("TotalHTTable")) {
            res = this.getTotalHTTable(this.row);
        } else {
            if (type.equalsIgnoreCase("sql.function")) {
                String field = this.elt.getAttributeValue("field");
                String table = this.elt.getAttributeValue("table");
                String function = this.elt.getAttributeValue("function");
                SQLTable referentTable = this.row.getTable().getTable(table);
                return this.getFromSQLFunction(referentTable.getField(field), function);
            }
            if (type.equalsIgnoreCase("DateEcheance")) {
                int idModeReglement = this.row.getInt("ID_MODE_REGLEMENT");
                Date d = (Date)this.row.getObject("DATE");
                res = this.getDateEcheance(idModeReglement, d, this.elt.getAttributeValue("datePattern"));
            } else {
                List<Element> eltFields = this.elt.getChildren("field");
                if (eltFields != null && !eltFields.isEmpty()) {
                    if (eltFields.size() > 1) {
                        String result = "";
                        for (Element eltField : eltFields) {
                            OOXMLField field = new OOXMLField(eltField, this.row, this.sqlElt, this.id, this.rowLanguage, this.cache);
                            Object value = field.getValue();
                            if (value == null) continue;
                            result = String.valueOf(result) + value.toString() + " ";
                        }
                        res = result;
                    } else {
                        OOXMLField field = new OOXMLField(eltFields.get(0), this.row, this.sqlElt, this.id, this.rowLanguage, this.cache);
                        res = field.getValue();
                    }
                }
            }
        }
        ArrayList<String> listOfExcludedValues = null;
        List<Element> excludeValue = this.elt.getChildren("exclude");
        if (excludeValue != null && excludeValue.size() > 0) {
            listOfExcludedValues = new ArrayList<String>();
            for (Element element : excludeValue) {
                String attributeValue = element.getAttributeValue("value");
                listOfExcludedValues.add(attributeValue);
            }
        }
        if (res != null && listOfExcludedValues != null && listOfExcludedValues.contains(res.toString())) {
            res = null;
        }
        boolean bl = rmBreakLines = (k = this.elt.getAttributeValue("removeBreakLine")) == null ? false : k.equalsIgnoreCase("true");
        if (rmBreakLines) {
            Object object = res = res == null ? res : res.toString().replaceAll("\n", ",");
        }
        if ((brk = this.elt.getAttributeValue("replaceWithBreakLine")) != null && brk.trim().length() > 0) {
            res = res == null ? res : res.toString().replaceAll(brk, "\n");
        }
        return res;
    }

    private Object getFromSQLFunction(SQLField field, String function) {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(field, function);
        Where w = new Where((FieldRef)field.getTable().getField("ID_" + this.row.getTable().getName()), "=", this.row.getID());
        sel.setWhere(w);
        return Configuration.getInstance().getBase().getDataSource().executeScalar(sel.asString());
    }

    protected String getStringProposition(SQLRowAccessor rowProp) {
        if (rowProp.getTable().getName().equalsIgnoreCase("AFFAIRE")) {
            SQLRowAccessor nonEmptyForeignProp = rowProp.getNonEmptyForeign("ID_PROPOSITION");
            String result = "";
            if (rowProp.getString("NUMERO_PROPOSITION").trim().length() > 0) {
                return "Notre proposition " + rowProp.getString("NUMERO_PROPOSITION");
            }
            if (nonEmptyForeignProp != null && !nonEmptyForeignProp.isUndefined()) {
                if (result.length() == 0) {
                    result = "Notre proposition " + nonEmptyForeignProp.getString("NUMERO_PROPOSITION");
                }
                result = String.valueOf(result) + " du " + this.format.format(rowProp.getObject("DATE"));
            }
            return result;
        }
        return "Notre proposition " + rowProp.getString("NUMERO") + " du " + this.format.format(rowProp.getObject("DATE"));
    }

    public Double getTotalHTTable(SQLRowAccessor rowFact) {
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection<? extends SQLRowAccessor> set = rowFact.getReferentRows(tableElt);
        long total = 0L;
        for (SQLRowAccessor sQLRowAccessor : set) {
            total += sQLRowAccessor.getLong("T_PV_HT");
        }
        return new Double(GestionDevise.currencyToString(total, false));
    }

    protected Object getDateEcheance(int idModeRegl, Date currentDate, String datePattern) {
        int nJ;
        SQLElement eltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
        SQLRow row = eltModeRegl.getTable().getRow(idModeRegl);
        int aJ = row.getInt("AJOURS");
        if (aJ + (nJ = row.getInt("LENJOUR")) == 0) {
            if (!row.getBoolean("COMPTANT").booleanValue() && row.getBoolean("DATE_FACTURE").booleanValue()) {
                return Configuration.getInstance().getTranslator().getLabelFor(row.getTable().getField("DATE_FACTURE"));
            }
            return " ";
        }
        Date calculDate = ModeDeReglementSQLElement.calculDate(aJ, nJ, currentDate);
        if (datePattern != null && datePattern.trim().length() > 0) {
            SimpleDateFormat format2 = new SimpleDateFormat(datePattern);
            return format2.format(calculDate);
        }
        return calculDate;
    }

    public boolean isTypeReplace() {
        return this.elt.getAttributeValue("type").equalsIgnoreCase("Replace");
    }

    public String getReplacePattern() {
        return this.elt.getAttributeValue("replacePattern");
    }

    public boolean isMultilineAuto() {
        String multiLineValue = this.elt.getAttributeValue("controleMultiline");
        return multiLineValue == null ? true : !multiLineValue.equalsIgnoreCase("false");
    }

    public boolean isKeepingEmptyLines() {
        String k = this.elt.getAttributeValue("keepEmptyLines");
        return k == null ? false : k.equalsIgnoreCase("true");
    }

    public boolean isImage() {
        return this.elt.getAttributeValue("type").equalsIgnoreCase("image");
    }

    public SQLElement getSQLElement() {
        return this.sqlElt;
    }
}

