/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.sales.product.action.InventairePanel;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.FicheArticleXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ListMap;

public class StockSQLElement
extends ComptaSQLConfElement {
    public StockSQLElement() {
        super("STOCK", "un stock", "stocks");
        this.getRowActions().addAll(new MouseSheetXmlListeListener((SQLElement)this, FicheArticleXmlSheet.class).getRowActions());
        RowAction.PredicateRowAction stock = new RowAction.PredicateRowAction((Action)new AbstractAction("Mettre \u00e0 jour les stocks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserRightsManager.getCurrentUserRights().canAdd(StockSQLElement.this.getTable().getDBRoot().getTable("STOCK"))) {
                    PanelFrame p = new PanelFrame(new InventairePanel(IListe.get(e), IListe.get(e).getSelectedRows()), "Mise \u00e0 jour des stocks");
                    FrameUtil.show(p);
                } else {
                    JOptionPane.showMessageDialog(null, "Vous n'avez les droits suffisants pour modifier manuellement les stocks!");
                }
            }
        }, true, false);
        stock.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(stock);
        RowAction.PredicateRowAction cmd = new RowAction.PredicateRowAction((Action)new AbstractAction("Passer une commande"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockSQLElement.this.transfertCommande(IListe.get(e).getSelectedRowAccessors());
            }
        }, true, false);
        cmd.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(cmd);
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("ID_ARTICLE", "QTE_MIN", "QTE_TH", "QTE_REEL", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE", "ID_DEPOT_STOCK");
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        if (this.getTable().contains("ID_ARTICLE")) {
            s.add("ID_ARTICLE");
        }
        s.add("QTE_TH");
        s.add("QTE_REEL");
        s.add("QTE_LIV_ATTENTE");
        s.add("QTE_RECEPT_ATTENTE");
        if (this.getTable().contains("ID_DEPOT_STOCK")) {
            s.add("ID_DEPOT_STOCK");
        }
        return s;
    }

    @Override
    protected List<String> getComboFields() {
        return Arrays.asList("ID_DEPOT_STOCK", "QTE_REEL");
    }

    @Override
    protected String getParentFFName() {
        return "ID_ARTICLE";
    }

    @Override
    public ListMap<String, String> getShowAs() {
        if (this.getTable().contains("ID_DEPOT_STOCK")) {
            return ListMap.singleton(null, new String[]{"QTE_TH", "QTE_REEL", "QTE_MIN", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE", "ID_DEPOT_STOCK"});
        }
        return ListMap.singleton(null, new String[]{"QTE_TH", "QTE_REEL", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE"});
    }

    public static SQLRowAccessor getStockFetched(SQLRowAccessor rowValsSource) {
        SQLRowAccessor rowStock = null;
        int idDepot = rowValsSource.getForeign("ID_DEPOT_STOCK") != null && !rowValsSource.isForeignEmpty("ID_DEPOT_STOCK") ? rowValsSource.getForeignID("ID_DEPOT_STOCK") : rowValsSource.getForeign("ID_ARTICLE").getForeignID("ID_DEPOT_STOCK");
        SQLTable stockTable = rowValsSource.getTable().getTable("STOCK");
        Collection<? extends SQLRowAccessor> rows = rowValsSource.getForeign("ID_ARTICLE").getReferentRows(stockTable);
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.getForeignID("ID_DEPOT_STOCK") != idDepot) continue;
            rowStock = sQLRowAccessor;
            break;
        }
        return rowStock;
    }

    public static SQLRowAccessor getStock(SQLRowAccessor rowValsSource) throws SQLException {
        int idDepot;
        SQLRowAccessor rowStock = null;
        if (rowValsSource.getForeign("ID_DEPOT_STOCK") != null && !rowValsSource.isForeignEmpty("ID_DEPOT_STOCK")) {
            idDepot = rowValsSource.getForeignID("ID_DEPOT_STOCK");
        } else {
            SQLRowAccessor rowValsArt = rowValsSource.getForeign("ID_ARTICLE");
            if (rowValsArt.getObject("ID_DEPOT_STOCK") == null) {
                rowValsArt = rowValsArt.asRow();
                ((SQLRow)rowValsArt).fetchValues();
                System.err.println("REFETCH ARTICLE");
                Thread.dumpStack();
            }
            idDepot = rowValsArt.getForeignID("ID_DEPOT_STOCK");
        }
        int idArticle = rowValsSource.getForeignID("ID_ARTICLE");
        DBRoot root = rowValsSource.getTable().getDBRoot();
        SQLTable stockTable = root.getTable("STOCK");
        SQLRowValues putRowValuesStock = new SQLRowValues(stockTable);
        putRowValuesStock.putNulls(stockTable.getTable().getFieldsName());
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(putRowValuesStock);
        Where w = new Where((FieldRef)stockTable.getField("ID_DEPOT_STOCK"), "=", idDepot);
        Where w2 = new Where((FieldRef)stockTable.getField("ID_ARTICLE"), "=", idArticle);
        List<SQLRowValues> rowValsResult = fetch.fetch(w.and(w2));
        if (rowValsResult.isEmpty()) {
            SQLRowValues rowValsStock = new SQLRowValues(stockTable);
            rowValsStock.put("ID_ARTICLE", idArticle);
            rowValsStock.put("ID_DEPOT_STOCK", idDepot);
            rowValsStock.put("QTE_TH", Float.valueOf(0.0f));
            rowValsStock.put("QTE_REEL", Float.valueOf(0.0f));
            rowValsStock.put("QTE_RECEPT_ATTENTE", Float.valueOf(0.0f));
            rowValsStock.put("QTE_LIV_ATTENTE", Float.valueOf(0.0f));
            rowStock = rowValsStock.insert();
            if (idDepot == DepotStockSQLElement.DEFAULT_ID) {
                rowValsSource.getForeign("ID_ARTICLE").createEmptyUpdateRow().put("ID_STOCK", rowStock.getID()).commit();
            }
        } else if (rowValsResult.size() == 1) {
            rowStock = (SQLRowAccessor)rowValsResult.iterator().next();
        } else if (rowValsResult.size() > 1) {
            throw new IllegalStateException("2 lignes de stocks pour le m\u00eame d\u00e9p\u00f4t! Article " + rowValsSource.getForeign("ID_ARTICLE").getID() + " Depot " + idDepot);
        }
        return rowStock;
    }

    public SQLRow getStock(int idDepot, int idArticle, boolean createIfMissing) throws SQLException {
        SQLRow result;
        SQLTable stockTable = this.getTable();
        SQLRowValues putRowValuesStock = new SQLRowValues(stockTable);
        putRowValuesStock.putNulls(stockTable.getFieldsName());
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(putRowValuesStock);
        Where w = new Where((FieldRef)stockTable.getField("ID_DEPOT_STOCK"), "=", idDepot);
        Where w2 = new Where((FieldRef)stockTable.getField("ID_ARTICLE"), "=", idArticle);
        List<SQLRowValues> rowValsResult = fetch.fetch(w.and(w2));
        if (rowValsResult.isEmpty()) {
            if (!createIfMissing) {
                return null;
            }
            SQLRowValues rowValsStock = new SQLRowValues(stockTable);
            rowValsStock.put("ID_ARTICLE", idArticle);
            rowValsStock.put("ID_DEPOT_STOCK", idDepot);
            rowValsStock.put("QTE_TH", Float.valueOf(0.0f));
            rowValsStock.put("QTE_REEL", Float.valueOf(0.0f));
            rowValsStock.put("QTE_RECEPT_ATTENTE", Float.valueOf(0.0f));
            rowValsStock.put("QTE_LIV_ATTENTE", Float.valueOf(0.0f));
            result = rowValsStock.insert();
        } else if (rowValsResult.size() == 1) {
            result = ((SQLRowValues)rowValsResult.iterator().next()).asRow();
        } else {
            throw new IllegalStateException("2 lignes de stocks pour le m\u00eame d\u00e9p\u00f4t! Article " + idArticle + " Depot " + idDepot);
        }
        return result;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelA = new JLabel(this.getLabelFor("ID_ARTICLE"));
                c.weightx = 0.0;
                this.add((Component)labelA, c);
                ++c.gridx;
                ElementComboBox boxA = new ElementComboBox();
                this.add((Component)boxA, c);
                JLabel labelD = new JLabel(this.getLabelFor("ID_DEPOT_STOCK"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelD, c);
                ++c.gridx;
                ElementComboBox boxD = new ElementComboBox();
                this.add((Component)boxD, c);
                JLabel labelQteR = new JLabel(this.getLabelFor("QTE_REEL"));
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelQteR, c);
                ++c.gridx;
                JTextField textQteReel = new JTextField(6);
                this.add((Component)textQteReel, c);
                JLabel labelQteT = new JLabel(this.getLabelFor("QTE_TH"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelQteT, c);
                ++c.gridx;
                JTextField textQteT = new JTextField(6);
                this.add((Component)textQteT, c);
                JLabel labelQteRe = new JLabel(this.getLabelFor("QTE_RECEPT_ATTENTE"));
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelQteRe, c);
                ++c.gridx;
                JTextField textQteRe = new JTextField(6);
                this.add((Component)textQteRe, c);
                JLabel labelQteL = new JLabel(this.getLabelFor("QTE_LIV_ATTENTE"));
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelQteL, c);
                ++c.gridx;
                JTextField textQteL = new JTextField(6);
                this.add((Component)textQteL, c);
                JLabel labelQteTMin = new JLabel(this.getLabelFor("QTE_MIN"));
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                this.add((Component)labelQteTMin, c);
                ++c.gridx;
                JTextField textQteMin = new JTextField(6);
                this.add((Component)textQteMin, c);
                this.addSQLObject(textQteReel, "QTE_REEL");
                this.addSQLObject(textQteT, "QTE_TH");
                this.addSQLObject(textQteMin, "QTE_MIN");
                this.addSQLObject(textQteL, "QTE_LIV_ATTENTE");
                this.addSQLObject(textQteRe, "QTE_RECEPT_ATTENTE");
                this.addSQLObject(boxA, "ID_ARTICLE");
                this.addSQLObject(boxD, "ID_DEPOT_STOCK");
            }
        };
    }

    public void transfertCommande(final List<SQLRowAccessor> rows) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLTable tableCmdElt = StockSQLElement.this.getDirectory().getElement("COMMANDE_ELEMENT").getTable();
                SQLElement eltArticle = StockSQLElement.this.getDirectory().getElement("ARTICLE");
                ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
                for (SQLRowAccessor sqlRow : rows) {
                    SQLRowAccessor rowArticleFind = sqlRow.getForeign("ID_ARTICLE");
                    int qte = 1;
                    BigDecimal qteUV = BigDecimal.ONE;
                    qte = -Math.round(sqlRow.getFloat("QTE_TH") - sqlRow.getFloat("QTE_MIN"));
                    SQLInjector inj = SQLInjector.getInjector(eltArticle.getTable(), tableCmdElt);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind.asRow()));
                    rowValsElt.put("ID_DEPOT_STOCK", sqlRow.getForeignID("ID_DEPOT_STOCK"));
                    rowValsElt.put("QTE", qte);
                    rowValsElt.put("QTE_UNITAIRE", qteUV);
                    rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
                    rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE")), DecimalUtils.HIGH_PRECISION));
                    rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
                    map.add(rowArticleFind.asRow().getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                }
                MouvementStockSQLElement.createCommandeF(map, null, "");
            }
        });
    }

    @Override
    protected String createCode() {
        return "supplychain.stock";
    }
}

