/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.sales.invoice.report.EtatStockInventaireXmlSheet;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockCreationPanel;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockGroup;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockTable;
import org.openconcerto.erp.core.supplychain.stock.element.ImportInventairePanel;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.ExceptionHandler;

public class EtatStockSQLElement
extends ComptaSQLConfElement {
    public EtatStockSQLElement() {
        super("ETAT_STOCK");
        this.setDefaultGroup(new EtatStockGroup());
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er un \u00e9tat de stock"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new EtatStockCreationPanel(EtatStockSQLElement.this.getDirectory().getElement(DepotStockSQLElement.class)), "Cr\u00e9ation \u00e9tat de stock");
                FrameUtil.showPacked(frame);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Voir les articles"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement element = EtatStockSQLElement.this.getDirectory().getElement("ETAT_STOCK_ELEMENT");
                SQLTableModelSourceOnline source = element.createTableSource(new Where((FieldRef)element.getTable().getField("ID_ETAT_STOCK"), "=", IListe.get(e).getSelectedId()));
                ListeViewPanel panel = new ListeViewPanel(element, new IListe(source));
                IListFrame frame = new IListFrame(panel);
                FrameUtil.show(frame);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Export pour inventaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtatStockInventaireXmlSheet sheet = new EtatStockInventaireXmlSheet(IListe.get(e).getSelectedRow().asRow());
                try {
                    sheet.createDocument();
                    sheet.showPrintAndExport(true, false, false, false, false, Collections.emptyList());
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de l'inventaire", e1);
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Import Inventaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new ImportInventairePanel(EtatStockSQLElement.this.getDirectory().getElement(DepotStockSQLElement.class)), "Import inventaire");
                FrameUtil.showPacked(frame);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(3);
        l.add("DATE");
        l.add("MONTANT_HA");
        l.add("INVENTAIRE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("DATE");
        l.add("MONTANT_HA");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new GroupSQLComponent(this){

            @Override
            public JComponent createEditor(String id) {
                if (id.equals("supplychain.stock.state.items")) {
                    return new EtatStockTable((JTextField)this.getEditor("MONTANT_HA"));
                }
                return super.createEditor(id);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                EtatStockTable table = (EtatStockTable)this.getEditor("supplychain.stock.state.items");
                if (r != null) {
                    table.insertFrom("ID_ETAT_STOCK", r.getID());
                }
            }

            @Override
            public void update() {
                super.update();
                EtatStockTable table = (EtatStockTable)this.getEditor("supplychain.stock.state.items");
                table.updateField("ID_ETAT_STOCK", this.getSelectedID());
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".state";
    }
}

