/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class StringCodec {
    private static final int MAX_BYTE = 255;
    private static final Pattern OCTAL_PATTERN = Pattern.compile("\\\\[0-3][0-7]{2}");
    private static final CharsetDecoder isoDec = Charset.forName("iso8859-1").newDecoder();
    private static final CharsetDecoder asciiDec = Charset.forName("IBM00858").newDecoder();

    public static final byte octal2byte(String s) {
        int s2 = Short.parseShort(s, 8);
        if (s2 < 0 || s2 > 255) {
            throw new IllegalArgumentException(String.valueOf(s) + " out of bounds");
        }
        return (byte)(s2 > 127 ? s2 - 255 - 1 : s2);
    }

    public static boolean isEncoded(String octalEscaped) {
        return OCTAL_PATTERN.matcher(octalEscaped).find();
    }

    public static String decode(String octalEscaped) throws CharacterCodingException {
        return StringCodec.decode(octalEscaped, null, new ITransformer<String, CharSequence>(){

            @Override
            public CharSequence transformChecked(String octal) {
                byte b = StringCodec.octal2byte(octal);
                try {
                    if (b < -90) {
                        return asciiDec.decode(ByteBuffer.wrap(new byte[]{b}));
                    }
                    return isoDec.decode(ByteBuffer.wrap(new byte[]{b}));
                }
                catch (CharacterCodingException e) {
                    throw ExceptionUtils.createExn(IllegalArgumentException.class, "", e);
                }
            }
        });
    }

    public static String encodedToBash(String octalEscaped) {
        return StringCodec.decode(octalEscaped, new ITransformer<String, String>(){

            @Override
            public String transformChecked(String input) {
                return StringCodec.quote(input);
            }
        }, new ITransformer<String, CharSequence>(){

            @Override
            public String transformChecked(String octal) {
                return "$'\\" + octal + "'";
            }
        });
    }

    private static String decode(String octalEscaped, ITransformer<String, String> notOctal, ITransformer<String, CharSequence> octal) {
        if (notOctal == null) {
            notOctal = new ITransformer<String, String>(){

                @Override
                public String transformChecked(String input) {
                    return input;
                }
            };
        }
        StringBuffer res = new StringBuffer(octalEscaped.length());
        octalEscaped = StringCodec.onlyInvalidChars(octalEscaped);
        int lastEnd = 0;
        Matcher m = OCTAL_PATTERN.matcher(octalEscaped);
        while (m.find()) {
            String octalS = m.group().substring(1);
            res.append((String)notOctal.transformChecked(octalEscaped.substring(lastEnd, m.start())));
            res.append(octal.transformChecked(octalS));
            lastEnd = m.end();
        }
        res.append((String)notOctal.transformChecked(octalEscaped.substring(lastEnd, octalEscaped.length())));
        return res.toString();
    }

    private static String onlyInvalidChars(String octalEscaped) {
        return octalEscaped.replace("\\ ", " ").replace("\\\\", "\\");
    }

    public static String quote(String s) {
        return "'" + s.replace("'", "'\\''") + "'";
    }
}

