/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ArticleCodeFournisseurProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        String code = row.getString("CODE");
        if (row.getObject("ID_ARTICLE") != null && !row.isForeignEmpty("ID_ARTICLE") && row.getTable().contains("ID_CODE_FOURNISSEUR")) {
            if (row.getObject("ID_CODE_FOURNISSEUR") != null && !row.isForeignEmpty("ID_CODE_FOURNISSEUR")) {
                code = row.getForeign("ID_CODE_FOURNISSEUR").getString("CODE");
            } else {
                String val;
                int idFournisseur = row.getForeign("ID_" + row.getTable().getName().replaceAll("_ELEMENT", "")).getForeignID("ID_FOURNISSEUR");
                SQLSelect sel = new SQLSelect();
                SQLTable tableCodeFournisseur = row.getTable().getTable("CODE_FOURNISSEUR");
                sel.addSelectStar(tableCodeFournisseur);
                Where w = new Where((FieldRef)tableCodeFournisseur.getField("ID_ARTICLE"), "=", row.getForeignID("ID_ARTICLE"));
                w = w.and(new Where((FieldRef)tableCodeFournisseur.getField("ID_FOURNISSEUR"), "=", idFournisseur));
                sel.setWhere(w);
                List<SQLRow> result = SQLRowListRSH.execute(sel);
                if (!result.isEmpty() && (val = result.get(0).getString("CODE")).length() > 0) {
                    code = val;
                }
            }
        }
        return code;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplier.product.code", new ArticleCodeFournisseurProvider());
    }
}

