/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeCellRenderer;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeClient;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeClientComboBox;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeRowItemView;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public class FacturationCommandeClientSQLElement
extends ComptaSQLConfElement {
    public static final String TABLENAME = "FACTURATION_COMMANDE_CLIENT";

    public FacturationCommandeClientSQLElement() {
        super(TABLENAME, "un terme de facturation de commande client", "termes de facturation commandes clients");
        RowAction action = new RowAction(new AbstractAction("Facturer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowValues;
                EditFrame f;
                final SQLRow sel = IListe.get(e).getSelectedRow().asRow();
                sel.fetchValues();
                CommandeClientSQLElement eltCmd = (CommandeClientSQLElement)FacturationCommandeClientSQLElement.this.getForeignElement("ID_COMMANDE_CLIENT");
                int typeFacture = sel.getInt("TYPE_FACTURE");
                SQLRow asRow = sel.getForeign("ID_COMMANDE_CLIENT").asRow();
                asRow.fetchValues();
                List<SQLRowValues> l = Arrays.asList(asRow.asRowValues());
                if (typeFacture == TypeFactureCommandeClient.SITUATION.getId()) {
                    f = eltCmd.transfertAcompteClient(l);
                    rowValues = new SQLRowValues(FacturationCommandeClientSQLElement.this.getForeignElement("ID_SAISIE_VENTE_FACTURE").getTable());
                    rowValues.put("POURCENT_FACTURABLE", sel.getObject("POURCENT"));
                    rowValues.put("MONTANT_FACTURABLE", null);
                    ((BaseSQLComponent)f.getSQLComponent()).getView("MONTANT_FACTURABLE,POURCENT_FACTURABLE").show(rowValues);
                } else {
                    f = typeFacture == TypeFactureCommandeClient.SOLDE.getId() ? eltCmd.transfertSoldeClient(l) : eltCmd.transfertFactureClient(l);
                }
                rowValues = new SQLRowValues(eltCmd.getTable().getTable("MODE_REGLEMENT").getTable());
                rowValues.put("ID_TYPE_REGLEMENT", sel.getForeignID("ID_TYPE_REGLEMENT"));
                rowValues.put("FIN_MOIS", Boolean.FALSE);
                if (sel.getBoolean("COMPTANT").booleanValue()) {
                    rowValues.put("AJOURS", 0);
                    rowValues.put("LENJOUR", 0);
                    rowValues.put("DATE_FACTURE", Boolean.TRUE);
                    rowValues.put("COMPTANT", Boolean.TRUE);
                } else {
                    rowValues.put("AJOURS", sel.getObject("AJOURS"));
                    int lenjour = sel.getInt("LENJOUR");
                    if (sel.getBoolean("FIN_MOIS").booleanValue()) {
                        lenjour = 31;
                    }
                    rowValues.put("LENJOUR", lenjour);
                    rowValues.put("COMPTANT", Boolean.FALSE);
                    rowValues.put("FIN_MOIS", lenjour == 31);
                    rowValues.put("DATE_FACTURE", lenjour == 0);
                }
                ((BaseSQLComponent)f.getSQLComponent()).getView("ID_MODE_REGLEMENT").show(rowValues);
                f.addEditPanelListener(new EditPanelListener(){

                    @Override
                    public void modified() {
                    }

                    @Override
                    public void inserted(int id) {
                        try {
                            sel.createEmptyUpdateRow().put("ID_SAISIE_VENTE_FACTURE", id).commit();
                            SQLTable tableFacture = FacturationCommandeClientSQLElement.this.getForeignElement("ID_SAISIE_VENTE_FACTURE").getTable();
                            SQLRowValues rowValsFact = new SQLRowValues(tableFacture);
                            rowValsFact.put(tableFacture.getKey().getName(), id);
                            rowValsFact.put("ID_FACTURATION_COMMANDE_CLIENT", sel.getID());
                            rowValsFact.commit();
                        }
                        catch (SQLException e) {
                            ExceptionHandler.handle("Erreur lors de l'affectation de la facture", e);
                        }
                    }

                    @Override
                    public void deleted() {
                    }

                    @Override
                    public void cancelled() {
                    }
                });
            }
        }, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() == 1) {
                    SQLRowAccessor sel = selection.get(0);
                    return sel.isForeignEmpty("ID_SAISIE_VENTE_FACTURE");
                }
                return false;
            }
        };
        this.getRowActions().add(action);
        action = new RowAction(new AbstractAction("Voir la facture"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues sel = IListe.get(e).getSelectedRow();
                SQLRowAccessor fact = ((SQLRowAccessor)sel).getForeign("ID_SAISIE_VENTE_FACTURE");
                VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(fact.asRow());
                try {
                    sheet.showPreviewDocument();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() == 1) {
                    SQLRowAccessor sel = selection.get(0);
                    return !sel.isForeignEmpty("ID_SAISIE_VENTE_FACTURE");
                }
                return false;
            }
        };
        this.getRowActions().add(action);
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("NOM");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("CHOICE");
        return s;
    }

    @Override
    protected String getParentFFName() {
        return "ID_COMMANDE_CLIENT";
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(7);
        l.add("NOM");
        l.add("TYPE_FACTURE");
        l.add("ID_TYPE_REGLEMENT");
        l.add("POURCENT");
        l.add("DATE_PREVISIONNELLE");
        l.add("ID_COMMANDE_CLIENT");
        l.add("ID_SAISIE_VENTE_FACTURE");
        return l;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        res.init();
        res.getColumn(this.getTable().getField("POURCENT")).setRenderer(new DeviseTableCellRenderer());
        res.getColumn(this.getTable().getField("TYPE_FACTURE")).setRenderer(new TypeFactureCommandeCellRenderer());
        BaseSQLTableModelColumn pourcentFact = new BaseSQLTableModelColumn("Montant \u00e0 facturer", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                long ht = r.getForeign("ID_COMMANDE_CLIENT").getLong("T_TTC");
                BigDecimal percent = r.getBigDecimal("POURCENT");
                return percent.movePointLeft(2).multiply(new BigDecimal(ht).movePointLeft(2), DecimalUtils.HIGH_PRECISION);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(FacturationCommandeClientSQLElement.this.getTable());
                Path p2 = (Path)p.add(p.getFirst().getField("ID_COMMANDE_CLIENT"));
                return CollectionUtils.createSet(new FieldPath(p, "POURCENT"), new FieldPath(p2, "T_TTC"));
            }
        };
        pourcentFact.setRenderer(new DeviseTableCellRenderer());
        res.getColumns().add(pourcentFact);
        BaseSQLTableModelColumn montantFact = new BaseSQLTableModelColumn("Montant factur\u00e9", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                Collection<? extends SQLRowAccessor> rows = r.getReferentRows(FacturationCommandeClientSQLElement.this.getForeignElement("ID_SAISIE_VENTE_FACTURE").getTable());
                long ht = 0L;
                for (SQLRowAccessor sQLRowAccessor : rows) {
                    ht += sQLRowAccessor.getLong("T_TTC");
                }
                return new BigDecimal(ht).movePointLeft(2);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(FacturationCommandeClientSQLElement.this.getTable());
                Path p2 = (Path)p.add(p.getFirst().getField("ID_COMMANDE_CLIENT"));
                Path p3 = new Path(FacturationCommandeClientSQLElement.this.getTable());
                p3 = (Path)p3.add(FacturationCommandeClientSQLElement.this.getTable().getForeignTable("ID_SAISIE_VENTE_FACTURE").getField("ID_FACTURATION_COMMANDE_CLIENT"));
                return CollectionUtils.createSet(new FieldPath(p, "POURCENT"), new FieldPath(p2, "T_TTC"), new FieldPath(p3, "T_TTC"), new FieldPath(p2, "T_HT"), new FieldPath(p3, "T_HT"));
            }
        };
        montantFact.setRenderer(new DeviseTableCellRenderer());
        res.getColumns().add(montantFact);
        super._initTableSource(res);
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addView("NOM");
                this.addView("POURCENT");
                this.addView("ID_TYPE_REGLEMENT");
                this.addView("AJOURS");
                this.addView("COMPTANT");
                this.addView("CHOICE");
                TypeFactureCommandeClientComboBox box = new TypeFactureCommandeClientComboBox();
                this.addView(new TypeFactureCommandeRowItemView(box), "TYPE_FACTURE", (Object)"required");
                this.addView("ID_MODELE");
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("CHOICE", Boolean.TRUE);
                return rowVals;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".facturation";
    }
}

