/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IPredicate;

public class ListEvent {
    private static final IPredicate<ListEvent> emptyTotalRowCountPredicate = ListEvent.createTotalRowCountPredicate(0, 0);
    private static final IPredicate<ListEvent> singleSelectionPredicate = ListEvent.createSelectionCountPredicate(1, 1);
    private static final IPredicate<ListEvent> nonEmptySelectionPredicate = ListEvent.createNonEmptySelectionPredicate(Integer.MAX_VALUE);
    private final Object source;
    private final SQLElement elem;
    private final int totalRowCount;
    private final List<SQLRowValues> selection;
    private final List<? extends SQLRowAccessor> selectionAccessor;

    public static final IPredicate<ListEvent> getEmptyListPredicate() {
        return emptyTotalRowCountPredicate;
    }

    public static final IPredicate<ListEvent> createTotalRowCountPredicate(final int min, final int max) {
        return new IPredicate<ListEvent>(){

            @Override
            public boolean evaluateChecked(ListEvent e) {
                return e.getTotalRowCount() >= min && e.getTotalRowCount() <= max;
            }
        };
    }

    public static final IPredicate<ListEvent> getSingleSelectionPredicate() {
        return singleSelectionPredicate;
    }

    public static final IPredicate<ListEvent> getNonEmptySelectionPredicate() {
        return nonEmptySelectionPredicate;
    }

    public static final IPredicate<ListEvent> createNonEmptySelectionPredicate(int max) {
        return ListEvent.createSelectionCountPredicate(1, max);
    }

    public static final IPredicate<ListEvent> createSelectionCountPredicate(final int min, final int max) {
        return new IPredicate<ListEvent>(){

            @Override
            public boolean evaluateChecked(ListEvent e) {
                List<? extends SQLRowAccessor> selectedIDs = e.getSelectedRowAccessors();
                return selectedIDs.size() >= min && selectedIDs.size() <= max;
            }
        };
    }

    public static final ListEvent createFromRowValues(Object source, SQLElement elem, int totalRowCount, List<SQLRowValues> selection) {
        return new ListEvent(source, elem, totalRowCount, selection, selection);
    }

    public static final ListEvent createFromRowAccessors(Object source, SQLElement elem, int totalRowCount, List<? extends SQLRowAccessor> selection) {
        return new ListEvent(source, elem, totalRowCount, null, selection);
    }

    protected ListEvent(Object source, SQLElement elem, int totalRowCount, List<SQLRowValues> selection, List<? extends SQLRowAccessor> selectionAccessor) {
        this.source = source;
        this.elem = elem;
        this.totalRowCount = totalRowCount;
        assert (selection == null || selection == selectionAccessor) : "Wasting memory";
        this.selection = selection;
        this.selectionAccessor = Objects.requireNonNull(selectionAccessor);
    }

    public final Object getSource() {
        return this.source;
    }

    public final SQLRowAccessor getSelectedRow() {
        return CollectionUtils.getFirst(this.getSelectedRowAccessors());
    }

    public final List<SQLRowValues> getSelectedRows() {
        if (this.selection == null) {
            throw new IllegalStateException("SQLRowValues unavailable, use getSelectedRowAccessors()");
        }
        return this.selection;
    }

    public final List<? extends SQLRowAccessor> getSelectedRowAccessors() {
        return this.selectionAccessor;
    }

    public final List<Number> getSelectedIDs() {
        return SQLRowAccessor.getIDs(this.getSelectedRowAccessors(), new ArrayList());
    }

    public final int getTotalRowCount() {
        return this.totalRowCount;
    }

    public final SQLTable getTable() {
        return this.getElement().getTable();
    }

    public final SQLElement getElement() {
        return this.elem;
    }
}

