/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.utils.FileUtils;

public class AttachmentPreferencePanel
extends DefaultPreferencePanel {
    private JTextField textTemplate;
    private JFileChooser fileChooser = null;

    public AttachmentPreferencePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        cPanel.weighty = 0.0;
        cPanel.anchor = 17;
        this.add((Component)new JLabel("Destination des documents GED"), cPanel);
        ++cPanel.gridx;
        cPanel.weightx = 1.0;
        this.textTemplate = new JTextField();
        this.add((Component)this.textTemplate, cPanel);
        JButton buttonTemplate = new JButton("...");
        ++cPanel.gridx;
        cPanel.weightx = 0.0;
        cPanel.fill = 0;
        this.add((Component)buttonTemplate, cPanel);
        buttonTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentPreferencePanel.this.directoryChoose();
            }
        });
        this.setValues();
    }

    @Override
    public void storeValues() {
        File z = new File(".");
        File f = new File(this.textTemplate.getText());
        try {
            TemplateNXProps.getInstance().setProperty("EDMdirectory", FileUtils.relative(z, f));
            DocumentLocalStorageManager.getInstance().addDocumentDirectory("EDMdirectory", new File(FileUtils.relative(z, f)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TemplateNXProps.getInstance().store();
    }

    @Override
    public void restoreToDefaults() {
    }

    @Override
    public String getTitleName() {
        return "Emplacement des mod\u00e8les";
    }

    private void setValues() {
        try {
            File f = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
            if (f.exists()) {
                this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
            } else {
                this.textTemplate.setForeground(Color.RED);
            }
            this.textTemplate.setText(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void directoryChoose() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }
        this.fileChooser.setCurrentDirectory(new File(this.textTemplate.getText()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AttachmentPreferencePanel.this.fileChooser.showDialog(AttachmentPreferencePanel.this, "S\u00e9lectionner") == 0) {
                    File selectedFile = AttachmentPreferencePanel.this.fileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        AttachmentPreferencePanel.this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
                    } else {
                        AttachmentPreferencePanel.this.textTemplate.setForeground(Color.RED);
                    }
                    AttachmentPreferencePanel.this.textTemplate.setText(selectedFile.getPath());
                }
            }
        });
    }
}

