/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentSQLElement;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.sync.SyncClient;

public class AttachmentUtils {
    String generateBase64Key() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        SecretKey k = generator.generateKey();
        return Base64.encodeBytes(k.getEncoded(), 8);
    }

    SecretKey getSecretKey(String base64key) {
        byte[] b = Base64.decode(base64key.getBytes(StandardCharsets.UTF_8));
        if (b.length != 16) {
            throw new IllegalStateException("key length must be 16 bytes for AES");
        }
        return new SecretKeySpec(b, "AES");
    }

    public byte[] encrypt(SecretKey secretKey, byte[] in) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return this.process(secretKey, in, 1);
    }

    public byte[] decrypt(SecretKey secretKey, byte[] in) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return this.process(secretKey, in, 2);
    }

    public byte[] process(SecretKey secretKey, byte[] in, int mode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] nonce = new byte[12];
        byte[] e = secretKey.getEncoded();
        int i = 0;
        while (i < nonce.length) {
            nonce[i] = (byte)(e[i] * e[i + 1] + e[i + 2]);
            ++i;
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        cipher.init(mode, (Key)secretKey, spec);
        return cipher.doFinal(in);
    }

    public void uploadFile(File inFile, SQLRowAccessor rowSource, int idParent) throws SQLException {
        this.uploadFile(inFile, rowSource, idParent, null);
    }

    public void uploadFile(File inFile, SQLRowAccessor rowSource, int idParent, String nameInGed) throws SQLException {
        String encodeKey = this.fetchEncodedKey(rowSource.getTable().getTable("FWK_SCHEMA_METADATA"));
        SQLRowValues rowValsAttachment = new SQLRowValues(rowSource.getTable().getTable("ATTACHMENT"));
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("ID_PARENT", idParent);
        if (encodeKey != null) {
            rowValsAttachment.put("ENCRYPTED", true);
        }
        SQLRow rowAttachment = rowValsAttachment.insert();
        int id = rowAttachment.getID();
        String folderId = String.valueOf(id / 1000 * 1000);
        String subDir = "EDM/" + folderId;
        String fileNameID = String.valueOf(id);
        String ext = "";
        int i = inFile.getName().lastIndexOf(46);
        if (i > 0) {
            ext = inFile.getName().substring(i + 1);
        }
        String fileWithIDNAme = String.valueOf(fileNameID) + "." + ext;
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        boolean isOnCloud = config.isOnCloud();
        try {
            File encodedFile;
            if (isOnCloud) {
                String remotePath = subDir;
                List<StorageEngine> engines = StorageEngines.getInstance().getActiveEngines();
                encodedFile = inFile;
                if (encodeKey != null) {
                    encodedFile = File.createTempFile("encrypted", inFile.getName());
                    byte[] enc = this.encrypt(this.getSecretKey(encodeKey), FileUtils.readBytes(inFile));
                    Files.write(encodedFile.toPath(), enc, new OpenOption[0]);
                }
                for (StorageEngine storageEngine : engines) {
                    if (!storageEngine.isConfigured() || !storageEngine.allowAutoStorage()) continue;
                    String path = remotePath;
                    Throwable throwable = null;
                    Object var24_29 = null;
                    try (FileInputStream in = new FileInputStream(encodedFile);){
                        storageEngine.connect();
                        BufferedInputStream inStream = new BufferedInputStream(in);
                        storageEngine.store(inStream, path, fileWithIDNAme, true);
                        inStream.close();
                        storageEngine.disconnect();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (encodeKey != null) {
                    encodedFile.delete();
                }
            } else {
                File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
                File storagePathFile = new File(dirRoot, subDir);
                storagePathFile.mkdirs();
                if (encodeKey == null) {
                    FileUtils.copyFile(inFile, new File(storagePathFile, fileWithIDNAme));
                } else {
                    encodedFile = new File(storagePathFile, fileWithIDNAme);
                    byte[] enc = this.encrypt(this.getSecretKey(encodeKey), FileUtils.readBytes(inFile));
                    Files.write(encodedFile.toPath(), enc, new OpenOption[0]);
                }
            }
            rowValsAttachment = rowAttachment.createEmptyUpdateRow();
            String fileName = inFile.getName();
            if (nameInGed != null) {
                rowValsAttachment.put("NAME", nameInGed);
            } else {
                String name = fileName;
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
                rowValsAttachment.put("NAME", name);
            }
            rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
            rowValsAttachment.put("SOURCE_ID", rowSource.getID());
            rowValsAttachment.put("ID_PARENT", idParent);
            String mimeType = Files.probeContentType(inFile.toPath());
            rowValsAttachment.put("MIMETYPE", mimeType != null ? mimeType : "application/octet-stream");
            rowValsAttachment.put("FILENAME", fileName);
            rowValsAttachment.put("FILESIZE", inFile.length());
            rowValsAttachment.put("STORAGE_PATH", subDir);
            rowValsAttachment.put("STORAGE_FILENAME", fileWithIDNAme);
            rowValsAttachment.put("ENCRYPTED", encodeKey != null);
            rowValsAttachment.commit();
            Attachment a = new Attachment(rowValsAttachment);
            this.updateAttachmentsCountFromAttachment(a);
        }
        catch (Exception e) {
            if (rowAttachment != null) {
                config.getDirectory().getElement(AttachmentSQLElement.class).archive(rowAttachment.getID());
            }
            ExceptionHandler.handle("Impossible de sauvegarder le fichier " + inFile.getAbsolutePath(), e);
        }
    }

    public String fetchEncodedKey(SQLTable table) {
        SQLSelect select = new SQLSelect();
        select.addSelect(table.getField("VALUE"));
        select.setWhere(new Where((FieldRef)table.getField("NAME"), "=", (Object)"EDM_KEY"));
        List rows = table.getDBSystemRoot().getDataSource().executeCol(select.asString());
        if (rows.size() == 1) {
            return rows.get(0).toString();
        }
        return null;
    }

    public void createKeyOnDatabase(SQLTable table) throws NoSuchAlgorithmException {
        String s = this.fetchEncodedKey(table);
        if (s != null) {
            throw new IllegalStateException("key alread exists");
        }
        SQLInsert insert = new SQLInsert();
        insert.add(table.getField("NAME"), "EDM_KEY");
        insert.add(table.getField("VALUE"), this.generateBase64Key());
        table.getDBSystemRoot().getDataSource().execute(insert.asString());
    }

    public void createURL(String url, SQLRowAccessor rowSource, int idParent) throws SQLException {
        SQLRowValues rowValsAttachment = new SQLRowValues(rowSource.getTable().getTable("ATTACHMENT"));
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("ID_PARENT", idParent);
        rowValsAttachment.put("NAME", url);
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("MIMETYPE", "application/url-mime-type");
        rowValsAttachment.put("FILENAME", url);
        rowValsAttachment.put("FILESIZE", 0);
        rowValsAttachment.put("STORAGE_PATH", "");
        rowValsAttachment.put("STORAGE_FILENAME", "");
        rowValsAttachment.commit();
    }

    public File getFile(Attachment attachment) {
        File f;
        String fileName;
        ComptaPropsConfiguration config;
        block17: {
            File fileIn;
            block16: {
                File fTemp;
                config = ComptaPropsConfiguration.getInstanceCompta();
                boolean isOnCloud = config.isOnCloud();
                String subDir = attachment.getStoragePath();
                fileName = attachment.getStorageFileName();
                String remotePath = String.valueOf(config.getSocieteID()) + File.separator + subDir;
                try {
                    fTemp = File.createTempFile("edm_", "oc");
                }
                catch (IOException e) {
                    ExceptionHandler.handle("Impossible de cr\u00e9er le fichier temporaire de r\u00e9ception", e);
                    return null;
                }
                f = new File(fTemp.getParent(), String.valueOf(fTemp.getName()) + "-dir");
                f.mkdirs();
                fTemp.delete();
                if (isOnCloud) {
                    remotePath = remotePath.replace('\\', '/');
                    SyncClient client = new SyncClient("https://" + config.getStorageServer());
                    client.setVerifyHost(false);
                    try {
                        client.retrieveFile(f, remotePath, fileName, config.getToken());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible de r\u00e9cup\u00e9rer le fichier depuis le cloud", e);
                        return null;
                    }
                }
                File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
                File storagePathFile = new File(dirRoot, subDir);
                try {
                    fileIn = new File(storagePathFile, fileName).getCanonicalFile();
                    if (!fileIn.exists()) break block16;
                    File outFile = new File(f, fileName);
                    try {
                        FileUtils.copyFile(fileIn, outFile);
                        break block17;
                    }
                    catch (IOException e) {
                        ExceptionHandler.handle("Impossible de copier le fichier vers le fichier temporaire de r\u00e9ception", e);
                        return null;
                    }
                }
                catch (IOException e1) {
                    ExceptionHandler.handle("Impossible de trouver le fichier\n" + storagePathFile + File.pathSeparator + fileName, e1);
                    return null;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                JOptionPane.showMessageDialog(null, "Le fichier n'existe pas sur le serveur!\n" + fileIn.getAbsolutePath(), "Erreur fichier", 0);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le fichier n'existe pas sur le serveur!\n" + fileIn.getAbsolutePath(), "Erreur fichier", 0);
                    }
                });
            }
            return null;
        }
        File outFile = new File(f, fileName);
        if (attachment.isEncrypted() && outFile.length() > 0L) {
            try {
                byte[] bytes = FileUtils.readBytes(outFile);
                String encodeKey = this.fetchEncodedKey(config.getRootSociete().getTable("FWK_SCHEMA_METADATA"));
                if (encodeKey == null) {
                    throw new IllegalStateException("missing key");
                }
                byte[] decrypted = this.decrypt(this.getSecretKey(encodeKey), bytes);
                Files.write(outFile.toPath(), decrypted, new OpenOption[0]);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de decrypter le fichier\n" + outFile.getAbsolutePath(), e);
                return null;
            }
        }
        outFile.setReadOnly();
        return outFile;
    }

    public void deleteFile(Attachment rowAttachment) throws SQLException, IllegalStateException {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        config.getDirectory().getElement(AttachmentSQLElement.class).archive(rowAttachment.getId());
        this.updateAttachmentsCountFromAttachment(rowAttachment);
        if (!rowAttachment.isFolder()) {
            boolean isOnCloud = config.isOnCloud();
            String subDir = rowAttachment.getStoragePath();
            String fileName = rowAttachment.getStorageFileName();
            String remotePath = String.valueOf(config.getSocieteID()) + File.separator + subDir;
            if (isOnCloud) {
                remotePath = remotePath.replace('\\', '/');
            } else {
                File dirRoot = DocumentLocalStorageManager.getInstance().getDocumentOutputDirectory("EDMdirectory");
                File storagePathFile = new File(dirRoot, subDir);
                File f = new File(storagePathFile, fileName);
                if (f.exists() && !f.delete()) {
                    throw new IllegalStateException("Une erreur est survenue lors de la suppression du fichier");
                }
            }
        }
    }

    private void updateAttachmentsCountFromAttachment(Attachment rowAttachment) {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        SQLTable table = attachmentTable.getTable(rowAttachment.getSourceTable());
        SQLRow source = table.getRow(rowAttachment.getSourceId());
        this.updateAttachmentsCountFromSource(source);
    }

    private void updateAttachmentsCountFromSource(SQLRow rowSource) {
        SQLTable tableSource = rowSource.getTable();
        SQLTable tableAtt = rowSource.getTable().getTable("ATTACHMENT");
        String req = "UPDATE " + tableSource.getSQLName().quote() + " SET " + tableSource.getField("ATTACHMENTS").getQuotedName() + "=(SELECT COUNT(*) FROM " + tableAtt.getSQLName().quote();
        req = String.valueOf(req) + " WHERE " + tableAtt.getArchiveField().getQuotedName() + "=0 AND " + tableAtt.getField("SOURCE_TABLE").getQuotedName() + "='" + tableSource.getName() + "'";
        req = String.valueOf(req) + " AND " + tableAtt.getField("SOURCE_ID").getQuotedName() + "=" + rowSource.getID() + ") WHERE " + tableSource.getKey().getQuotedName() + "=" + rowSource.getID();
        tableSource.getDBSystemRoot().getDataSource().execute(req);
    }

    public static void rename(Attachment rowAttachment, String newName) {
        rowAttachment.setName(newName);
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        String req = "UPDATE " + attachmentTable.getSQLName().quote() + " SET " + attachmentTable.getField("NAME").getQuotedName() + "=" + attachmentTable.getBase().quoteString(newName) + " WHERE " + attachmentTable.getKey().getQuotedName() + "=" + rowAttachment.getId();
        attachmentTable.getDBSystemRoot().getDataSource().execute(req);
    }

    public void createFolder(String folderName, SQLRowAccessor rowSource, int idParent) throws SQLException {
        SQLRowValues rowValsAttachment = new SQLRowValues(rowSource.getTable().getTable("ATTACHMENT"));
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("ID_PARENT", idParent);
        rowValsAttachment.put("NAME", folderName);
        rowValsAttachment.put("SOURCE_TABLE", rowSource.getTable().getName());
        rowValsAttachment.put("SOURCE_ID", rowSource.getID());
        rowValsAttachment.put("MIMETYPE", "inode/directory");
        rowValsAttachment.put("FILENAME", "");
        rowValsAttachment.put("FILESIZE", 0);
        rowValsAttachment.put("STORAGE_PATH", "");
        rowValsAttachment.put("STORAGE_FILENAME", "");
        rowValsAttachment.commit();
    }

    public void move(Attachment a, Attachment folder) {
        if (!folder.isFolder()) {
            throw new IllegalArgumentException(folder + " is not a folder");
        }
        this.move(a, folder.getId());
    }

    public void move(Attachment a, int folderId) {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        SQLTable attachmentTable = config.getDirectory().getElement(AttachmentSQLElement.class).getTable();
        String req = "UPDATE " + attachmentTable.getSQLName().quote() + " SET " + attachmentTable.getField("ID_PARENT").getQuotedName() + "=" + folderId + " WHERE " + attachmentTable.getKey().getQuotedName() + "=" + a.getId();
        attachmentTable.getDBSystemRoot().getDataSource().execute(req);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        System.err.println("AttachmentUtils.main() key : " + new AttachmentUtils().generateBase64Key());
    }
}

