/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.ui.ContinuousActionEvent;
import org.openconcerto.ui.DelayTimer;
import org.openconcerto.ui.Log;

public class ContinuousButtonModel
extends DefaultButtonModel {
    private Thread thread = null;

    public static final ContinuousButtonModel createAccel(int delay) {
        return ContinuousButtonModel.createAccel(delay, (short)8);
    }

    public static final ContinuousButtonModel createAccel(int delay, short factor) {
        return new ContinuousButtonModel(delay, delay / factor, delay / factor);
    }

    public ContinuousButtonModel() {
        this(200);
    }

    public ContinuousButtonModel(int delay) {
        this(delay, 0, delay);
    }

    public ContinuousButtonModel(final int delay, final int accel, final int min) {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ContinuousButtonModel.this.isArmed()) {
                    ContinuousButtonModel.this.stop();
                }
                if (ContinuousButtonModel.this.isArmed() && ContinuousButtonModel.this.isPressed()) {
                    ContinuousButtonModel.this.launch(delay, accel, min);
                }
            }
        });
    }

    private ContinuousActionEvent createEvent() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return new ContinuousActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers);
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        this.fireStateChanged();
    }

    protected final synchronized void launch(int delay, int accel, int min) {
        if (this.thread != null) {
            Log.get().finest("previous thread was not stopped: " + this.thread);
            return;
        }
        final ContinuousActionEvent evt = this.createEvent();
        this.thread = new DelayTimer(new Runnable(){

            @Override
            public void run() {
                evt.fired();
                ContinuousButtonModel.this.fireActionPerformed(evt);
            }
        }, delay, accel, min);
        this.thread.start();
    }

    protected final synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
            this.setPressed(false);
        }
    }
}

