/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.view.listview.ItemPool;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListSQLView;

public abstract class FFPoolFactory
extends ItemPoolFactory {
    private final SQLTable t;
    private final SQLTable foreignT;
    private final List<SQLField> fields;

    public FFPoolFactory(SQLTable t, String foreignT) {
        this(t, foreignT, null);
    }

    public FFPoolFactory(SQLTable t, String foreignT, int count, boolean firstSuffixed) {
        this(t, foreignT, FFPoolFactory.computeFF(foreignT, count, firstSuffixed));
    }

    public FFPoolFactory(SQLTable t, String foreignT, List<String> fields) {
        this.t = t;
        this.foreignT = t.getDBRoot().getTable(foreignT);
        this.fields = new ArrayList<SQLField>();
        DatabaseGraph g = this.t.getDBSystemRoot().getGraph();
        if (fields == null) {
            fields = DatabaseGraph.getNames(g.getForeignLinks(this.t, this.foreignT), new ArrayList());
        }
        for (String fieldName : fields) {
            SQLField f = this.t.getField(fieldName);
            if (this.foreignT.equals(g.getForeignTable(f))) {
                this.fields.add(f);
                continue;
            }
            throw new IllegalArgumentException(f + " does not refer to " + foreignT);
        }
    }

    protected final List<SQLField> getFields() {
        return this.fields;
    }

    protected final SQLTable getForeignTable() {
        return this.foreignT;
    }

    protected final SQLTable getTable() {
        return this.t;
    }

    @Override
    public abstract ItemPool create(ListSQLView var1);

    @Override
    public final List<SQLRowAccessor> getItems(SQLRowAccessor r) {
        ArrayList<SQLRowAccessor> res = new ArrayList<SQLRowAccessor>();
        for (SQLField f : this.getFields()) {
            if (r.isForeignEmpty(f.getName())) continue;
            res.add(r.getForeign(f.getName()));
        }
        return res;
    }

    public String toString() {
        return this.getClass() + " on " + this.getFields();
    }
}

