/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.MultiLineTableCellEditor;
import org.openconcerto.erp.core.common.ui.RowValuesMultiLineEditTable;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.AnalytiqueItemTable;
import org.openconcerto.erp.core.finance.accounting.ui.CompteRowValuesRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.DeviseKmRowValuesRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.SaisieJournalPanel;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieKm;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JComponentUtils;
import org.openconcerto.ui.RangedIntegerTableCellEditor;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.checks.ValidState;

public class SaisieJournalItemTable
extends JPanel
implements MouseListener {
    private final RowValuesTable table;
    private final SQLTableElement debit;
    private final SQLTableElement credit;
    private JLabel labelTotalDebit;
    private JLabel labelTotalCredit;
    private JLabel labelTotalSolde;
    private final SQLTableElement tableElementNumeroCompte;
    private final CompteRowValuesRenderer numeroCompteRenderer = new CompteRowValuesRenderer();
    private final DeviseKmRowValuesRenderer deviseRenderer = new DeviseKmRowValuesRenderer();
    final RangedIntegerTableCellEditor rangedIntegerTableCellEditor = new RangedIntegerTableCellEditor(1, 31);
    private final RowValuesTableControlPanel controlPanel;
    private SaisieJournalPanel panel;
    private final JCheckBox boxAutoInsert;
    private boolean hideAnalytique = false;

    public SaisieJournalItemTable(final SQLRowValues defaultRowVals, JCheckBox boxAutoInsert, final JTextField textField) {
        this.setLayout(new GridBagLayout());
        this.boxAutoInsert = boxAutoInsert;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_KM_ELEMENT");
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTable tableElement = elt.getTable();
        SQLTableElement tableElementJour = new SQLTableElement(tableElement.getField("JOUR"), Integer.class, this.rangedIntegerTableCellEditor){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return super.isCellEditable(vals, rowIndex, columnIndex) && rowIndex == 0;
            }

            @Override
            protected Object getDefaultNullValue() {
                return 1;
            }
        };
        list.add(tableElementJour);
        this.tableElementNumeroCompte = new SQLTableElement(tableElement.getField("NUMERO"));
        list.add(this.tableElementNumeroCompte);
        SQLTableElement tableElementNomCompte = new SQLTableElement(tableElement.getField("NOM"));
        list.add(tableElementNomCompte);
        SQLTableElement tableElementNomPiece = new SQLTableElement(tableElement.getField("NOM_PIECE"));
        list.add(tableElementNomPiece);
        SQLTableElement tableElementNomEcriture = new SQLTableElement(tableElement.getField("NOM_ECRITURE"));
        list.add(tableElementNomEcriture);
        DeviseCellEditor deviseDebitEditor = new DeviseCellEditor();
        DeviseCellEditor deviseCreditEditor = new DeviseCellEditor();
        this.debit = new SQLTableElement(tableElement.getField("DEBIT"), Long.class, deviseDebitEditor);
        list.add(this.debit);
        this.credit = new SQLTableElement(tableElement.getField("CREDIT"), Long.class, deviseCreditEditor);
        list.add(this.credit);
        this.hideAnalytique = DefaultNXProps.getInstance().getBooleanValue("HideAnalytique");
        if (!this.hideAnalytique) {
            AnalytiqueItemTable analytiqueAssocTable = new AnalytiqueItemTable(true, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaisieJournalItemTable.this.montantValid(defaultRowVals, true, textField);
                }
            });
            MultiLineTableCellEditor multiLineTableCellEditor = new MultiLineTableCellEditor((RowValuesMultiLineEditTable)analytiqueAssocTable.getTable(), analytiqueAssocTable);
            SQLTableElement eltPourcentAnalytique = new SQLTableElement(tableElement.getField("ANALYTIQUE"), String.class, multiLineTableCellEditor){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return vals.getString("NUMERO") != null && (vals.getString("NUMERO").startsWith("6") || vals.getString("NUMERO").startsWith("7"));
                }
            };
            list.add(eltPourcentAnalytique);
        }
        RowValuesTableModel model = new RowValuesTableModel(elt, list, tableElement.getField("NUMERO"), false, defaultRowVals){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                int debitIndex = this.getColumnIndexForElement(SaisieJournalItemTable.this.debit);
                int creditIndex = this.getColumnIndexForElement(SaisieJournalItemTable.this.credit);
                if (debitIndex == columnIndex && ((Number)aValue).longValue() != 0L && ((Number)this.getValueAt(rowIndex, creditIndex)).longValue() != 0L) {
                    this.setValueAt(0L, rowIndex, creditIndex);
                } else if (creditIndex == columnIndex && ((Number)aValue).longValue() != 0L && ((Number)this.getValueAt(rowIndex, debitIndex)).longValue() != 0L) {
                    this.setValueAt(0L, rowIndex, debitIndex);
                }
            }
        };
        this.table = new RowValuesTable(model, null);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        tableElementNomEcriture.getTableCellEditor(this.table).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                e.getSource();
                int row = SaisieJournalItemTable.this.table.getSelectedRow();
                int col = 4;
                if (SaisieJournalItemTable.this.table.getValueAt(row, col) != null) {
                    defaultRowVals.put("NOM_ECRITURE", SaisieJournalItemTable.this.table.getValueAt(row, col));
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        tableElementNomPiece.getTableCellEditor(this.table).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                e.getSource();
                int row = SaisieJournalItemTable.this.table.getSelectedRow();
                int col = 3;
                if (SaisieJournalItemTable.this.table.getValueAt(row, col) != null) {
                    defaultRowVals.put("NOM_PIECE", SaisieJournalItemTable.this.table.getValueAt(row, col));
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        tableElementJour.getTableCellEditor(this.table).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                Object valueAt = SaisieJournalItemTable.this.table.getValueAt(0, 0);
                defaultRowVals.put("JOUR", valueAt);
                if (SaisieJournalItemTable.this.table.getRowCount() > 1) {
                    int i = 1;
                    while (i < SaisieJournalItemTable.this.table.getRowCount()) {
                        SaisieJournalItemTable.this.table.getRowValuesTableModel().putValue(valueAt, i, "JOUR");
                        ++i;
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        KeyAdapter keyListenerContrepartie = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SaisieJournalItemTable.this.montantValid(defaultRowVals, false, textField);
                }
            }
        };
        deviseCreditEditor.addKeyListener(keyListenerContrepartie);
        deviseDebitEditor.addKeyListener(keyListenerContrepartie);
        AutoCompletionManager m = new AutoCompletionManager(this.tableElementNumeroCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NUMERO"), this.table, this.table.getRowValuesTableModel(), 1, true, false, new ValidStateChecker(){
            ComptePCESQLElement elt = Configuration.getInstance().getDirectory().getElement(ComptePCESQLElement.class);

            @Override
            public ValidState getValidState(Object o) {
                if (o != null) {
                    return this.elt.getCompteNumeroValidState(o.toString());
                }
                return super.getValidState(o);
            }
        });
        m.fill("NOM", "NOM");
        m.setFillWithField("NUMERO");
        Where w = new Where((FieldRef)elt.getTable().getTable("COMPTE_PCE").getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        m.setWhere(w);
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNomCompte, ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getField("COMPTE_PCE.NOM"), this.table, this.table.getRowValuesTableModel(), 2, true);
        m2.fill("NUMERO", "NUMERO");
        m2.setFillWithField("NOM");
        m2.setWhere(w);
        JButton buttonClone = new JButton(TM.tr(Configuration.getInstance().getLocale(), "duplicateLine", new Object[0]));
        buttonClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SaisieJournalItemTable.this.cloneLine(SaisieJournalItemTable.this.table.getSelectedRow());
            }
        });
        buttonClone.setEnabled(false);
        ++c.gridx;
        JComponentUtils.setMinimumWidth(buttonClone, 95);
        this.controlPanel = new RowValuesTableControlPanel(this.table, Arrays.asList(buttonClone));
        this.controlPanel.setVisibleButtonClone(false);
        this.controlPanel.setButtonAjouterEnabled(false);
        this.add((Component)this.controlPanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), c);
        this.tableElementNumeroCompte.setRenderer(this.numeroCompteRenderer);
        this.debit.setRenderer(this.deviseRenderer);
        this.credit.setRenderer(this.deviseRenderer);
        this.table.addMouseListener(this);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    if (SaisieJournalItemTable.this.table.getRowCount() == 1) {
                        SaisieJournalItemTable.this.editCellAt(e.getFirstRow(), 0);
                    } else {
                        SaisieJournalItemTable.this.editCellAt(e.getFirstRow(), 1);
                    }
                }
                SaisieJournalItemTable.this.refreshTotal();
            }
        });
        this.labelTotalCredit = new JLabel("0.00", 4);
        this.labelTotalDebit = new JLabel("0.00", 4);
        this.labelTotalSolde = new JLabel("0.00", 4);
        JPanel panelTotal = new JPanel();
        panelTotal.setLayout(new GridBagLayout());
        panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux"));
        DefaultGridBagConstraints cc = new DefaultGridBagConstraints();
        cc.anchor = 13;
        cc.fill = 0;
        panelTotal.add((Component)new JLabel("D\u00e9bit"), cc);
        cc.fill = 2;
        ++cc.gridx;
        cc.weightx = 1.0;
        panelTotal.add((Component)this.labelTotalDebit, cc);
        ++cc.gridy;
        cc.gridx = 0;
        cc.weightx = 0.0;
        cc.fill = 0;
        panelTotal.add((Component)new JLabel("Cr\u00e9dit"), cc);
        cc.weightx = 1.0;
        ++cc.gridx;
        cc.fill = 2;
        panelTotal.add((Component)this.labelTotalCredit, cc);
        ++cc.gridy;
        cc.gridx = 0;
        cc.weightx = 0.0;
        cc.fill = 0;
        panelTotal.add((Component)new JLabel("Solde"), cc);
        cc.weightx = 1.0;
        ++cc.gridx;
        cc.fill = 2;
        panelTotal.add((Component)this.labelTotalSolde, cc);
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)panelTotal, c);
    }

    public void setPanel(final SaisieJournalPanel panel) {
        this.panel = panel;
        PropertyChangeListener lActiveAddButton = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaisieJournalItemTable.this.controlPanel.setButtonAjouterEnabled(!panel.getBoxJournal().isEmpty() && !panel.getBoxMois().isEmpty());
            }
        };
        panel.getBoxJournal().addModelListener("wantedID", lActiveAddButton);
        panel.getBoxMois().addModelListener("wantedID", lActiveAddButton);
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRow selectedRow;
                if (!((SaisieJournalItemTable)SaisieJournalItemTable.this).panel.boxMois.isEmpty() && (selectedRow = ((SaisieJournalItemTable)SaisieJournalItemTable.this).panel.boxMois.getSelectedRow()) != null && !selectedRow.isUndefined()) {
                    Calendar c = Calendar.getInstance();
                    c.set(5, 1);
                    c.set(1, (Integer)((SaisieJournalItemTable)SaisieJournalItemTable.this).panel.spin.getValue());
                    c.set(2, SaisieJournalItemTable.this.panel.getSelectedMonth());
                    SaisieJournalItemTable.this.rangedIntegerTableCellEditor.setMax(c.getActualMaximum(5));
                }
            }
        };
        panel.boxMois.addModelListener("wantedID", l);
    }

    public void refreshTotal() {
        long totalD = 0L;
        long totalC = 0L;
        int i = 0;
        while (i < this.table.getRowCount()) {
            Number c = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("DEBIT"));
            Number d = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("CREDIT"));
            if (c != null) {
                totalC += c.longValue();
            }
            if (d != null) {
                totalD += d.longValue();
            }
            ++i;
        }
        this.labelTotalCredit.setText(GestionDevise.currencyToString(totalC));
        this.labelTotalDebit.setText(GestionDevise.currencyToString(totalD));
        this.labelTotalSolde.setText(GestionDevise.currencyToString(totalD - totalC));
    }

    public boolean isSaisieValid() {
        long totalD = 0L;
        long totalC = 0L;
        boolean cptOK = true;
        String lib = null;
        int i = 0;
        while (i < this.table.getRowCount()) {
            Number c = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("DEBIT"));
            Number d = (Number)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("CREDIT"));
            if (c != null) {
                totalC += c.longValue();
            }
            if (d != null) {
                totalD += d.longValue();
            }
            if (lib == null) {
                lib = (String)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("NOM"));
            }
            String cptNUmber = (String)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("NUMERO"));
            cptOK = cptOK && cptNUmber != null && ComptePCESQLElement.isExist(cptNUmber);
            ++i;
        }
        return totalD + totalC != 0L && totalD == totalC && cptOK;
    }

    private Tuple2<Date, String> getDateAndLabelFromSaisie() {
        int day = 1;
        String lib = null;
        int i = 0;
        while (i < this.table.getRowCount()) {
            day = (Integer)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("JOUR"));
            if (lib == null) {
                lib = (String)this.table.getRowValuesTableModel().getValueAt(i, this.table.getRowValuesTableModel().getColumnForField("NOM"));
            }
            ++i;
        }
        Calendar c = Calendar.getInstance();
        c.set(1, this.panel.getSelectedYear());
        c.set(2, this.panel.getSelectedMonth());
        c.set(5, day);
        return Tuple2.create(c.getTime(), lib);
    }

    public void montantValid(final SQLRowValues defaultRowVals, final boolean fromAnalytique, final JTextField textPiece) {
        final SQLRowValues vals = this.table.getSelectedRowValues();
        final int selectedRow = this.table.getSelectedRow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SaisieJournalItemTable.this.boxAutoInsert.isSelected() && SaisieJournalItemTable.this.isSaisieValid()) {
                    if (SaisieJournalItemTable.this.panel.getSelectedJournal() == -1 || SaisieJournalItemTable.this.panel.getSelectedMonth() == -1) {
                        JOptionPane.showMessageDialog(SaisieJournalItemTable.this.panel, "Impossible de cr\u00e9er la saisie si aucun journal ou aucun mois n'est s\u00e9lectionn\u00e9!");
                    } else {
                        SaisieJournalItemTable.this.createSaisie(defaultRowVals, textPiece);
                    }
                } else if (!fromAnalytique && !SaisieJournalItemTable.this.hideAnalytique && vals.getString("NUMERO") != null && (vals.getString("NUMERO").startsWith("6") || vals.getString("NUMERO").startsWith("7"))) {
                    Collection<SQLRowValues> rowsLinked = vals.getReferentRows(vals.getTable().getTable("ASSOCIATION_ANALYTIQUE"));
                    long montant = vals.getLong("DEBIT") - vals.getLong("CREDIT");
                    for (SQLRowValues sqlRowValues : rowsLinked) {
                        sqlRowValues.put("MONTANT", sqlRowValues.getBigDecimal("POURCENT").movePointLeft(2).multiply(new BigDecimal(montant), DecimalUtils.HIGH_PRECISION).setScale(0, RoundingMode.HALF_UP).longValue());
                    }
                    SaisieJournalItemTable.this.editCellAt(selectedRow, SaisieJournalItemTable.this.table.getRowValuesTableModel().getColumnForField("ANALYTIQUE"));
                } else {
                    long l = SaisieJournalItemTable.this.getContrepartie();
                    SQLRowValues rowVals = new SQLRowValues(defaultRowVals);
                    if (l > 0L) {
                        rowVals.put("DEBIT", 0L);
                        rowVals.put("CREDIT", l);
                    } else {
                        rowVals.put("DEBIT", -l);
                        rowVals.put("CREDIT", 0L);
                    }
                    SaisieJournalItemTable.this.table.getRowValuesTableModel().addRow(rowVals);
                }
            }
        });
    }

    public synchronized void createSaisie(SQLRowValues defaultRowVals, JTextField pieceText) {
        Tuple2<Date, String> t = this.getDateAndLabelFromSaisie();
        Date d = t.get0();
        String pieceLabel = pieceText.getText();
        String lib = pieceLabel == null || pieceLabel.trim().length() == 0 ? t.get1() : pieceLabel;
        SQLRowValues rowVAlsKM = new SQLRowValues(this.table.getRowValuesTableModel().getSQLElement().getTable().getForeignTable("ID_SAISIE_KM"));
        rowVAlsKM.put("DATE", d);
        rowVAlsKM.put("NOM", lib);
        rowVAlsKM.put("ID_JOURNAL", this.panel.getSelectedJournal());
        try {
            int id = rowVAlsKM.insert().getID();
            this.table.updateField("ID_SAISIE_KM", id);
            this.table.clear();
            GenerationMvtSaisieKm gen = new GenerationMvtSaisieKm(id);
            int idMvt = gen.genereMouvement();
            SQLRowValues rowValsKMMvt = new SQLRowValues(this.table.getRowValuesTableModel().getSQLElement().getTable().getForeignTable("ID_SAISIE_KM"));
            rowValsKMMvt.put("ID_MOUVEMENT", (Object)idMvt);
            rowValsKMMvt.update(id);
            defaultRowVals.put("NOM_PIECE", "");
            defaultRowVals.put("NOM_ECRITURE", "");
            this.table.getRowValuesTableModel().addNewRow();
            pieceText.setText("");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public void insertFrom(SQLRowAccessor row) {
        this.table.insertFrom(row);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getCreditElement() {
        return this.credit;
    }

    public SQLTableElement getDebitElement() {
        return this.debit;
    }

    public SQLTableElement getNumeroCompteElement() {
        return this.tableElementNumeroCompte;
    }

    public void setCreateAutoActive(boolean b) {
        this.numeroCompteRenderer.setCreateActive(b);
        this.table.revalidate();
        this.table.repaint();
    }

    public void setRowDeviseValidAt(boolean b, int index) {
        this.deviseRenderer.setValid(b, index);
    }

    public void editCellAt(int row, int column) {
        assert (SwingUtilities.isEventDispatchThread());
        this.table.setColumnSelectionInterval(column, column);
        this.table.setRowSelectionInterval(row, row);
        this.table.editCellAt(row, column);
    }

    private long getContrepartie() {
        assert (SwingUtilities.isEventDispatchThread());
        long totalCred = 0L;
        long totalDeb = 0L;
        RowValuesTableModel model = this.table.getRowValuesTableModel();
        int creditIndex = model.getColumnIndexForElement(this.getCreditElement());
        int debitIndex = model.getColumnIndexForElement(this.getDebitElement());
        int i = 0;
        while (i < this.table.getRowCount()) {
            if (model.isRowValid(i)) {
                Number fTd;
                Number fTc = (Number)model.getValueAt(i, creditIndex);
                if (fTc != null) {
                    totalCred += fTc.longValue();
                }
                if ((fTd = (Number)model.getValueAt(i, debitIndex)) != null) {
                    totalDeb += fTd.longValue();
                }
            }
            ++i;
        }
        return totalDeb - totalCred;
    }

    private long getSoldeRow(int index) {
        assert (SwingUtilities.isEventDispatchThread());
        if (index >= 0 && index < this.table.getRowCount()) {
            SQLRowValues rowVals = this.table.getRowValuesTableModel().getRowValuesAt(index);
            return rowVals.getLong("DEBIT") - rowVals.getLong("CREDIT");
        }
        return 0L;
    }

    public void fillEmptyEntryLabel(String previousText, String text) {
        assert (SwingUtilities.isEventDispatchThread());
        if (text == null) {
            return;
        }
        RowValuesTableModel model = this.table.getRowValuesTableModel();
        int size = model.getRowCount();
        int i = 0;
        while (i < size) {
            SQLRowValues r = model.getRowValuesAt(i);
            if (r.getString("NOM_ECRITURE") == null || r.getString("NOM_ECRITURE").trim().isEmpty() || r.getString("NOM_ECRITURE").trim().equals(previousText)) {
                r.put("NOM_ECRITURE", text);
            }
            ++i;
        }
        model.fireTableDataChanged();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        final int rowSel = this.table.getSelectedRow();
        if (e.getButton() == 3 && rowSel >= 0 && rowSel < this.table.getRowCount()) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Contrepartie"){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    long l = SaisieJournalItemTable.this.getContrepartie();
                    if (SaisieJournalItemTable.this.table.getRowValuesTableModel().isRowValid(rowSel)) {
                        l += SaisieJournalItemTable.this.getSoldeRow(rowSel);
                    }
                    if (l > 0L) {
                        SaisieJournalItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "DEBIT");
                        SaisieJournalItemTable.this.table.getRowValuesTableModel().putValue(l, rowSel, "CREDIT");
                    } else {
                        SaisieJournalItemTable.this.table.getRowValuesTableModel().putValue(0L, rowSel, "CREDIT");
                        SaisieJournalItemTable.this.table.getRowValuesTableModel().putValue(-l, rowSel, "DEBIT");
                    }
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void cloneLine(int row) {
        if (row < 0) {
            return;
        }
        SQLRowValues rowVals = this.table.getRowValuesTableModel().getRowValuesAt(row);
        SQLRowValues rowValsBis = rowVals.deepCopy();
        rowValsBis.clearPrimaryKeys();
        rowValsBis.put(rowValsBis.getTable().getOrderField().getName(), null);
        this.table.getRowValuesTableModel().getSQLElement().clearPrivateFields(rowValsBis);
        rowValsBis.putEmptyLink("ID_ECRITURE");
        for (String elt : this.table.getClearCloneTableElement()) {
            if (!rowValsBis.getTable().getFieldsName().contains(elt)) continue;
            rowValsBis.putEmptyLink(elt);
        }
        this.table.getRowValuesTableModel().addRow(rowValsBis);
    }
}

