/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public class ComptePayePreferencePanel
extends DefaultPreferencePanel {
    private ISQLCompteSelector selCompteAcompte;
    private ISQLCompteSelector selCompteAcompteReglement;
    private ISQLCompteSelector selCompteRemunPers;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private SQLRowValues rowPrefCompteVals = new SQLRowValues(tablePrefCompte);

    public ComptePayePreferencePanel() {
        SQLRow rowPrefCompte = tablePrefCompte.getRow(2);
        this.rowPrefCompteVals.loadAbsolutelyAll(rowPrefCompte);
        Insets separatorInsets = new Insets(10, 2, 1, 2);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        Insets normalInsets = c.insets;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        TitledSeparator sep = new TitledSeparator("Acompte");
        c.gridwidth = 0;
        this.add((Component)sep, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte Acomptes"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteAcompte = new ISQLCompteSelector();
        this.selCompteAcompte.init();
        this.add((Component)this.selCompteAcompte, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Compte r\u00e8glement acompte"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteAcompteReglement = new ISQLCompteSelector();
        this.selCompteAcompteReglement.init();
        this.add((Component)this.selCompteAcompteReglement, c);
        ++c.gridy;
        c.gridx = 0;
        TitledSeparator sepVenteC = new TitledSeparator("Paye");
        c.gridwidth = 0;
        c.insets = separatorInsets;
        this.add((Component)sepVenteC, c);
        c.insets = normalInsets;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Compte r\u00e9mun\u00e9rations du personnel"), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.selCompteRemunPers = new ISQLCompteSelector();
        this.selCompteRemunPers.init();
        this.add((Component)this.selCompteRemunPers, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)new JPanel(), c);
        this.setValues();
    }

    @Override
    public void storeValues() {
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_ACOMPTE", this.selCompteAcompte.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_ACOMPTE_REGL", this.selCompteAcompteReglement.getValue());
        this.rowPrefCompteVals.put("ID_COMPTE_PCE_PAYE", this.selCompteRemunPers.getValue());
        try {
            Object[] pb = this.rowPrefCompteVals.getInvalid();
            if (pb != null) {
                SQLFieldTranslator trans = Configuration.getInstance().getTranslator();
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(this), "Impossible de valider les modifications! Le champ <" + trans.getLabelFor(this.rowPrefCompteVals.getTable().getField(pb[0].toString())) + "> pointe sur un compte invalide!(" + pb[1] + ")");
            } else {
                this.rowPrefCompteVals.update();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreToDefaults() {
        try {
            String compte = ComptePCESQLElement.getComptePceDefault("PayeAcompte");
            int value = ComptePCESQLElement.getId(compte);
            this.selCompteAcompte.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PayeReglementAcompte");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteAcompteReglement.setValue(value);
            compte = ComptePCESQLElement.getComptePceDefault("PayeRemunerationPersonnel");
            value = ComptePCESQLElement.getId(compte);
            this.selCompteRemunPers.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitleName() {
        return "Paye";
    }

    private void setValues() {
        try {
            this.setComboValues(this.selCompteAcompte, "ID_COMPTE_PCE_ACOMPTE", "PayeAcompte");
            this.setComboValues(this.selCompteAcompteReglement, "ID_COMPTE_PCE_ACOMPTE_REGL", "PayeReglementAcompte");
            this.setComboValues(this.selCompteRemunPers, "ID_COMPTE_PCE_PAYE", "PayeRemunerationPersonnel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setComboValues(ISQLCompteSelector combo, String field, String defaultName) {
        int value = 1;
        SQLRowAccessor row = this.rowPrefCompteVals.getForeign(field);
        if (row == null || row.isUndefined()) {
            String compte = ComptePCESQLElement.getComptePceDefault(defaultName);
            value = ComptePCESQLElement.getId(compte);
        } else {
            value = row.getID();
        }
        combo.setValue(value);
    }
}

