/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.element.RIVPanel;
import org.openconcerto.sql.element.SQLComponentItem;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.IComboModel;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.component.combo.SearchMode;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.coreanimation.Pulseable;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.NewSelection;

public class SQLRequestComboBox
extends JPanel
implements SQLForeignRowItemView,
ValueWrapper<Integer>,
EmptyObj,
TextComponent,
Pulseable,
SQLComponentItem,
InteractionMode.InteractionComponent {
    public static final String UNDEFINED_STRING = "----- ??? -----";
    private IComboModel req;
    protected final ISearchableCombo<IComboSelectionItem> combo;
    private final ValueChangeSupport<Integer> supp;
    private final EmptyChangeSupport emptySupp;
    private InteractionMode mode;
    private InteractionMode modeToSelect;
    private final String stringStuff;

    public SQLRequestComboBox() {
        this(true);
    }

    public SQLRequestComboBox(boolean addUndefined) {
        this(addUndefined, -1);
    }

    public SQLRequestComboBox(boolean addUndefined, int preferredWidthInChar) {
        this.setOpaque(false);
        this.mode = InteractionMode.READ_WRITE;
        this.modeToSelect = null;
        if (preferredWidthInChar > 0) {
            char[] a = new char[preferredWidthInChar];
            Arrays.fill(a, ' ');
            this.stringStuff = String.valueOf(a);
        } else {
            this.stringStuff = "123456789012345678901234567890";
        }
        this.combo = new ISearchableCombo(ComboLockedMode.LOCKED, 1, this.stringStuff.length());
        this.combo.setOnRemovingOrReplacingSelection(NewSelection.NO);
        this.combo.setForceDisplayStart(true);
        this.combo.setIncludeEmpty(addUndefined);
        this.combo.getActions().add(new AbstractAction("Recharger"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRequestComboBox.this.fillCombo(null, false);
            }
        });
        this.emptySupp = new EmptyChangeSupport(this);
        this.supp = new ValueChangeSupport<Integer>(this);
    }

    public final void setFirstFillSelection(ITransformer<List<IComboSelectionItem>, IComboSelectionItem> firstFillTransf) {
        this.req.setFirstFillSelection(firstFillTransf);
    }

    @Override
    public void added(RIVPanel sqlComp, SQLRowItemView v) {
        SQLTable foreignTable = v.getField().getForeignTable();
        if (!this.hasModel()) {
            this.uiInit(sqlComp.getDirectory().getElement(foreignTable).getComboRequest());
        } else if (this.getRequest().getPrimaryTable() != foreignTable) {
            throw new IllegalArgumentException("Tables are different " + this.getRequest().getPrimaryTable().getSQLName() + " != " + foreignTable.getSQLName());
        }
    }

    public final void uiInit(ComboSQLRequest req) {
        this.uiInit(new IComboModel(req));
    }

    protected final boolean hasModel() {
        return this.req != null;
    }

    public final IComboModel getModel() {
        return this.req;
    }

    public final void uiInit(IComboModel req) {
        if (this.hasModel()) {
            throw new IllegalStateException(this + " already inited.");
        }
        this.req = req;
        this.addModelListener("updating", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.updateEnabled();
            }
        });
        this.addModelListener("selectedValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.modelValueChanged();
            }
        });
        this.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.supp.fireValueChange();
            }
        });
        this.req.addEmptyListener(new EmptyListener(){

            @Override
            public void emptyChange(EmptyObj src, boolean newValue) {
                SQLRequestComboBox.this.emptySupp.fireEmptyChange(newValue);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    SQLRequestComboBox.this.updateListeners();
                }
            }
        });
        this.updateListeners();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLRequestComboBox.this.updateListeners();
                    }
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                SQLRequestComboBox.this.updateListeners();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        FontUtils.setFontFor(this.combo, "ComboBox", this.getRequest().getSeparatorsChars());
        int i = 0;
        while (i < this.combo.getUI().getAccessibleChildrenCount(this.combo)) {
            Accessible acc = this.combo.getUI().getAccessibleChild(this.combo, i);
            if (acc instanceof ComboPopup) {
                ComboPopup cp = (ComboPopup)((Object)acc);
                cp.getList().setPrototypeCellValue(new IComboSelectionItem(-1, this.stringStuff));
            }
            ++i;
        }
        this.combo.setIconFactory(new ITransformer<IComboSelectionItem, Icon>(){

            @Override
            public Icon transformChecked(IComboSelectionItem input) {
                return SQLRequestComboBox.this.getIconFor(input);
            }
        });
        this.combo.initCache(this.req);
        this.combo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.comboValueChanged();
            }
        });
        this.modelValueChanged();
        this.supp.fireValidChange();
        this.combo.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                SQLRequestComboBox.this.supp.fireValidChange();
            }
        });
        this.combo.addPropertyChangeListener("textCompFocused", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLRequestComboBox.this.updateEnabled();
            }
        });
        this.uiLayout();
        if (!this.updateEnabled()) {
            this.setInteractionMode(this.getInteractionMode());
        }
    }

    private final boolean updateEnabled() {
        boolean res = false;
        if (this.isDisabledState()) {
            if (this.modeToSelect == null) {
                this.modeToSelect = this.getInteractionMode();
                this.setEnabled(InteractionMode.DISABLED, true);
                res = true;
            }
        } else if (this.modeToSelect != null) {
            InteractionMode m = this.modeToSelect;
            this.modeToSelect = null;
            this.setEnabled(m, true);
            res = true;
        }
        return res;
    }

    private final boolean isDisabledState() {
        return this.isUpdating() && !this.combo.getTextComp().isFocusOwner();
    }

    public final List<Action> getActions() {
        return this.combo.getActions();
    }

    protected void updateListeners() {
        if (this.hasModel()) {
            ITableModel.SleepState newState = !this.isDisplayable() ? ITableModel.SleepState.HIBERNATING : (!this.isShowing() ? ITableModel.SleepState.SLEEPING : ITableModel.SleepState.AWAKE);
            this.req.setSleepState(newState);
        }
    }

    public final ComboSQLRequest getRequest() {
        return this.req.getRequest();
    }

    protected void uiLayout() {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.combo);
    }

    public void setDebug(boolean trace) {
        this.req.setDebug(trace);
        this.combo.setDebug(trace);
    }

    public final void setSleepAllowed(boolean sleepAllowed) {
        this.req.setSleepAllowed(sleepAllowed);
    }

    public final boolean isSleepAllowed() {
        return this.req.isSleepAllowed();
    }

    public final synchronized void fillCombo() {
        this.fillCombo(null);
    }

    public final synchronized void fillCombo(Runnable r) {
        this.fillCombo(r, true);
    }

    public final synchronized void fillCombo(Runnable r, boolean readCache) {
        this.req.fillCombo(r, readCache);
    }

    public final List<IComboSelectionItem> getItems() {
        return this.getComboModel().getList();
    }

    private DefaultIMutableListModel<IComboSelectionItem> getComboModel() {
        return (DefaultIMutableListModel)this.combo.getCache();
    }

    public final IComboSelectionItem getItem(int id) {
        return this.req.getItem(id);
    }

    public final void addModelListener(String propName, PropertyChangeListener l) {
        this.req.addListener(propName, l);
    }

    public final void removeModelListener(String propName, PropertyChangeListener l) {
        this.req.rmListener(propName, l);
    }

    @Override
    public final void resetValue() {
        this.setValue((Integer)null);
    }

    @Override
    public final void setValue(int id) {
        this.req.setValue(id);
    }

    @Override
    public final void setValue(Integer id) {
        if (id == null) {
            this.setValue(-1);
        } else {
            this.setValue((int)id);
        }
    }

    @Override
    public final void setValue(SQLRowAccessor r) {
        this.setValue(r == null ? null : Integer.valueOf(r.getID()));
    }

    @Override
    public final Integer getValue() {
        int id = this.getWantedID();
        return id == -1 ? null : Integer.valueOf(id);
    }

    @Override
    public final int getSelectedId() {
        return this.req.getSelectedId();
    }

    public final int getWantedID() {
        return this.req.getWantedID();
    }

    public final SQLRow getSelectedRow() {
        if (this.isEmpty()) {
            return null;
        }
        return this.req.getWantedRow();
    }

    public final SQLRowAccessor getSelectedRowAccessor() {
        IComboSelectionItem selectedValue = this.req.getSelectedValue();
        if (selectedValue == null) {
            return null;
        }
        SQLRowAccessor res = selectedValue.getRow();
        if (res == null || res instanceof SQLRow) {
            return res;
        }
        return ((SQLRowValues)res).toImmutable();
    }

    private void modelValueChanged() {
        IComboSelectionItem newValue = this.req.getSelectedValue();
        if (this.combo.getValue() != newValue) {
            this.combo.setValue(newValue);
        }
    }

    private final void comboValueChanged() {
        this.req.setValue(this.combo.getValue());
    }

    public final boolean addMissingItem() {
        return this.req.addMissingItem();
    }

    public final void setAddMissingItem(boolean addMissingItem) {
        this.req.setAddMissingItem(addMissingItem);
    }

    @Override
    public void setInteractionMode(InteractionMode mode) {
        this.setEnabled(mode);
    }

    public final void setEnabled(InteractionMode mode) {
        this.setEnabled(mode, false);
    }

    private final void setEnabled(InteractionMode mode, boolean priv) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!priv && this.isDisabledState()) {
            this.modeToSelect = mode;
        } else {
            this.mode = mode;
            this.modeChanged(mode);
        }
    }

    protected void modeChanged(InteractionMode mode) {
        mode.applyTo(this.combo);
    }

    @Override
    public final InteractionMode getInteractionMode() {
        return this.mode;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.req;
    }

    @Override
    public final boolean isEmpty() {
        return this.req == null || this.req.isEmpty();
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.emptySupp.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.emptySupp.removeEmptyListener(l);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public final void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    public final void addItemsListener(PropertyChangeListener l) {
        this.addItemsListener(l, false);
    }

    public final void addItemsListener(PropertyChangeListener l, boolean all) {
        this.req.addItemsListener(l, all);
    }

    public final void rmItemsListener(PropertyChangeListener l) {
        this.req.rmItemsListener(l);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getNoReasonInstance(this.hasModel()).and(this.combo.getValidState());
    }

    @Override
    public final void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    private Icon getIconFor(IComboSelectionItem value) {
        int flag;
        ImageIcon i = value == null ? null : ((flag = value.getFlag()) == 1 ? new ImageIcon(SQLRequestComboBox.class.getResource("warning.png")) : (flag == 2 ? new ImageIcon(SQLRequestComboBox.class.getResource("error.png")) : null));
        return i;
    }

    @Override
    public final JComponent getComp() {
        return this;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.combo.getTextComp();
    }

    public Collection<JComponent> getPulseComponents() {
        return Arrays.asList(this.combo);
    }

    public final void search(SearchSpec spec) {
        this.req.search(spec);
    }

    public final boolean isUpdating() {
        return this.req.isUpdating();
    }

    public final void setCompletionMode(SearchMode m) {
        this.combo.setCompletionMode(m);
    }
}

