/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class TextDefault
extends Changer<SQLTable> {
    public TextDefault(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        String infoSchema = t.getBase().quote("SELECT TABLE_NAME, COLUMN_NAME, COLUMN_DEFAULT, IS_NULLABLE from information_schema.COLUMNS where TABLE_SCHEMA=%s and TABLE_NAME=%s", t.getBase().getName(), t.getName());
        Map defaults = (Map)this.getDS().execute(infoSchema, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                HashMap<String, Object> res = new HashMap<String, Object>();
                while (rs.next()) {
                    res.put(rs.getString("COLUMN_NAME"), rs.getObject("COLUMN_DEFAULT"));
                }
                return res;
            }
        });
        for (SQLField f : t.getFields()) {
            if (!f.getType().getJavaType().equals(String.class) || !Boolean.FALSE.equals(f.isNullable()) || defaults.get(f.getName()) != null) continue;
            String req = "ALTER TABLE " + SQLBase.quoteIdentifier(t.getName()) + " MODIFY COLUMN " + SQLBase.quoteIdentifier(f.getName()) + " " + f.getType().getTypeName() + "(" + f.getType().getSize() + ") NOT NULL DEFAULT ''";
            System.err.println(req);
            this.getDS().execute(req);
        }
    }
}

