/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.sql.Date;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.humanresources.payroll.element.FichePayeSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.report.FichePayeSheetXML;
import org.openconcerto.erp.core.humanresources.payroll.ui.VisualisationPayeFrame;
import org.openconcerto.erp.model.FichePayeModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;

public class EditionFichePayeModel
extends AbstractTableModel {
    private Vector<Map<String, Object>> vData = new Vector();
    private String[] columnsName = new String[]{"A cr\u00e9er", "Salari\u00e9", "Brut", "Net", "Visualiser", "Imprimer"};
    private Map<Integer, String> mapColumn = new HashMap<Integer, String>();
    private JProgressBar bar;
    JLabel labelEtat;
    java.util.Date dateLimit = null;

    public EditionFichePayeModel(JProgressBar bar, JLabel labelEtat) {
        this.bar = bar;
        this.labelEtat = labelEtat;
        this.mapColumn.put(0, "A_CREER");
        this.mapColumn.put(1, "NOM");
        this.mapColumn.put(2, "BRUT");
        this.mapColumn.put(3, "NET");
        this.mapColumn.put(4, "VISU");
        this.mapColumn.put(5, "IMPRESSION");
        this.fill();
        this.updateAll();
        SQLElement eltSal = Configuration.getInstance().getDirectory().getElement("SALARIE");
        eltSal.getTable().addTableListener(new SQLTableListener(){

            @Override
            public void rowAdded(SQLTable table, int id) {
                EditionFichePayeModel.this.updateAll();
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                EditionFichePayeModel.this.updateAll();
            }

            @Override
            public void rowModified(SQLTable table, int id) {
                EditionFichePayeModel.this.updateAll();
            }
        });
    }

    public void setDateLimit(java.util.Date dateLimit) {
        this.dateLimit = dateLimit;
        this.fill();
        this.updateAll();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public int getRowCount() {
        return this.vData.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String s = this.mapColumn.get(columnIndex).toString();
        Map<String, Object> m = this.vData.get(rowIndex);
        return m.get(s);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnsName[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        String s = this.mapColumn.get(columnIndex).toString();
        if (s.equalsIgnoreCase("A_CREER") || s.equalsIgnoreCase("IMPRESSION") || s.equalsIgnoreCase("VISU")) {
            return Boolean.class;
        }
        if (s.equalsIgnoreCase("NOM")) {
            return String.class;
        }
        return Float.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String s = this.mapColumn.get(columnIndex).toString();
        return s.equalsIgnoreCase("A_CREER") || s.equalsIgnoreCase("IMPRESSION");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String s;
        Map<String, Object> m = this.vData.get(rowIndex);
        Object o = m.get(s = this.mapColumn.get(columnIndex).toString());
        if (o instanceof Boolean) {
            m.put(s, aValue);
        }
    }

    private void fill() {
        SQLElement eltSal = Configuration.getInstance().getDirectory().getElement("SALARIE");
        SQLSelect sel = new SQLSelect(eltSal.getTable().getBase());
        sel.addSelect(eltSal.getTable().getField("ID"));
        SQLTable tableInfos = eltSal.getTable().getTable("INFOS_SALARIE_PAYE");
        Where w = new Where((FieldRef)tableInfos.getKey(), "=", eltSal.getTable().getField("ID_INFOS_SALARIE_PAYE"));
        Where w2 = new Where((FieldRef)tableInfos.getField("DATE_SORTIE"), "=", (Object)null);
        if (this.dateLimit != null) {
            w2 = w2.or(new Where((FieldRef)tableInfos.getField("DATE_SORTIE"), ">=", (Object)this.dateLimit));
        }
        sel.setWhere(w.and(w2));
        this.vData.removeAllElements();
        List l = (List)eltSal.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                int idSal = ((Number)((Object[])l.get(i))[0]).intValue();
                HashMap<String, Comparable<Boolean>> m = new HashMap<String, Comparable<Boolean>>();
                m.put("A_CREER", Boolean.TRUE);
                m.put("NOM", new Integer(i));
                m.put("BRUT", new Integer(i));
                m.put("NET", new Integer(i));
                m.put("VISU", Boolean.TRUE);
                m.put("IMPRESSION", Boolean.FALSE);
                m.put("ID_SALARIE", new Integer(idSal));
                this.vData.add(m);
                ++i;
            }
        }
    }

    private void updateAll() {
        SQLElement eltSal = Configuration.getInstance().getDirectory().getElement("SALARIE");
        SQLElement eltFichePaye = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
        int i = 0;
        while (i < this.vData.size()) {
            Map<String, Object> m = this.vData.get(i);
            Integer idSal = Integer.parseInt(m.get("ID_SALARIE").toString());
            SQLRow rowSal = eltSal.getTable().getRow(idSal);
            int idFiche = rowSal.getInt("ID_FICHE_PAYE");
            SQLRow rowFiche = eltFichePaye.getTable().getRow(idFiche);
            m.put("BRUT", Float.valueOf(rowFiche.getFloat("SAL_BRUT")));
            m.put("NET", Float.valueOf(rowFiche.getFloat("NET_A_PAYER")));
            String nom = String.valueOf(rowSal.getString("NOM")) + " " + rowSal.getString("PRENOM") + " " + rowSal.getString("CODE");
            m.put("NOM", nom);
            ++i;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditionFichePayeModel.this.fireTableDataChanged();
                System.err.println("Update all");
            }
        });
    }

    public int getIdSalAtRow(int row) {
        Map<String, Object> m = this.vData.get(row);
        return ((Number)m.get("ID_SALARIE")).intValue();
    }

    public void validationFiche(final String annee, final int idMois, final Date du, final Date au) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    EditionFichePayeModel.this.bar.setMaximum(EditionFichePayeModel.this.vData.size() * 4 - 1);
                    EditionFichePayeModel.this.bar.setString(null);
                    EditionFichePayeModel.this.bar.setStringPainted(false);
                    int tmp = 0;
                    EditionFichePayeModel.this.bar.setValue(tmp);
                    SQLElement eltSal = Configuration.getInstance().getDirectory().getElement("SALARIE");
                    SQLElement eltFichePaye = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
                    int i = 0;
                    while (i < EditionFichePayeModel.this.vData.size()) {
                        Map m = (Map)EditionFichePayeModel.this.vData.get(i);
                        Boolean bCreate = (Boolean)m.get("A_CREER");
                        if (bCreate.booleanValue()) {
                            int idSal = ((Number)m.get("ID_SALARIE")).intValue();
                            SQLRow rowSalarie = eltSal.getTable().getRow(idSal);
                            final String salName = String.valueOf(rowSalarie.getString("CODE")) + " " + rowSalarie.getString("NOM");
                            final SQLRow row = eltSal.getTable().getRow(idSal);
                            final int idFiche = row.getInt("ID_FICHE_PAYE");
                            SQLRowValues rowVals = new SQLRowValues(eltFichePaye.getTable());
                            rowVals.put("ANNEE", Integer.valueOf(annee));
                            rowVals.put("ID_MOIS", idMois);
                            rowVals.put("DU", du);
                            rowVals.put("AU", au);
                            try {
                                rowVals.update(idFiche);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    (this).EditionFichePayeModel.this.labelEtat.setText(String.valueOf(salName) + " - Mise \u00e0 jour de la p\u00e9riode");
                                }
                            });
                            EditionFichePayeModel.this.bar.setValue(tmp++);
                            Boolean bVisu = (Boolean)m.get("VISU");
                            boolean resume = true;
                            if (bVisu.booleanValue()) {
                                Semaphore semaphore = new Semaphore(1);
                                try {
                                    semaphore.acquire();
                                    final VisualisationPayeFrame frame = new VisualisationPayeFrame(semaphore);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            frame.pack();
                                            frame.setSelectedFichePaye(idFiche);
                                            frame.setVisible(true);
                                        }
                                    });
                                    semaphore.acquire();
                                    System.err.println("Etat --> " + frame.getAnswer());
                                    resume = frame.getAnswer();
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            EditionFichePayeModel.this.bar.setValue(tmp++);
                            if (resume) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).EditionFichePayeModel.this.labelEtat.setText(String.valueOf(salName) + " - Validation de la fiche");
                                    }
                                });
                                FichePayeSQLElement.validationFiche(idFiche);
                                SQLRow rowSalNew = eltSal.getTable().getRow(idSal);
                                int idFicheNew = rowSalNew.getInt("ID_FICHE_PAYE");
                                FichePayeModel ficheModel = new FichePayeModel(idFicheNew);
                                ficheModel.loadAllElements();
                                EditionFichePayeModel.this.bar.setValue(tmp++);
                                try {
                                    SQLRow rowFiche = eltFichePaye.getTable().getRow(idFiche);
                                    FichePayeSheetXML sheet = new FichePayeSheetXML(rowFiche);
                                    sheet.createDocumentAsynchronous();
                                    Boolean bPrint = (Boolean)m.get("IMPRESSION");
                                    sheet.showPrintAndExportAsynchronous(false, bPrint, true, Collections.emptyList());
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du document!", e);
                                }
                                EditionFichePayeModel.this.bar.setValue(tmp++);
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).EditionFichePayeModel.this.labelEtat.setText(String.valueOf(salName) + " - Cr\u00e9ation annul\u00e9e");
                                    }
                                });
                                EditionFichePayeModel.this.bar.setValue(tmp += 2);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        String msg = "Cr\u00e9ation annul\u00e9e pour " + row.getString("CODE") + " " + row.getString("NOM") + " " + row.getString("PRENOM");
                                        JOptionPane.showMessageDialog(null, msg, "Cr\u00e9ation des payes", 1);
                                    }
                                });
                            }
                        } else {
                            EditionFichePayeModel.this.bar.setValue(tmp += 4);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur pendant la cr\u00e9ation des fiches de paye", e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditionFichePayeModel.this.updateAll();
                        JOptionPane.showMessageDialog(null, "Cr\u00e9ation des payes termin\u00e9e", "Cr\u00e9ation paye", 1);
                    }
                });
                EditionFichePayeModel.this.labelEtat.setText("Traitement termin\u00e9");
                EditionFichePayeModel.this.bar.setString("Termin\u00e9");
                EditionFichePayeModel.this.bar.setStringPainted(true);
            }
        };
        t.start();
    }
}

