/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationReglementVente
extends GenerationEcritures {
    private static final Integer journalCaisse = 5;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationReglementVente(int idEncaisseRegl) throws Exception {
        SQLRow encaisseMontantRow = base.getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
        int idEchCli = encaisseMontantRow.getInt("ID_ECHEANCE_CLIENT");
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(encaisseMontantRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)encaisseMontantRow.getObject("MONTANT"));
        this.date = (Date)encaisseMontantRow.getObject("DATE");
        String s = encaisseMontantRow.getString("NOM");
        this.nom = "R\u00e8glement vente " + (s == null ? "" : s) + " (" + typeRegRow.getString("NOM") + ")";
        this.putValue("DATE", this.date);
        this.putValue("NOM", this.nom);
        this.fillJournalBanqueFromRow(modeRegRow);
        this.putValue("ID_MOUVEMENT", this.idMvt);
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(this.date, idEncaisseRegl);
            } else {
                this.setDateReglement(idEncaisseRegl, idEchCli, this.date);
                if (typeRegRow.getID() == 4) {
                    this.putValue("ID_JOURNAL", journalCaisse);
                }
                SQLRow echeanceRow = null;
                int idCompteClient = -1;
                if (idEchCli > 1) {
                    echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
                    SQLRow clientRow = base.getTable("CLIENT").getRow(echeanceRow.getInt("ID_CLIENT"));
                    idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                    SQLRow rowMvt = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                    this.idMvt = this.getNewMouvement("ENCAISSER_MONTANT", idEncaisseRegl, rowMvt.getID(), rowMvt.getInt("ID_PIECE"));
                } else {
                    this.idMvt = this.getNewMouvement("ENCAISSER_MONTANT", idEncaisseRegl, 1, "");
                }
                if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
                this.putValue("ID_COMPTE_PCE", idCompteClient);
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", prixTTC.getLongValue());
                this.ajoutEcriture();
                if (typeRegRow.getID() == 4) {
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_CLIENT");
                    if (idCompteRegl <= 1) {
                        idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteEspece");
                    }
                    this.putValue("ID_COMPTE_PCE", idCompteRegl);
                } else {
                    this.fillCompteBanqueFromRow(modeRegRow, "VenteCB", false);
                }
                this.putValue("DEBIT", prixTTC.getLongValue());
                this.putValue("CREDIT", 0L);
                this.ajoutEcriture();
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch, idEncaisseRegl);
            } else {
                System.out.println("Ech\u00e9ance client");
                SQLRowValues valEcheance = new SQLRowValues(base.getTable("ECHEANCE_CLIENT"));
                SQLRow echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
                SQLRow rowMouv = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, rowMouv.getID(), rowMouv.getInt("ID_PIECE"));
                valEcheance.put("ID_MOUVEMENT", (Object)this.idMvt);
                valEcheance.put("DATE", dateEch);
                valEcheance.put("MONTANT", prixTTC.getLongValue());
                if (idEchCli > 1) {
                    valEcheance.put("ID_CLIENT", (Object)echeanceRow.getInt("ID_CLIENT"));
                }
                if (valEcheance.getInvalid() == null) {
                    SQLRow row = valEcheance.insert();
                    SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                    rowVals.put("IDSOURCE", row.getID());
                    rowVals.update(this.idMvt);
                }
            }
        }
    }

    private void setDateReglement(int idEncaisseRegl, int idEchCli, Date d) throws SQLException {
        if (idEchCli > 1) {
            SQLRow echeanceRow = Configuration.getInstance().getBase().getTable("ECHEANCE_CLIENT").getRow(idEchCli);
            SQLRow encaisseRow = Configuration.getInstance().getBase().getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
            long montant = (Long)encaisseRow.getObject("MONTANT");
            if (montant >= (Long)echeanceRow.getObject("MONTANT")) {
                int sourceId = MouvementSQLElement.getSourceId(echeanceRow.getInt("ID_MOUVEMENT"));
                SQLRow rowMvt = Configuration.getInstance().getBase().getTable("MOUVEMENT").getRow(sourceId);
                if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                    SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                    SQLRow saisieRow = eltFacture.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                    SQLRowValues rowValsUpdateVF = saisieRow.createEmptyUpdateRow();
                    rowValsUpdateVF.put("DATE_REGLEMENT", new Timestamp(d.getTime()));
                    rowValsUpdateVF.update();
                }
            }
        }
    }

    private void paiementCheque(Date dateEch, int idEncaisseRegl) throws SQLException {
        SQLRow encaisseMontantRow = base.getTable("ENCAISSER_MONTANT").getRow(idEncaisseRegl);
        int idEchCli = encaisseMontantRow.getInt("ID_ECHEANCE_CLIENT");
        SQLRow echeanceRow = base.getTable("ECHEANCE_CLIENT").getRow(idEchCli);
        PrixTTC prixTTC = new PrixTTC((Long)encaisseMontantRow.getObject("MONTANT"));
        SQLRowValues valCheque = new SQLRowValues(base.getTable("CHEQUE_A_ENCAISSER"));
        if (idEchCli > 1) {
            valCheque.put("ID_CLIENT", (Object)echeanceRow.getInt("ID_CLIENT"));
        }
        if (!encaisseMontantRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = encaisseMontantRow.getForeignRow("ID_MODE_REGLEMENT");
            valCheque.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
        }
        valCheque.put("DATE_VENTE", this.date);
        SQLRow rowMvtPere = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
        this.idMvt = this.getNewMouvement("CHEQUE_A_ENCAISSER", 1, rowMvtPere.getID(), rowMvtPere.getInt("ID_PIECE"));
        valCheque.put("DATE_MIN_DEPOT", dateEch);
        valCheque.put("ID_MOUVEMENT", (Object)this.idMvt);
        valCheque.put("MONTANT", prixTTC.getLongValue());
        if (valCheque.getInvalid() == null) {
            SQLRow row = valCheque.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

