/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AddressChoiceUI;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.customerrelationship.customer.ui.CategorieComptableChoiceUI;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureItemSQLElement;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.ui.ReliquatRowValuesTable;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonItemSQLElement;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.core.sales.shipment.ui.BonDeLivraisonItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.valuewrapper.ValidatedValueWrapper;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

public class BonDeLivraisonSQLComponent
extends TransfertBaseSQLComponent {
    private BonDeLivraisonItemTable tableBonItem;
    private ReliquatRowValuesTable tableBonReliquatItem;
    private ElementComboBox selectCommande;
    private ElementComboBox comboClient;
    private PanelOOSQLComponent panelOO;
    private JUniqueTextField textNumeroUnique;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final DeviseField textTotalHT = new DeviseField(6);
    private final DeviseField textTotalTVA = new DeviseField(6);
    private final DeviseField textTotalTTC = new DeviseField(6);
    private final JTextField textPoidsTotal = new JTextField(6);
    private final JTextField textNom = new JTextField(25);
    private final JDate date = new JDate(true);
    private final boolean displayDpt;
    private final ElementComboBox comboDpt = new ElementComboBox();
    private ElementComboBox comboCommercial;

    public BonDeLivraisonSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON"));
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        this.displayDpt = prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false);
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.tableBonItem.getRowValuesTable();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRow taxeDefault;
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        this.tableBonItem.getModel().clearRows();
        SQLRowValues rowVals = super.createDefaults();
        if (rowVals == null) {
            rowVals = new SQLRowValues(this.getTable());
        }
        SQLElement eltComm = this.getElement().getForeignElement("ID_COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            rowVals.put("CREATE_VIRTUAL_STOCK", Boolean.TRUE);
        }
        if (this.getTable().contains("ID_TAXE_PORT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        if (this.getTable().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            rowVals.put("ID_TAXE_FRAIS_DOCUMENT", taxeDefault.getID());
        }
        return rowVals;
    }

    @Override
    public void addViews() {
        TitledSeparator sep;
        SQLPreferences prefs;
        this.textTotalHT.setOpaque(false);
        this.textTotalTVA.setOpaque(false);
        this.textTotalTTC.setOpaque(false);
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            this.addView(new JCheckBox(), "CREATE_VIRTUAL_STOCK");
        }
        this.selectCommande = new ElementComboBox();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16){

            @Override
            public String getAutoRefreshNumber() {
                if (BonDeLivraisonSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(BonDeLivraisonSQLComponent.this.getElement().getClass(), BonDeLivraisonSQLComponent.this.date.getDate());
                }
                return null;
            }
        };
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.date, c);
        this.date.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!BonDeLivraisonSQLComponent.this.isFilling() && BonDeLivraisonSQLComponent.this.date.getValue() != null) {
                    BonDeLivraisonSQLComponent.this.tableBonItem.setDateDevise(BonDeLivraisonSQLComponent.this.date.getValue());
                }
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textNom, c);
        if (this.getTable().contains("DATE_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("DATE_LIVRAISON"), 4), c);
            JDate dateLivraison = new JDate(true);
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)dateLivraison, c);
            this.addView(dateLivraison, "DATE_LIVRAISON");
        }
        JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        c.weighty = 0.0;
        this.add((Component)labelClient, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        ValidatedValueWrapper<Integer> clientValidatedValueWrapper = ValidatedValueWrapper.add(new ElementComboBox(), new ITransformer<Integer, ValidState>(){

            @Override
            public ValidState transformChecked(Integer t) {
                ElementComboBox boxClient = (ElementComboBox)BonDeLivraisonSQLComponent.this.getView("ID_CLIENT").getComp();
                if (BonDeLivraisonSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION && boxClient != null && !boxClient.isEmpty() && (boxClient.getSelectedRow().getBoolean("BLOQUE_LIVRAISON").booleanValue() || boxClient.getSelectedRow().getBoolean("BLOQUE").booleanValue())) {
                    return ValidState.create(false, "Les int\u00e9ractions avec ce client sont verrouill\u00e9es.");
                }
                return ValidState.getTrueInstance();
            }
        });
        this.comboClient = (ElementComboBox)clientValidatedValueWrapper.getComp();
        this.addView(new SimpleRowItemView<Integer>(clientValidatedValueWrapper), "ID_CLIENT", (Object)"required");
        this.add((Component)this.comboClient, c);
        if (this.displayDpt) {
            ++c.gridx;
            c.gridwidth = 1;
            JLabel labelDpt = new JLabel(this.getLabelFor("ID_CLIENT_DEPARTEMENT"));
            labelDpt.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelDpt, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)this.comboDpt, c);
            DefaultGridBagConstraints.lockMinimumSize(this.comboDpt);
            this.addSQLObject(this.comboDpt, "ID_CLIENT_DEPARTEMENT");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = BonDeLivraisonSQLComponent.this.comboClient.getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = BonDeLivraisonSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        BonDeLivraisonSQLComponent.this.comboDpt.getRequest().setWhere(new Where((FieldRef)BonDeLivraisonSQLComponent.this.comboDpt.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", rowClient.getID()));
                    } else {
                        BonDeLivraisonSQLComponent.this.comboDpt.getRequest().setWhere(null);
                    }
                }
            });
        }
        if ((prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.ADDRESS_SPEC, true)) {
            final SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
            final AddressChoiceUI addressUI = new AddressChoiceUI();
            addressUI.addToUI(this, c);
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = BonDeLivraisonSQLComponent.this.comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        addressUI.getComboAdrF().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                        addressUI.getComboAdrL().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                    } else {
                        addressUI.getComboAdrF().getRequest().setWhere(Where.FALSE);
                        addressUI.getComboAdrL().getRequest().setWhere(Where.FALSE);
                    }
                }
            });
        }
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.CATEGORIE_COMPTABLE_SPEC, false)) {
            final CategorieComptableChoiceUI catUI = new CategorieComptableChoiceUI();
            catUI.addToUI(this, c);
            catUI.getCombo().addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = catUI.getCombo().getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        BonDeLivraisonSQLComponent.this.tableBonItem.setRowCatComptable(catUI.getCombo().getElement().getTable().getRow(wantedID));
                    } else {
                        BonDeLivraisonSQLComponent.this.tableBonItem.setRowCatComptable(null);
                    }
                }
            });
        }
        if (this.getTable().contains("SPEC_LIVRAISON")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("SPEC_LIVRAISON"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "SPEC_LIVRAISON");
        }
        if (this.getTable().contains("ID_CONTACT")) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"));
            labelContact.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelContact, c);
            final ElementComboBox comboContact = new ElementComboBox();
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)comboContact, c);
            final SQLElement contactElement = this.getElement().getForeignElement("ID_CONTACT");
            comboContact.init(contactElement, contactElement.getComboRequest(true));
            comboContact.getRequest().setWhere(Where.FALSE);
            DefaultGridBagConstraints.lockMinimumSize(comboContact);
            this.addView(comboContact, "ID_CONTACT");
            JLabel labelCommercial = new JLabel(this.getLabelFor("ID_COMMERCIAL"));
            labelCommercial.setHorizontalAlignment(4);
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)labelCommercial, c);
            this.comboCommercial = new ElementComboBox(false, 25);
            this.comboCommercial.setListIconVisible(false);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)this.comboCommercial, c);
            this.addRequiredSQLObject(this.comboCommercial, "ID_COMMERCIAL");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = BonDeLivraisonSQLComponent.this.comboClient.getWantedID();
                    System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = BonDeLivraisonSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        String alerte = rowClient.getString("ALERTE");
                        if (!BonDeLivraisonSQLComponent.this.isFilling() && alerte != null && alerte.trim().length() > 0) {
                            JOptionPane.showMessageDialog(BonDeLivraisonSQLComponent.this.comboClient, alerte);
                        }
                        int idClient = rowClient.getID();
                        comboContact.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_CLIENT"), "=", idClient));
                        if (rowClient.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowClient.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                            BonDeLivraisonSQLComponent.this.tableBonItem.setRowCatComptable(rowClient.getForeign("ID_CATEGORIE_COMPTABLE"));
                        } else {
                            BonDeLivraisonSQLComponent.this.tableBonItem.setRowCatComptable(null);
                        }
                        BonDeLivraisonSQLComponent.this.tableBonItem.setClient(rowClient, !BonDeLivraisonSQLComponent.this.isFilling());
                        if (!BonDeLivraisonSQLComponent.this.isFilling() && !rowClient.isForeignEmpty("ID_COMMERCIAL")) {
                            BonDeLivraisonSQLComponent.this.comboCommercial.setValue(rowClient.getForeignID("ID_COMMERCIAL"));
                        }
                    } else {
                        comboContact.getRequest().setWhere(Where.FALSE);
                        BonDeLivraisonSQLComponent.this.tableBonItem.setRowCatComptable(null);
                        if (!BonDeLivraisonSQLComponent.this.isFilling()) {
                            BonDeLivraisonSQLComponent.this.tableBonItem.setClient(null, true);
                        }
                    }
                }
            });
        }
        final ElementComboBox boxTarif = new ElementComboBox();
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (BonDeLivraisonSQLComponent.this.comboClient.getElement().getTable().contains("ID_TARIF")) {
                    if (BonDeLivraisonSQLComponent.this.isFilling()) {
                        return;
                    }
                    SQLRow row = ((SQLRequestComboBox)evt.getSource()).getSelectedRow();
                    if (row != null) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, TM.tr("deliveryForm.applyClientRates", new Object[0])) != 0)) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                }
            }
        });
        JButton boutonAll = new JButton(TM.tr("deliveryForm.shipAll", new Object[0]));
        boutonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesTableModel m = BonDeLivraisonSQLComponent.this.tableBonItem.getModel();
                int i = 0;
                while (i < m.getRowCount()) {
                    SQLRowValues rowVals = m.getRowValuesAt(i);
                    Object o = rowVals.getObject("QTE");
                    int qte = o == null ? 0 : ((Number)o).intValue();
                    m.putValue(qte, i, "QTE_LIVREE");
                    ++i;
                }
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_TARIF"), 4), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 1.0;
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    BonDeLivraisonSQLComponent.this.tableBonItem.setTarif(selectedRow, !BonDeLivraisonSQLComponent.this.isFilling());
                }
            });
            if (this.getTable().contains("SERVI_PAR")) {
                JLabel labelServi = new JLabel("Servi par");
                labelServi.setHorizontalAlignment(4);
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)labelServi, c);
                SQLTextCombo comboServiPar = new SQLTextCombo();
                ++c.gridx;
                c.fill = 0;
                c.weightx = 1.0;
                this.add((Component)comboServiPar, c);
                this.addRequiredSQLObject(comboServiPar, "SERVI_PAR");
            }
        }
        if (this.getTable().contains("A_ATTENTION")) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("A_ATTENTION"), 4), c);
            JTextField specLivraison = new JTextField();
            ++c.gridx;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)specLivraison, c);
            this.addView(specLivraison, "A_ATTENTION");
        }
        ArrayList<JButton> l = new ArrayList<JButton>();
        l.add(boutonAll);
        this.tableBonItem = new BonDeLivraisonItemTable(l);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.tableBonItem, c);
        c.anchor = 13;
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        DeviseField fieldEco = new DeviseField(5);
        DeviseField textPortHT = new DeviseField(5);
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldHA = new DeviseField();
        fieldHA.setOpaque(false);
        fieldService.setOpaque(false);
        if (this.getTable().contains("TOTAL_DEVISE")) {
            this.addSQLObject(fieldDevise, "TOTAL_DEVISE");
            this.addRequiredSQLObject(fieldService, "TOTAL_SERVICE");
        }
        if (this.getTable().contains("PREBILAN")) {
            this.addSQLObject(fieldHA, "PREBILAN");
        } else if (this.getTable().contains("T_HA")) {
            this.addSQLObject(fieldHA, "T_HA");
            this.allowEditable("T_HA", false);
        }
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.fill = 0;
        this.addSQLObject(this.textPoidsTotal, "TOTAL_POIDS");
        this.addSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(this.textTotalHT, "TOTAL_HT");
        this.addRequiredSQLObject(this.textTotalTVA, "TOTAL_TVA");
        this.addRequiredSQLObject(this.textTotalTTC, "TOTAL_TTC");
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("TOTAL_HT", false);
        this.allowEditable("TOTAL_TVA", false);
        this.allowEditable("TOTAL_TTC", false);
        this.allowEditable("TOTAL_POIDS", false);
        final TotalPanel panelTotal = new TotalPanel(this.tableBonItem, fieldEco, this.textTotalHT, this.textTotalTVA, this.textTotalTTC, textPortHT, textRemiseHT, fieldService, fieldHA, fieldDevise, this.textPoidsTotal, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null, null);
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        panel.add((Component)new JLabel(this.getLabelFor("TOTAL_POIDS")), cFrais);
        this.textPoidsTotal.setEnabled(false);
        this.textPoidsTotal.setHorizontalAlignment(4);
        this.textPoidsTotal.setDisabledTextColor(Color.BLACK);
        ++cFrais.gridx;
        panel.add((Component)this.textPoidsTotal, cFrais);
        panel.setOpaque(false);
        DefaultGridBagConstraints.lockMinimumSize(panel);
        DefaultGridBagConstraints.lockMinimumSize(textPortHT);
        this.addSQLObject(textPortHT, "PORT_HT");
        DefaultGridBagConstraints.lockMinimumSize(textRemiseHT);
        this.addSQLObject(textRemiseHT, "REMISE_HT");
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelPortHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)textPortHT, cFrais);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cFrais.gridx = 0;
            ++cFrais.gridy;
            panel.add((Component)labelTaxeHT, cFrais);
            ++cFrais.gridx;
            panel.add((Component)boxTaxePort, cFrais);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
            boxTaxePort.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    panelTotal.updateTotal();
                }
            });
        }
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 0;
        panel.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        panel.add((Component)textRemiseHT, cFrais);
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)panel, c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 2;
        this.add((Component)panelTotal, c);
        c.anchor = 17;
        if (this.getTable().getDBRoot().contains("RELIQUAT_BL")) {
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            sep = new TitledSeparator("Reliquat de kits");
            c.insets = new Insets(10, 2, 1, 2);
            this.add((Component)sep, c);
            c.insets = new Insets(2, 2, 1, 2);
            this.tableBonReliquatItem = new ReliquatRowValuesTable("RELIQUAT_BL");
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.fill = 1;
            this.add((Component)this.tableBonReliquatItem, c);
            this.tableBonItem.setReliquatTable(this.tableBonReliquatItem);
        }
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        sep = new TitledSeparator(this.getLabelFor("INFOS"));
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        ITextArea textInfos = new ITextArea(4, 4);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(textInfos);
        this.add((Component)scrollPane, c);
        textInfos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addRequiredSQLObject(this.date, "DATE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject(this.textNom, "NOM");
        this.addSQLObject(this.selectCommande, "ID_COMMANDE_CLIENT");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                panelTotal.updateTotal();
            }
        });
    }

    public BonDeLivraisonItemTable getTableBonItem() {
        return this.tableBonItem;
    }

    private void reconfigure(JTextField field) {
        field.setEnabled(false);
        field.setHorizontalAlignment(4);
        field.setDisabledTextColor(Color.BLACK);
        field.setBorder(null);
    }

    @Override
    public int insert(SQLRow order) {
        String num;
        int idBon = this.getSelectedID();
        int attempt = 0;
        if (!this.textNumeroUnique.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.date.getDate());
                this.textNumeroUnique.setText(num);
                ++attempt;
                if (this.textNumeroUnique.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.textNumeroUnique.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idBon = this.getSelectedID();
            ExceptionHandler.handle(TM.tr("deliveryForm.cannotAdd.existingNumber", new Object[0]));
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            List<ProductComponent> comps;
            if (this.getTable().getDBRoot().contains("TARIF_AGENCE") && (comps = this.checkStock()).size() > 0) {
                String article = "";
                for (ProductComponent comp : comps) {
                    article = String.valueOf(article) + "\n " + comp.getProduct().getString("CODE") + " --- " + comp.getProduct().getString("NOM");
                }
                JOptionPane.showMessageDialog(null, String.valueOf(TM.tr("deliveryForm.cannotCreate.notInStock", new Object[0])) + article);
                Component root = SwingUtilities.getRoot(this);
                if (root instanceof EditFrame) {
                    EditFrame frame = (EditFrame)root;
                    frame.getPanel().setAlwaysVisible(true);
                }
                return -1;
            }
            idBon = super.insert(order);
            if (this.tableBonReliquatItem != null) {
                this.tableBonReliquatItem.updateField("ID_BON_DE_LIVRAISON_ORIGINE", idBon);
            }
            this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", idBon);
            this.tableBonItem.createArticle(idBon, this.getElement());
            List<Object> cmdDourceTrRowsFrom = ((BonDeLivraisonSQLElement)this.getElement()).getSourceTrRowsFrom(idBon, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
            ((BonDeLivraisonSQLElement)this.getElement()).updateQteLivree(cmdDourceTrRowsFrom, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
            List<Object> devisSourceTrRowsFrom = ((BonDeLivraisonSQLElement)this.getElement()).getSourceTrRowsFrom(idBon, "DEVIS_ELEMENT", "DEVIS");
            ((BonDeLivraisonSQLElement)this.getElement()).updateQteLivree(devisSourceTrRowsFrom, "DEVIS_ELEMENT", "DEVIS");
            SQLRow row = this.getTable().getRow(idBon);
            BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(row);
            bSheet.createDocumentAsynchronous();
            bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), row);
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("BON_L_START");
                rowVals.put("BON_L_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.updateStock(idBon);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, TM.tr("deliveryForm.numberRefreshed", num));
                    }
                });
            }
        }
        return idBon;
    }

    private List<ProductComponent> checkStock() {
        ArrayList<ProductComponent> comps = new ArrayList<ProductComponent>();
        RowValuesTableModel rowValuesTableModel = this.tableBonItem.getRowValuesTable().getRowValuesTableModel();
        int i = 0;
        while (i < rowValuesTableModel.getRowCount()) {
            ProductComponent comp;
            SQLRowAccessor article;
            SQLRowValues rowValuesAt = rowValuesTableModel.getRowValuesAt(i);
            if (rowValuesAt.getInt("QTE_LIVREE") > 0 && rowValuesAt != null && rowValuesAt.getObject("ID_ARTICLE") != null && !rowValuesAt.isForeignEmpty("ID_ARTICLE") && (article = rowValuesAt.getForeign("ID_ARTICLE")).getBoolean("GESTION_STOCK").booleanValue() && (comp = ProductComponent.createFrom(rowValuesAt)).getStock() != null && !comp.getStock().isUndefined() && comp.getStock().getFloat("QTE_REEL") < 0.0f) {
                comps.add(comp);
            }
            ++i;
        }
        return comps;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues().deepCopy();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (this.tableBonReliquatItem != null) {
            this.tableBonReliquatItem.getRowValuesTable().clear();
            if (r != null) {
                this.tableBonReliquatItem.getRowValuesTable().insertFrom("ID_BON_LIVRAISON_ORIGINE", r.asRowValues());
            }
        }
    }

    @Override
    public void update() {
        if (!this.textNumeroUnique.checkValidation()) {
            ExceptionHandler.handle(TM.tr("deliveryForm.cannotAdd.existingNumber", new Object[0]));
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        if (this.tableBonReliquatItem != null) {
            this.tableBonReliquatItem.updateField("ID_BON_DE_LIVRAISON_ORIGINE", this.getSelectedID());
        }
        List<Object> cmdClientFrom = ((BonDeLivraisonSQLElement)this.getElement()).getSourceTrRowsFrom(this.getSelectedID(), "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
        List<Object> devisFrom = ((BonDeLivraisonSQLElement)this.getElement()).getSourceTrRowsFrom(this.getSelectedID(), "DEVIS_ELEMENT", "DEVIS");
        this.tableBonItem.updateField("ID_BON_DE_LIVRAISON", this.getSelectedID());
        this.tableBonItem.createArticle(this.getSelectedID(), this.getElement());
        ((BonDeLivraisonSQLElement)this.getElement()).updateQteLivree(devisFrom, "DEVIS_ELEMENT", "DEVIS");
        ((BonDeLivraisonSQLElement)this.getElement()).updateQteLivree(cmdClientFrom, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        BonLivraisonXmlSheet bSheet = new BonLivraisonXmlSheet(row);
        bSheet.createDocumentAsynchronous();
        bSheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), row);
        try {
            this.updateStock(this.getSelectedID());
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadQuantity(List<SQLRowValues> l, String fromTableElt) {
        HashMap<Integer, SQLRowValues> map = new HashMap<Integer, SQLRowValues>();
        for (SQLRowValues sqlRowValues : l) {
            if (sqlRowValues.isForeignEmpty("ID_ARTICLE") && sqlRowValues.getBigDecimal("PV_HT").signum() == 0 || sqlRowValues.isForeignEmpty("ID_" + fromTableElt)) continue;
            int foreignID = sqlRowValues.getForeignID("ID_" + fromTableElt);
            if (!map.containsKey(foreignID)) {
                map.put(foreignID, sqlRowValues);
                continue;
            }
            SQLRowValues vals = (SQLRowValues)map.get(foreignID);
            if (sqlRowValues.getInt("QTE_LIVREE") <= 0) continue;
            if (NumberUtils.areNumericallyEqual(sqlRowValues.getBigDecimal("QTE_UNITAIRE"), BigDecimal.ONE) || sqlRowValues.getInt("QTE_LIVREE") > 1) {
                vals.put("QTE_LIVREE", vals.getInt("QTE_LIVREE") + sqlRowValues.getInt("QTE_LIVREE"));
                continue;
            }
            vals.put("QTE_UNITAIRE", vals.getBigDecimal("QTE_UNITAIRE").add(sqlRowValues.getBigDecimal("QTE_UNITAIRE")));
        }
        int count = this.tableBonItem.getModel().getRowCount();
        int i = 0;
        while (i < count) {
            SQLRowValues rowValuesAt = this.tableBonItem.getModel().getRowValuesAt(i);
            rowValuesAt.put("QTE_LIVREE", rowValuesAt.getObject("QTE"));
            ++i;
        }
        i = 0;
        while (i < count) {
            SQLRowValues r = this.tableBonItem.getModel().getRowValuesAt(i);
            SQLRowValues rowTR = (SQLRowValues)map.get(r.getForeignID("ID_" + fromTableElt));
            if (rowTR != null && !rowTR.isUndefined()) {
                if (r.getInt("QTE_LIVREE") > 0 && rowTR.getInt("QTE_LIVREE") > 0) {
                    if (NumberUtils.areNumericallyEqual(r.getBigDecimal("QTE_UNITAIRE"), BigDecimal.ONE) || r.getInt("QTE_LIVREE") > 1) {
                        this.tableBonItem.getModel().putValue(r.getInt("QTE_LIVREE") - rowTR.getInt("QTE_LIVREE"), i, "QTE_LIVREE");
                    } else {
                        this.tableBonItem.getModel().putValue(r.getBigDecimal("QTE_UNITAIRE").subtract(rowTR.getBigDecimal("QTE_UNITAIRE")), i, "QTE_UNITAIRE");
                    }
                }
            } else {
                this.tableBonItem.getModel().putValue(r.getObject("QTE"), i, "QTE_LIVREE");
            }
            ++i;
        }
    }

    public void updateQte(int idBon) throws SQLException {
        SQLTable tableFactureElem = this.getDirectory().getElement(SaisieVenteFactureItemSQLElement.class).getTable();
        SQLSelect selBonItem = new SQLSelect();
        BonDeLivraisonItemSQLElement bonElt = this.getDirectory().getElement(BonDeLivraisonItemSQLElement.class);
        selBonItem.addSelect(bonElt.getTable().getField("ID_SAISIE_VENTE_FACTURE_ELEMENT"));
        selBonItem.addSelect(bonElt.getTable().getField("QTE_LIVREE"));
        selBonItem.setWhere(bonElt.getTable().getField("ID_BON_DE_LIVRAISON"), "=", idBon);
        String reqBonItem = selBonItem.asString();
        Object obBonItem = this.getTable().getBase().getDataSource().execute(reqBonItem, new ArrayListHandler());
        List myListBonItem = (List)obBonItem;
        int size = myListBonItem.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myListBonItem.get(i);
            SQLRow rowFactElem = tableFactureElem.getRow(((Number)objTmp[0]).intValue());
            SQLRowValues rowVals = new SQLRowValues(tableFactureElem);
            rowVals.put("QTE_LIVREE", (Object)(rowFactElem.getInt("QTE_LIVREE") + ((Number)objTmp[1]).intValue()));
            rowVals.update(rowFactElem.getID());
            ++i;
        }
    }

    public void cancelUpdateQte(int idBon) throws SQLException {
        SQLTable tableFactureElem = this.getDirectory().getElement(SaisieVenteFactureItemSQLElement.class).getTable();
        SQLSelect selBonItem = new SQLSelect();
        BonDeLivraisonItemSQLElement bonElt = this.getDirectory().getElement(BonDeLivraisonItemSQLElement.class);
        selBonItem.addSelect(bonElt.getTable().getField("ID_SAISIE_VENTE_FACTURE_ELEMENT"));
        selBonItem.addSelect(bonElt.getTable().getField("QTE_LIVREE"));
        selBonItem.setWhere(bonElt.getTable().getField("ID_BON_DE_LIVRAISON"), "=", idBon);
        String reqBonItem = selBonItem.asString();
        Object obBonItem = this.getTable().getBase().getDataSource().execute(reqBonItem, new ArrayListHandler());
        List myListBonItem = (List)obBonItem;
        int size = myListBonItem.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myListBonItem.get(i);
            SQLRow rowFactElem = tableFactureElem.getRow(((Number)objTmp[0]).intValue());
            SQLRowValues rowVals = new SQLRowValues(tableFactureElem);
            rowVals.put("QTE_LIVREE", (Object)(((Number)objTmp[1]).intValue() - rowFactElem.getInt("QTE_LIVREE")));
            rowVals.update(rowFactElem.getID());
            ++i;
        }
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "BL N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row;
        boolean stockWithBL;
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean bl = stockWithBL = !prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true);
        if (this.getTable().getForeignTable("ID_CLIENT").contains("NOTE_2018")) {
            row = this.getTable().getRow(id);
            Collection items = row.getReferentRows(this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT"));
            for (SQLRow sqlRow : items) {
                if (!sqlRow.contains("ID_COMMANDE_CLIENT_ELEMENT") || sqlRow.isForeignEmpty("ID_COMMANDE_CLIENT_ELEMENT")) continue;
                stockWithBL = true;
                break;
            }
        }
        if (stockWithBL) {
            row = this.getTable().getRow(id);
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return BonDeLivraisonSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT")), this.getTable().contains("CREATE_VIRTUAL_STOCK") && row.getBoolean("CREATE_VIRTUAL_STOCK") != false ? StockItemsUpdater.TypeStockUpdate.REAL_VIRTUAL_DELIVER : StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            if (this.getTable().getDBRoot().contains("RELIQUAT_BL")) {
                Collection l = row.getReferentRows(this.getTable().getTable("RELIQUAT_BL").getField("ID_BON_DE_LIVRAISON_ORIGINE"));
                for (SQLRow sqlRow : l) {
                    stockUpdater.addReliquat(sqlRow.getForeign("ID_ARTICLE"), sqlRow.getInt("QTE"), sqlRow.getBigDecimal("QTE_UNITAIRE"));
                }
            }
            stockUpdater.update();
        }
    }

    public void duplicate(int idCmd) {
        Collection myListItem;
        SQLElement cmd = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLElement cmdElt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON_ELEMENT");
        if (idCmd > 1) {
            SQLRow row = cmd.getTable().getRow(idCmd);
            SQLRowValues rowVals = new SQLRowValues(cmd.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
            this.select(rowVals);
        }
        if ((myListItem = cmd.getTable().getRow(idCmd).getReferentRows(cmdElt.getTable())).size() != 0) {
            this.getRowValuesTable().getRowValuesTableModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                rowVals.putEmptyLink("ID_COMMANDE_CLIENT_ELEMENT");
                this.getRowValuesTable().getRowValuesTableModel().addRow(rowVals, false);
                int rowIndex = this.getRowValuesTable().getRowValuesTableModel().getRowCount() - 1;
                this.getRowValuesTable().getRowValuesTableModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.getRowValuesTable().getRowValuesTableModel().clearRows();
        }
        this.getRowValuesTable().getRowValuesTableModel().fireTableDataChanged();
        this.getRowValuesTable().repaint();
    }

    public void loadFromReliquat(List<SQLRowValues> l) {
        this.tableBonItem.insertFromReliquat(l);
        this.tableBonItem.setEnabled(false);
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
        this.tableBonItem.setDateDevise(this.date.getValue());
    }
}

