/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ReliquatCommandeTableModel
extends AbstractTableModel {
    private List<String> columns = Arrays.asList("Code", "Nom", "Qt\u00e9 cmd", "Reliquat");
    private final List<? extends SQLRowAccessor> values;

    public ReliquatCommandeTableModel(SQLRowAccessor rowCmd) {
        this.values = this.getValues(rowCmd);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return BigDecimal.class;
        }
        return BigDecimal.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.values.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.values.get(rowIndex).getString("CODE");
        }
        if (columnIndex == 1) {
            return this.values.get(rowIndex).getString("NOM");
        }
        if (columnIndex == 2) {
            return this.values.get(rowIndex).getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(this.values.get(rowIndex).getString("QTE"))).setScale(2, RoundingMode.HALF_UP);
        }
        BigDecimal qteCmd = this.values.get(rowIndex).getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(this.values.get(rowIndex).getString("QTE"))).setScale(2, RoundingMode.HALF_UP);
        SQLRowAccessor rowAccessor = this.values.get(rowIndex);
        String field = rowAccessor.getTable().getName().equals("COMMANDE_ELEMENT") ? "QTE_RECUE" : "QTE_LIVREE";
        BigDecimal qteLivre = rowAccessor.getBigDecimal(field) == null ? BigDecimal.ZERO : this.values.get(rowIndex).getBigDecimal(field).setScale(2, RoundingMode.HALF_UP);
        return qteCmd.subtract(qteLivre);
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    private List<? extends SQLRowAccessor> getValues(SQLRowAccessor rowCmd) {
        SQLTable tableCmd = rowCmd.getTable();
        SQLTable table = tableCmd.getTable(String.valueOf(tableCmd.getName()) + "_ELEMENT");
        SQLRowValues rowVals = new SQLRowValues(table);
        String fieldQteRecueLivree = tableCmd.getName().equals("COMMANDE") ? "QTE_RECUE" : "QTE_LIVREE";
        rowVals.putNulls("CODE", "NOM", "QTE", "QTE_UNITAIRE", fieldQteRecueLivree);
        Where w = new Where((FieldRef)table.getField("ID_" + tableCmd.getName()), "=", rowCmd.getID());
        Where w2 = Where.createRaw(String.valueOf(table.getField(fieldQteRecueLivree).getQuotedName()) + " < (" + table.getField("QTE").getQuotedName() + "*" + table.getField("QTE_UNITAIRE").getQuotedName() + ")", table.getField("QTE_UNITAIRE"), table.getField("QTE"), table.getField(fieldQteRecueLivree)).or(Where.isNull(table.getField(fieldQteRecueLivree)));
        String fieldRecueLivree = tableCmd.getName().equals("COMMANDE") ? "RECU" : "LIVRE";
        String fieldRecueLivreeForced = tableCmd.getName().equals("COMMANDE") ? "RECU_FORCED" : "LIVRE_FORCED";
        return SQLRowValuesListFetcher.create(rowVals).fetch(w.and(w2).and(new Where((FieldRef)table.getField(fieldRecueLivree), "=", (Object)Boolean.FALSE)).and(new Where((FieldRef)table.getField(fieldRecueLivreeForced), "=", (Object)Boolean.FALSE)));
    }
}

