/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.action;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;

public class ListeDesReferencesAction
extends CreateFrameAbstractAction {
    public ListeDesReferencesAction() {
        this.putValue("Name", "Liste des r\u00e9f\u00e9rences");
    }

    @Override
    public JFrame createFrame() {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        final SQLElement elementArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        ArrayList<String> listF = new ArrayList<String>();
        listF.add("CODE");
        listF.add("NOM");
        listF.add("ID_MODE_VENTE_ARTICLE");
        listF.add("POIDS");
        listF.add("VALEUR_METRIQUE_1");
        listF.add("VALEUR_METRIQUE_2");
        listF.add("VALEUR_METRIQUE_3");
        listF.add("PRIX_METRIQUE_HA_1");
        listF.add("PRIX_METRIQUE_VT_1");
        listF.add("ID_TAXE");
        listF.add("PA_HT");
        listF.add("PV_HT");
        listF.add("PV_TTC");
        ListSQLRequest req = new ListSQLRequest(elementArticle.getTable(), listF){

            @Override
            protected List<SQLRowValues> getValues(Where w) {
                ArrayList<SQLRowValues> v = new ArrayList<SQLRowValues>();
                Where w2 = new Where((FieldRef)elementArticle.getTable().getField("OBSOLETE"), "!=", (Object)Boolean.TRUE);
                w = w == null ? w2 : w.and(w2);
                List<SQLRowValues> all = super.getValues(w);
                HashSet<String> codes = new HashSet<String>();
                int i = 0;
                while (i < all.size()) {
                    SQLRowValues element = all.get(i);
                    String code = element.getString("CODE");
                    if (!codes.contains(code)) {
                        v.add(element);
                        codes.add(code);
                    }
                    ++i;
                }
                return v;
            }
        };
        final IListe list = new IListe(elementArticle.createTableSourceOnline(req));
        IListFrame frame = new IListFrame(new ListeAddPanel(elementArticle, list){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonEffacer) {
                    SQLRow row = this.getListe().fetchSelectedRow();
                    if (row != null && row.getID() > 1) {
                        SQLTable table = row.getTable();
                        SQLSelect sel = new SQLSelect(table.getBase());
                        sel.addSelect(table.getKey());
                        sel.setWhere(new Where((FieldRef)table.getField("CODE"), "=", (Object)row.getString("CODE")));
                        List listRow = (List)table.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(table, true));
                        int size = listRow != null ? listRow.size() : 0;
                        String message = "Voulez vraiment supprimer ";
                        message = String.valueOf(message) + (size > 1 ? "les " + size + " articles r\u00e9f\u00e9renc\u00e9s " : "l'article r\u00e9f\u00e9renc\u00e9 ");
                        message = String.valueOf(message) + "par le code " + row.getString("CODE") + "?";
                        if (JOptionPane.showConfirmDialog(this, message, "Suppression d'une r\u00e9f\u00e9rence", 0) == 0) {
                            for (SQLRow rowInList : listRow) {
                                try {
                                    SQLRowValues rowVals = rowInList.createEmptyUpdateRow();
                                    rowVals.put("OBSOLETE", Boolean.TRUE);
                                    rowVals.update();
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                } else {
                    super.handleAction(source, evt);
                }
            }
        }){

            @Override
            protected void setTitle(boolean displayRowCount, boolean displayItemCount) {
                int rowCount = list.getRowCount();
                String title = "Liste des r\u00e9f\u00e9rences";
                title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
                int total = list.getTotalRowCount();
                if (total != rowCount) {
                    title = String.valueOf(title) + " / " + total;
                }
                this.setTitle(title);
            }
        };
        return frame;
    }
}

