/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import com.ibm.icu.text.DateTimePatternGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.text.DateTimeFormat;
import org.openconcerto.utils.text.DateTimeFormatBuilder;
import org.openconcerto.utils.text.DateTimeFormatComponent;
import org.openconcerto.utils.text.DateTimeSkeleton;

public final class DateProp
extends DateTimeFormatComponent {
    public static final DateProp YEAR = new DateProp("year with four digits");
    public static final DateProp MONTH_NAME = new DateProp("full name of the month");
    public static final DateProp MONTH_NUMBER = new DateProp("2 digits number of the month (starting at 1)");
    public static final DateProp DAY_IN_MONTH = new DateProp("2 digits day number in the month");
    public static final DateProp DAY_NAME_IN_WEEK = new DateProp("full name of day");
    public static final DateProp HOUR = new DateProp("hour in day (00-23)");
    public static final DateProp MINUTE = new DateProp("minute in hour");
    public static final DateProp SECOND = new DateProp("second in minute");
    public static final DateProp MICROSECOND = new DateProp("microseconds (000000-999999)");
    public static final Set<DateProp> ALL_INSTANCES = Collections.unmodifiableSet(new HashSet<DateProp>(Arrays.asList(YEAR, MONTH_NAME, MONTH_NUMBER, DAY_IN_MONTH, DAY_NAME_IN_WEEK, HOUR, MINUTE, SECOND, MICROSECOND)));
    public static final Set<DateProp> LOCALE_SENSITIVE_INSTANCES = Collections.unmodifiableSet(new HashSet<DateProp>(Arrays.asList(MONTH_NAME, DAY_NAME_IN_WEEK)));
    public static final DateTimeSkeleton TIME_SKELETON = DateTimeFormatBuilder.buildSkeleton(HOUR, MINUTE, SECOND);
    public static final DateTimeSkeleton SHORT_DATE_SKELETON = DateTimeFormatBuilder.buildSkeleton(DAY_IN_MONTH, MONTH_NUMBER, YEAR);
    public static final DateTimeSkeleton LONG_DATE_SKELETON = DateTimeFormatBuilder.buildSkeleton(DAY_NAME_IN_WEEK, DAY_IN_MONTH, MONTH_NAME, YEAR);
    public static final DateTimeSkeleton SHORT_DATETIME_SKELETON = DateTimeFormatBuilder.buildSkeleton(DAY_IN_MONTH, MONTH_NUMBER, YEAR, HOUR, MINUTE);
    public static final DateTimeSkeleton LONG_DATETIME_SKELETON = DateTimeFormatBuilder.buildSkeleton(DAY_NAME_IN_WEEK, DAY_IN_MONTH, MONTH_NAME, YEAR, HOUR, MINUTE, SECOND);
    private static final Map<DateProp, String> JAVA_DATE_SPECS_PURE = new HashMap<DateProp, String>();
    public static final Map<DateProp, String> DATE_PROP_TO_JAVA;
    private static final SortedMap<String, DateProp> REVERSE_JAVA_SPEC;
    private static final Pattern REVERSE_SPEC_PATTERN;
    private final String name;

    static {
        JAVA_DATE_SPECS_PURE.put(YEAR, "yyyy");
        JAVA_DATE_SPECS_PURE.put(MONTH_NAME, "MMMM");
        JAVA_DATE_SPECS_PURE.put(MONTH_NUMBER, "MM");
        JAVA_DATE_SPECS_PURE.put(DAY_IN_MONTH, "dd");
        JAVA_DATE_SPECS_PURE.put(DAY_NAME_IN_WEEK, "EEEE");
        JAVA_DATE_SPECS_PURE.put(HOUR, "HH");
        JAVA_DATE_SPECS_PURE.put(MINUTE, "mm");
        JAVA_DATE_SPECS_PURE.put(SECOND, "ss");
        HashMap<DateProp, String> tmp = new HashMap<DateProp, String>(JAVA_DATE_SPECS_PURE);
        tmp.put(MICROSECOND, "SSS000");
        DATE_PROP_TO_JAVA = Collections.unmodifiableMap(tmp);
        assert (DATE_PROP_TO_JAVA.keySet().equals(ALL_INSTANCES));
        TreeMap m = new TreeMap(Collections.reverseOrder());
        REVERSE_JAVA_SPEC = CollectionUtils.invertMap(m, JAVA_DATE_SPECS_PURE);
        assert (REVERSE_JAVA_SPEC.size() == JAVA_DATE_SPECS_PURE.size()) : "Duplicate values";
        assert (!JAVA_DATE_SPECS_PURE.containsKey(null)) : "Null spec";
        assert (!JAVA_DATE_SPECS_PURE.containsValue(null)) : "Null value";
        REVERSE_SPEC_PATTERN = Pattern.compile(CollectionUtils.join(REVERSE_JAVA_SPEC.keySet(), "|"));
    }

    public static String toJavaPattern(List<? extends DateTimeFormatComponent> simpleFormat) {
        StringBuilder sb = new StringBuilder(simpleFormat.size() * 6);
        StringBuilder literalText = new StringBuilder(64);
        for (DateTimeFormatComponent dateTimeFormatComponent : simpleFormat) {
            if (dateTimeFormatComponent instanceof DateTimeFormat.Literal) {
                literalText.append(((DateTimeFormat.Literal)dateTimeFormatComponent).getValue());
                continue;
            }
            String javaComp = Objects.requireNonNull(DATE_PROP_TO_JAVA.get(dateTimeFormatComponent));
            if (literalText.length() > 0) {
                sb.append(StringUtils.singleQuote(literalText.toString()));
                literalText.setLength(0);
            }
            sb.append(javaComp);
        }
        if (literalText.length() > 0) {
            sb.append(StringUtils.singleQuote(literalText.toString()));
        }
        return sb.toString();
    }

    public static String getBestJavaPattern(List<DateProp> simpleFormat, Locale l) {
        StringBuilder sb = new StringBuilder(128);
        for (DateProp p : simpleFormat) {
            String javaComp = JAVA_DATE_SPECS_PURE.get(p);
            if (javaComp != null) {
                sb.append(javaComp);
                continue;
            }
            throw new IllegalArgumentException("Unsupported spec : " + p);
        }
        return DateTimePatternGenerator.getInstance(l).getBestPattern(sb.toString(), 65535);
    }

    public static DateTimeFormat getBestPattern(List<DateProp> simpleFormat, Locale l) {
        return DateProp.parseJavaPattern(DateProp.getBestJavaPattern(simpleFormat, l));
    }

    static DateTimeFormat parseJavaPattern(String bestPattern) {
        Matcher matcher = REVERSE_SPEC_PATTERN.matcher(bestPattern);
        Matcher quotedMatcher = StringUtils.SINGLE_QUOTED_PATTERN.matcher(bestPattern);
        DateTimeFormatBuilder res = new DateTimeFormatBuilder();
        int index = 0;
        while (index < bestPattern.length()) {
            int quoteIndex = bestPattern.indexOf(39, index);
            int endSansQuote = quoteIndex < 0 ? bestPattern.length() : quoteIndex;
            matcher.region(index, endSansQuote);
            while (matcher.find()) {
                if (index < matcher.start()) {
                    res.addLiteral(bestPattern.substring(index, matcher.start()));
                }
                res.add((DateTimeFormatComponent)REVERSE_JAVA_SPEC.get(matcher.group()));
                index = matcher.end();
            }
            assert (index <= endSansQuote) : "region() failed";
            if (index < endSansQuote) {
                res.addLiteral(bestPattern.substring(index, endSansQuote));
            }
            if ((index = endSansQuote) >= bestPattern.length()) continue;
            quotedMatcher.region(index, bestPattern.length());
            if (!quotedMatcher.find() || quotedMatcher.start() != quotedMatcher.regionStart()) {
                throw new IllegalStateException("Quoted string error : " + bestPattern.substring(quoteIndex));
            }
            res.addLiteral(StringUtils.unSingleQuote(quotedMatcher));
            index = quotedMatcher.end();
        }
        return res.build();
    }

    private DateProp(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ' ' + this.getName();
    }
}

