/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group.modifier;

import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.GroupModifier;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.modifier.HierarchyModifier;

public class MoveAfterItemModifier
extends HierarchyModifier {
    private String afterId;

    public MoveAfterItemModifier(String itemId, String afterId) {
        super(itemId);
        if (afterId == null) {
            throw new IllegalArgumentException("null afterId");
        }
        this.afterId = afterId;
    }

    @Override
    public void applyOn(Group g) {
        Item i = g.getDescFromID(this.getItemId());
        i.getParent().remove(this.getItemId());
        Group p = g.getDescFromID(this.afterId).getParent();
        int index1 = p.getIndex(this.afterId);
        Integer order1 = p.getOrder(index1);
        Integer order2 = order1 + 200;
        if (index1 < p.getSize() - 1) {
            order2 = p.getOrder(index1 + 1);
        }
        p.add(i, (order1 + order2) / 2);
    }

    @Override
    public boolean canBeAppliedOn(Group g) {
        return g.contains(this.afterId) && g.contains(this.getItemId());
    }

    @Override
    public boolean isCompatibleWith(GroupModifier g) {
        HierarchyModifier gr;
        return !(g instanceof HierarchyModifier) || !(gr = (HierarchyModifier)g).getItemId().equals(this.getItemId());
    }
}

