/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.action;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;

public class ListeDesCommandesAction
extends CreateFrameAbstractAction {
    BigDecimal bigDecimal100 = new BigDecimal(100.0);

    public ListeDesCommandesAction() {
        this.putValue("Name", "Liste des commandes fournisseurs");
    }

    @Override
    public JFrame createFrame() {
        final SQLElement elementCmd = Configuration.getInstance().getDirectory().getElement("COMMANDE");
        SQLTableModelSourceOnline tableSource = elementCmd.getTableSource(true);
        BaseSQLTableModelColumn colAvancementR = new BaseSQLTableModelColumn("Avancement r\u00e9ception", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesCommandesAction.this.getAvancementLFromBR(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)new PathBuilder(elementCmd.getTable()).addTable("COMMANDE_ELEMENT")).build();
                return CollectionUtils.createSet(new FieldPath(p, "RECU_FORCED"), new FieldPath(p, "RECU"), new FieldPath(p, "QTE_RECUE"), new FieldPath(p, "PA_HT"), new FieldPath(p, "ID_ARTICLE"), new FieldPath(p, "QTE"), new FieldPath(p, "QTE_UNITAIRE"));
            }
        };
        tableSource.getColumns().add(colAvancementR);
        colAvancementR.setRenderer(new PercentTableCellRenderer());
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Avancement facturation", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesCommandesAction.this.getAvancementFact(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)((PathBuilder)new PathBuilder(elementCmd.getTable()).addTable("TR_COMMANDE")).addTable("SAISIE_ACHAT")).build();
                Path p2 = ((PathBuilder)((PathBuilder)new PathBuilder(elementCmd.getTable()).addTable("TR_COMMANDE")).addTable("FACTURE_FOURNISSEUR")).build();
                Path pBr = ((PathBuilder)((PathBuilder)new PathBuilder(elementCmd.getTable()).addTable("TR_COMMANDE")).addTable("BON_RECEPTION")).build();
                Path trBr = (Path)pBr.add(elementCmd.getTable().getTable("TR_BON_RECEPTION"));
                Path pFact2 = (Path)trBr.addTable("FACTURE_FOURNISSEUR");
                Path pAchat2 = (Path)trBr.addTable("SAISIE_ACHAT");
                return CollectionUtils.createSet(new FieldPath(p, "MONTANT_HT"), new FieldPath(p2, "T_HT"), new FieldPath(pAchat2, "MONTANT_HT"), new FieldPath(pFact2, "T_HT"));
            }
        };
        tableSource.getColumns().add(colAvancement);
        colAvancement.setRenderer(new PercentTableCellRenderer());
        ListeAddPanel panel = new ListeAddPanel(elementCmd, new IListe(tableSource));
        HashMap<IListe, SQLField> map = new HashMap<IListe, SQLField>();
        map.put(panel.getListe(), elementCmd.getTable().getField("DATE"));
        IListFilterDatePanel datePanel = new IListFilterDatePanel(map, IListFilterDatePanel.getDefaultMap());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        c.fill = 0;
        c.gridy = 4;
        c.anchor = 10;
        c.weighty = 0.0;
        datePanel.setFilterOnDefault();
        panel.add((Component)datePanel, c);
        IListFrame frame = new IListFrame(panel);
        return frame;
    }

    private BigDecimal getAvancementLFromBR(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("COMMANDE_ELEMENT"));
        BigDecimal totalQte = BigDecimal.ZERO;
        BigDecimal totalQteL = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            BigDecimal qteLivree;
            BigDecimal qte = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE")));
            if (sQLRowAccessor.isForeignEmpty("ID_ARTICLE") && sQLRowAccessor.getBigDecimal("PA_HT").signum() == 0) continue;
            totalQte = totalQte.add(qte);
            if (sQLRowAccessor.getBoolean("RECU_FORCED").booleanValue() || sQLRowAccessor.getBoolean("RECU").booleanValue()) {
                totalQteL = totalQteL.add(qte);
                continue;
            }
            if (sQLRowAccessor.getBigDecimal("QTE_RECUE") == null || (qteLivree = sQLRowAccessor.getBigDecimal("QTE_RECUE")) == null) continue;
            totalQteL = totalQteL.add(qteLivree);
        }
        if (totalQte.signum() != 0) {
            return totalQteL.divide(totalQte, DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private BigDecimal getAvancementFact(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_COMMANDE"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowFact;
            if (!sQLRowAccessor.isForeignEmpty("ID_FACTURE_FOURNISSEUR")) {
                rowFact = sQLRowAccessor.getForeign("ID_FACTURE_FOURNISSEUR");
                Long l = rowFact.getLong("T_HT");
                totalFact += l.longValue();
            }
            if (!sQLRowAccessor.isForeignEmpty("ID_SAISIE_ACHAT")) {
                rowFact = sQLRowAccessor.getForeign("ID_SAISIE_ACHAT");
                Long l = rowFact.getLong("MONTANT_HT");
                totalFact += l.longValue();
            }
            if (sQLRowAccessor.isForeignEmpty("ID_BON_RECEPTION")) continue;
            Collection<? extends SQLRowAccessor> rowsBr = sQLRowAccessor.getForeign("ID_BON_RECEPTION").getReferentRows(r.getTable().getTable("TR_BON_RECEPTION"));
            for (SQLRowAccessor sQLRowAccessor2 : rowsBr) {
                if (!sQLRowAccessor2.isForeignEmpty("ID_FACTURE_FOURNISSEUR")) {
                    SQLRowAccessor rowFact2 = sQLRowAccessor2.getForeign("ID_FACTURE_FOURNISSEUR");
                    Long l2 = rowFact2.getLong("T_HT");
                    totalFact += l2.longValue();
                }
                if (sQLRowAccessor2.isForeignEmpty("ID_SAISIE_ACHAT")) continue;
                SQLRowAccessor rowFact2 = sQLRowAccessor2.getForeign("ID_SAISIE_ACHAT");
                Long l = rowFact2.getLong("MONTANT_HT");
                totalFact += l.longValue();
            }
        }
        if (total > 0L) {
            return this.bigDecimal100.min(new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP));
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_COMMANDE"));
        long totalFact = 0L;
        long total = r.getLong("T_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_BON_RECEPTION")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_BON_RECEPTION");
            Long l = rowFact.getLong("TOTAL_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }
}

